/*
 * Decompiled with CFR 0.152.
 */
package com.sardak.antform.util;

import com.sardak.antform.AbstractTaskWindow;
import com.sardak.antform.interfaces.ActionComponent;
import com.sardak.antform.util.TargetInvoker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;

public class ActionRegistry
implements ActionListener {
    private Map actionComponents = new HashMap();
    private AbstractTaskWindow task;

    public ActionRegistry(AbstractTaskWindow task) {
        this.task = task;
    }

    public void register(ActionComponent component) {
        this.actionComponents.put(component.getComponent(), component);
        component.getComponent().addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        ActionComponent source = (ActionComponent)this.actionComponents.get(e.getSource());
        if (source == null) {
            throw new BuildException("Received event from unknown source.");
        }
        if (source.getActionType() == 0) {
            if (!this.task.requiredStatusOk()) {
                return;
            }
            this.task.ok();
            this.runTarget(source);
        } else if (source.getActionType() == 1) {
            this.task.cancel();
            this.runTarget(source);
        } else if (source.getActionType() == 2) {
            this.task.reset();
        }
    }

    private void runTarget(ActionComponent source) {
        if (source.isBackground() && source.getTarget() != null) {
            if (this.task.findTargetByName(source.getTarget()) != null) {
                TargetInvoker invoker = new TargetInvoker(this.task, source);
                invoker.perform();
            }
        } else {
            this.task.setActionSource(source);
            this.task.getControl().close();
        }
    }
}

