/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;

public class Switch
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Switch();

    public String parseFunction(char[] src, int beginIndex, int endIndex, IWikiModel model) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        WikipediaScanner.splitByPipe(src, beginIndex, endIndex, list);
        if (list.size() > 2) {
            String first = this.parse((String)list.get(0), model);
            String conditionString = first.trim();
            boolean valueFound = false;
            int i = 1;
            while (i < list.size()) {
                String leftHandSide;
                String temp = this.parse((String)list.get(i), model);
                int index = temp.indexOf(61);
                if (index >= 0) {
                    if (valueFound) {
                        return temp.substring(index + 1).trim();
                    }
                    leftHandSide = temp.substring(0, index).trim();
                } else {
                    leftHandSide = temp.trim();
                }
                String parsedLHS = this.parse(leftHandSide, model);
                if (this.equalsTypes(conditionString, parsedLHS)) {
                    if (index >= 0) {
                        return temp.substring(index + 1).trim();
                    }
                    valueFound = true;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean equalsTypes(String first, String second) {
        boolean result = false;
        if (first.length() == 0) {
            return second.length() == 0;
        }
        if (second.length() == 0) {
            return first.length() == 0;
        }
        if (first.charAt(0) == '+') {
            first = first.substring(1);
        }
        if (second.charAt(0) == '+') {
            second = second.substring(1);
        }
        try {
            double d1 = Double.parseDouble(first);
            double d2 = Double.parseDouble(second);
            if (d1 == d2) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = first.equals(second);
        }
        return result;
    }
}

