/*
 * Decompiled with CFR 0.152.
 */
package fmpp.util;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiListIterator
implements Iterator {
    private List[] lists = new List[6];
    private int listCount;
    private int currentList;
    private Iterator currentIterator;

    public MultiListIterator() {
    }

    public MultiListIterator(List ls1) {
        this.addList(ls1);
    }

    public MultiListIterator(List ls1, List ls2) {
        this.addList(ls1);
        this.addList(ls2);
    }

    public MultiListIterator(List ls1, List ls2, List ls3) {
        this.addList(ls1);
        this.addList(ls2);
        this.addList(ls3);
    }

    public MultiListIterator(List ls1, List ls2, List ls3, List ls4) {
        this.addList(ls1);
        this.addList(ls2);
        this.addList(ls3);
        this.addList(ls4);
    }

    public void addList(List ls) {
        if (ls.size() != 0) {
            if (this.listCount == this.lists.length) {
                List[] newLists = new List[this.listCount * 2];
                System.arraycopy(this.lists, 0, newLists, 0, this.listCount);
                this.lists = newLists;
            }
            this.lists[this.listCount++] = ls;
        }
    }

    public boolean hasNext() {
        boolean hasNext;
        if (this.currentIterator == null) {
            if (this.listCount != 0) {
                this.currentIterator = this.lists[0].iterator();
            } else {
                return false;
            }
        }
        if (!(hasNext = this.currentIterator.hasNext()) && this.currentList < this.listCount - 1) {
            return true;
        }
        return hasNext;
    }

    public Object next() {
        if (this.currentIterator == null) {
            if (this.listCount != 0) {
                this.currentIterator = this.lists[0].iterator();
            } else {
                throw new NoSuchElementException("No next element; the list is empty.");
            }
        }
        if (this.currentIterator.hasNext() || this.currentList == this.listCount - 1) {
            return this.currentIterator.next();
        }
        ++this.currentList;
        this.currentIterator = this.lists[this.currentList].iterator();
        return this.currentIterator.next();
    }

    public void remove() {
        this.currentIterator.remove();
    }
}

