/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.docbook;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class FormattingXMLStreamWriter
implements XMLStreamWriter {
    private XMLStreamWriter delegate;
    private int indentLevel;
    private Stack<Integer> childCounts = new Stack();
    private int childCount;

    public FormattingXMLStreamWriter(XMLStreamWriter delegate) {
        this.delegate = delegate;
    }

    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, uri);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (value == null) {
            value = "";
        }
        this.delegate.writeAttribute(localName, value);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if (text == null) {
            return;
        }
        this.delegate.writeCharacters(text);
    }

    public void writeComment(String data) throws XMLStreamException {
        if (data == null) {
            data = "";
        }
        this.delegate.writeComment(data);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(namespaceURI);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.delegate.writeEmptyElement(localName);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        --this.indentLevel;
        this.maybeIndent();
        this.delegate.writeEndElement();
        this.childCount = this.childCounts.pop();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, namespaceURI);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(prefix, localName, namespaceURI);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        ++this.childCount;
        this.maybeIndent();
        this.childCounts.push(this.childCount);
        this.childCount = 0;
        ++this.indentLevel;
        this.delegate.writeStartElement(localName);
    }

    private void maybeIndent() throws XMLStreamException {
        if (this.childCount == 0) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append('\n');
        int x = 0;
        while (x < this.indentLevel) {
            buf.append('\t');
            ++x;
        }
        this.writeCharacters(buf.toString());
    }
}

