/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.latex;

import info.bliki.wiki.model.WikiModel;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;

public class PropertyManager {
    private static String prefix = "";
    private static Properties props = null;
    private static final String RESOURCE_NAME = "/latex.properties";

    static {
        try {
            Class<WikiModel> config_class = WikiModel.class;
            InputStream is = config_class.getClass().getResourceAsStream(RESOURCE_NAME);
            props = new Properties();
            props.load(is);
            prefix = "latex.";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String get(String key) {
        if (props == null) {
            throw new RuntimeException("PropertyManager not initialized");
        }
        return props.getProperty(String.valueOf(prefix) + key);
    }

    public static String get(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return PropertyManager.get(key, args);
    }

    public static String get(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return PropertyManager.get(key, args);
    }

    public static String get(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return PropertyManager.get(key, args);
    }

    public static String get(String key, Object[] args) {
        String str = null;
        String value = PropertyManager.get(key);
        try {
            str = MessageFormat.format(value, args);
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        return str;
    }

    public static Properties getProperties() {
        return props;
    }
}

