/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuppressionsLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Suppressions 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/suppressions_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Suppressions 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/suppressions_1_1.dtd";
    private final FilterSet mFilterChain = new FilterSet();

    private SuppressionsLoader() throws ParserConfigurationException, SAXException {
        super(SuppressionsLoader.createIdToResourceNameMap());
    }

    public FilterSet getFilterChain() {
        return this.mFilterChain;
    }

    @Override
    public void startElement(String aNamespaceURI, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        if ("suppress".equals(aQName)) {
            String columns;
            SuppressElement suppress;
            String files = aAtts.getValue("files");
            if (files == null) {
                throw new SAXException("missing files attribute");
            }
            String checks = aAtts.getValue("checks");
            String modId = aAtts.getValue("id");
            if (checks == null && modId == null) {
                throw new SAXException("missing checks and id attribute");
            }
            try {
                suppress = new SuppressElement(files);
                if (modId != null) {
                    suppress.setModuleId(modId);
                }
                if (checks != null) {
                    suppress.setChecks(checks);
                }
            }
            catch (PatternSyntaxException e) {
                throw new SAXException("invalid files or checks format");
            }
            String lines = aAtts.getValue("lines");
            if (lines != null) {
                suppress.setLines(lines);
            }
            if ((columns = aAtts.getValue("columns")) != null) {
                suppress.setColumns(columns);
            }
            this.mFilterChain.addFilter(suppress);
        }
    }

    public static FilterSet loadSuppressions(String aFilename) throws CheckstyleException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(aFilename);
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aFilename, e);
        }
        InputSource source = new InputSource(fis);
        return SuppressionsLoader.loadSuppressions(source, aFilename);
    }

    private static FilterSet loadSuppressions(InputSource aSource, String aSourceName) throws CheckstyleException {
        try {
            SuppressionsLoader suppressionsLoader = new SuppressionsLoader();
            suppressionsLoader.parseInputSource(aSource);
            return suppressionsLoader.getFilterChain();
        }
        catch (FileNotFoundException e) {
            throw new CheckstyleException("unable to find " + aSourceName, e);
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to parse " + aSourceName, e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + aSourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + aSourceName, e);
        }
        catch (NumberFormatException e) {
            throw new CheckstyleException("number format exception " + aSourceName + " - " + e.getMessage(), e);
        }
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap<String, String> map = Maps.newHashMap();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        return map;
    }
}

