/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.metadata.ant.types;

import com.nokia.helium.jpa.entity.metadata.Metadata;
import com.nokia.helium.metadata.ant.types.SBSLogMetaDataInput;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

class WhatLogHandler {
    private static final String MEMBER_REGEX = "^[a-zA-Z]:\\S+$";
    private String currentComponent;
    private Metadata.WhatEntry currentEntry;
    private boolean inWhatLog;
    private boolean entryAdded;
    private Pattern memberPattern;
    private List<Metadata.WhatLogMember> members = new ArrayList<Metadata.WhatLogMember>();
    private XMLInputFactory xmlInputFactory;
    private XMLStreamReader xmlStreamReader;
    private File whatLogFile;
    private Logger log = Logger.getLogger(WhatLogHandler.class);

    public WhatLogHandler(File logFile) {
        this.whatLogFile = logFile;
        this.log.debug((Object)("what log file: " + this.whatLogFile));
        this.memberPattern = Pattern.compile(MEMBER_REGEX);
        if (this.whatLogFile != null) {
            try {
                this.xmlInputFactory = XMLInputFactory.newInstance();
                this.xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(this.whatLogFile.toString(), new BufferedInputStream(new FileInputStream(this.whatLogFile)));
            }
            catch (Exception ex) {
                this.log.debug((Object)"exception while initializing stax processor", (Throwable)ex);
            }
        }
    }

    public String getLogFile() {
        return this.whatLogFile.toString();
    }

    public void resetMembers() {
        this.members.clear();
    }

    public int getLineNumber() {
        if (this.xmlStreamReader != null) {
            this.log.debug((Object)("what log file line number: " + this.xmlStreamReader.getLocation().getLineNumber()));
            return this.xmlStreamReader.getLocation().getLineNumber();
        }
        return -1;
    }

    public boolean startElement(XMLStreamReader streamReader) throws Exception {
        String tagName = streamReader.getLocalName();
        if (tagName.equals("whatlog")) {
            this.currentComponent = SBSLogMetaDataInput.getComponent(streamReader);
            this.log.debug((Object)("what log file current component: " + this.currentComponent));
            if (this.currentComponent != null) {
                this.currentComponent = SBSLogMetaDataInput.removeDriveAndBldInf(this.currentComponent);
            }
            this.inWhatLog = true;
        } else if (tagName.equals("export")) {
            String text = SBSLogMetaDataInput.getAttribute("destination", streamReader);
            this.log.debug((Object)("what log file in export: text: " + text));
            if (text != null) {
                String member = SBSLogMetaDataInput.removeDriveAndBldInf(text);
                boolean exists = new File(member).exists();
                this.members.add(new Metadata.WhatLogMember(member, exists));
            }
        }
        return false;
    }

    public boolean endElement(XMLStreamReader streamReader) throws Exception {
        String tagName = streamReader.getLocalName();
        if (tagName.equals("whatlog")) {
            this.log.debug((Object)"what log file in entry found returning true:");
            this.inWhatLog = false;
            if (this.members != null && !this.members.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private String characters(XMLStreamReader xmlStreamReader) {
        if (this.inWhatLog) {
            String[] textList;
            String fullText = xmlStreamReader.getText();
            for (String text : textList = fullText.split("\n")) {
                String member = this.getMember(text);
                if (member == null) continue;
                boolean exists = new File(member).exists();
                String actualText = SBSLogMetaDataInput.removeDriveAndBldInf(member);
                this.members.add(new Metadata.WhatLogMember(actualText, exists));
            }
        }
        return null;
    }

    private String getMember(String text) {
        if (this.memberPattern.matcher(text).matches()) {
            return text;
        }
        return null;
    }

    public Metadata.WhatEntry getNext() {
        return this.currentEntry;
    }

    public boolean hasNext() throws Exception {
        try {
            boolean entryAvailable = false;
            if (this.xmlStreamReader != null) {
                while (this.xmlStreamReader.hasNext()) {
                    int eventType = this.xmlStreamReader.next();
                    switch (eventType) {
                        case 1: {
                            this.startElement(this.xmlStreamReader);
                            break;
                        }
                        case 2: {
                            entryAvailable = this.endElement(this.xmlStreamReader);
                            if (!entryAvailable || this.members == null || this.members.isEmpty()) break;
                            this.currentEntry = new Metadata.WhatEntry(this.currentComponent, this.members);
                            if (!this.entryAdded) {
                                this.entryAdded = true;
                            }
                            return true;
                        }
                        case 4: {
                            this.characters(this.xmlStreamReader);
                            break;
                        }
                    }
                }
                if (!this.entryAdded) {
                    this.currentEntry = new Metadata.WhatEntry("general", null);
                    this.entryAdded = true;
                    return true;
                }
                if (this.xmlStreamReader != null) {
                    this.close();
                }
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception in categorization", (Throwable)ex);
            throw ex;
        }
        return false;
    }

    private void close() {
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
                this.xmlStreamReader = null;
            }
        }
        catch (Exception ex) {
            this.log.debug((Object)"exception while closing xml stream", (Throwable)ex);
        }
    }
}

