/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.docbook;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class HtmlToDocbookContentHandler
implements ContentHandler {
    private BookEmitter bookEmitter = new BookEmitter();
    private NestingEmitter emitter = this.bookEmitter;
    private XMLStreamWriter writer;
    private String doctype = "<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook XML V4.5//EN\" \"http://www.oasis-open.org/docbook/xml/4.5/docbookx.dtd\">";
    private Map<String, String> acronyms = new HashMap<String, String>();

    public HtmlToDocbookContentHandler(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public HtmlToDocbookContentHandler() {
    }

    private Emitter newEmitter(String elementName) {
        if ("p".equals(elementName)) {
            return new SimpleMappingEmitter("para");
        }
        if ("acronym".equals(elementName)) {
            return new GlosstermEmitter();
        }
        if ("a".equals(elementName)) {
            return new AnchorEmitter();
        }
        if ("img".equals(elementName)) {
            return new ImageEmitter();
        }
        if ("ul".equals(elementName)) {
            return new SimpleMappingEmitter("itemizedlist");
        }
        if ("ol".equals(elementName)) {
            return new SimpleMappingEmitter("orderedlist");
        }
        if ("li".equals(elementName)) {
            return new SimpleMappingEmitter("listitem", "para");
        }
        if ("em".equals(elementName)) {
            return new SimpleMappingEmitter("emphasis");
        }
        if ("strong".equals(elementName) || "b".equals(elementName)) {
            SimpleMappingEmitter emitter = new SimpleMappingEmitter("emphasis");
            emitter.setAttribute("role", "bold");
            return emitter;
        }
        if (elementName.matches("h\\d")) {
            return new HeaderEmitter(Integer.parseInt(elementName.substring(1)));
        }
        if ("i".equals(elementName)) {
            SimpleMappingEmitter emitter = new SimpleMappingEmitter("emphasis");
            emitter.setAttribute("role", "italic");
            return emitter;
        }
        if ("cite".equals(elementName)) {
            return new SimpleMappingEmitter("citation");
        }
        if ("code".equals(elementName)) {
            return new SimpleMappingEmitter("code");
        }
        if ("pre".equals(elementName)) {
            return new SimpleMappingEmitter("literallayout");
        }
        if ("del".equals(elementName)) {
            SimpleMappingEmitter emitter = new SimpleMappingEmitter("emphasis");
            emitter.setAttribute("role", "del");
            return emitter;
        }
        if ("ins".equals(elementName)) {
            SimpleMappingEmitter emitter = new SimpleMappingEmitter("emphasis");
            emitter.setAttribute("role", "ins");
            return emitter;
        }
        if ("sup".equals(elementName)) {
            return new SimpleMappingEmitter("superscript");
        }
        if ("sub".equals(elementName)) {
            return new SimpleMappingEmitter("subscript");
        }
        return new NestingEmitter(null, null);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.emitter.content(this.writer, ch, start, length);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.emitter.close();
            this.emitter = null;
            this.writer.writeEndDocument();
            this.acronyms.clear();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.emitter.end(this.writer, localName)) {
                this.emitter.close();
                this.emitter = new NestingEmitter(null, null);
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.writeStartDocument();
            this.writer.writeDTD(this.doctype);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            if (!this.emitter.start(this.writer, localName, atts)) {
                throw new IllegalStateException();
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getBookTitle() {
        return this.bookEmitter.getBookTitle();
    }

    public void setBookTitle(String bookTitle) {
        this.bookEmitter.setBookTitle(bookTitle);
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    public void setWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    private class AnchorEmitter
    extends NestingEmitter {
        private boolean openTag;

        public AnchorEmitter() {
            this.openTag = false;
        }

        public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            String href = null;
            String name = null;
            if (htmlElementName.equals("a")) {
                href = atts.getValue("href");
                name = atts.getValue("name");
            }
            if (name != null && name.length() > 0) {
                this.openTag = true;
                writer.writeStartElement("phrase");
                writer.writeAttribute("id", name);
            } else if (href != null) {
                if (href.startsWith("#")) {
                    if (href.length() > 1) {
                        this.openTag = true;
                        writer.writeStartElement("link");
                        writer.writeAttribute("linkend", href.substring(1));
                    }
                } else {
                    this.openTag = true;
                    writer.writeStartElement("ulink");
                    writer.writeAttribute("url", href);
                }
            }
            return true;
        }

        protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            this.closeTag(writer);
            return true;
        }

        private void closeTag(XMLStreamWriter writer) throws XMLStreamException {
            if (this.openTag) {
                writer.writeEndElement();
                this.openTag = false;
            }
        }

        public void close() throws XMLStreamException {
            super.close();
            this.closeTag(HtmlToDocbookContentHandler.this.writer);
        }
    }

    private class BookEmitter
    extends SimpleMappingEmitter {
        private String bookTitle;

        private BookEmitter() {
            super("book");
        }

        public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            boolean ok = super.localStart(writer, htmlElementName, atts);
            if (ok && this.bookTitle != null) {
                writer.writeStartElement("title");
                writer.writeCharacters(this.bookTitle);
                writer.writeEndElement();
            }
            return ok;
        }

        protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            if (!HtmlToDocbookContentHandler.this.acronyms.isEmpty()) {
                writer.writeStartElement("appendix");
                writer.writeAttribute("id", "glossary");
                writer.writeStartElement("title");
                writer.writeAttribute("id", "glossary-end");
                writer.writeCharacters("Glossary");
                writer.writeEndElement();
                writer.writeStartElement("glosslist");
                for (Map.Entry glossEntry : new TreeMap(HtmlToDocbookContentHandler.this.acronyms).entrySet()) {
                    writer.writeStartElement("glossentry");
                    writer.writeStartElement("glossterm");
                    writer.writeCharacters((String)glossEntry.getKey());
                    writer.writeEndElement();
                    writer.writeStartElement("glossdef");
                    writer.writeStartElement("para");
                    writer.writeCharacters((String)glossEntry.getValue());
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
            return super.localEnd(writer, htmlElementName);
        }

        public String getBookTitle() {
            return this.bookTitle;
        }

        public void setBookTitle(String bookTitle) {
            this.bookTitle = bookTitle;
        }

        protected boolean permitsMultipleNexting() {
            return true;
        }
    }

    private static interface Emitter {
        public boolean start(XMLStreamWriter var1, String var2, Attributes var3) throws XMLStreamException;

        public void content(XMLStreamWriter var1, char[] var2, int var3, int var4) throws XMLStreamException;

        public boolean end(XMLStreamWriter var1, String var2) throws XMLStreamException;

        public void close() throws XMLStreamException;
    }

    private class GlosstermEmitter
    extends SimpleMappingEmitter {
        private String acronymTitle;
        private StringBuilder acronym;

        public GlosstermEmitter() {
            super("glossterm");
            this.acronym = new StringBuilder();
        }

        protected void localContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
            if (length > 0) {
                this.acronym.append(ch, start, length);
            }
            super.localContent(writer, ch, start, length);
        }

        public boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            String previousTitle;
            String acronym;
            if (this.acronym.length() > 0 && (acronym = this.acronym.toString().trim()).length() > 0 && (previousTitle = HtmlToDocbookContentHandler.this.acronyms.put(acronym, this.acronymTitle)) != null && (this.acronymTitle == null || previousTitle.length() > this.acronymTitle.length())) {
                HtmlToDocbookContentHandler.this.acronyms.put(acronym, previousTitle);
            }
            return super.localEnd(writer, htmlElementName);
        }

        public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            if (htmlElementName.equals("acronym")) {
                this.acronymTitle = atts.getValue("title");
            }
            return super.localStart(writer, htmlElementName, atts);
        }
    }

    private class HeaderEmitter
    implements Emitter {
        private Pattern HEADER_ELEM_NAME_PATTERN = Pattern.compile("h(\\d)");
        private Emitter next;
        private int nestLevel = 0;
        private final int headerLevel;
        private String sectionName;
        private boolean dispatching = false;
        private boolean sectionOpen = false;

        public HeaderEmitter(int headerLevel) {
            this.headerLevel = headerLevel;
            this.sectionName = headerLevel == 1 ? "chapter" : "section";
        }

        public void content(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
            if (!this.dispatching && this.nestLevel == 1) {
                writer.writeCharacters(ch, start, length);
            } else {
                this.dispatchContent(writer, ch, start, length);
            }
        }

        public boolean end(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            --this.nestLevel;
            if (!this.dispatching && this.nestLevel == 0) {
                this.closeTitle();
                this.dispatching = true;
            } else {
                this.dispatchEnd(writer, htmlElementName);
            }
            return false;
        }

        public boolean start(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            ++this.nestLevel;
            if (!this.dispatching && this.nestLevel == 1) {
                this.openSection(atts);
            } else {
                int localLevel;
                Matcher matcher = this.HEADER_ELEM_NAME_PATTERN.matcher(htmlElementName);
                if (matcher.matches() && (localLevel = Integer.parseInt(matcher.group(1))) <= this.headerLevel) {
                    this.closeSection();
                    return false;
                }
                this.dispatchStart(writer, htmlElementName, atts);
            }
            return true;
        }

        private void dispatchStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            if (this.next == null) {
                this.next = HtmlToDocbookContentHandler.this.newEmitter(htmlElementName);
            }
            if (!this.next.start(writer, htmlElementName, atts)) {
                this.next.close();
                this.next = HtmlToDocbookContentHandler.this.newEmitter(htmlElementName);
                if (!this.next.start(writer, htmlElementName, atts)) {
                    throw new IllegalStateException();
                }
            }
        }

        private void dispatchEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            if (this.next != null) {
                if (this.next.end(writer, htmlElementName)) {
                    this.next.close();
                    this.next = null;
                }
            } else {
                throw new IllegalStateException();
            }
        }

        private void dispatchContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
            if (this.next != null) {
                this.next.content(writer, ch, start, length);
            } else {
                writer.writeCharacters(ch, start, length);
            }
        }

        private void openSection(Attributes atts) throws XMLStreamException {
            this.sectionOpen = true;
            HtmlToDocbookContentHandler.this.writer.writeStartElement(this.sectionName);
            HtmlToDocbookContentHandler.this.writer.writeStartElement("title");
            String elementId = atts.getValue("id");
            if (elementId != null) {
                HtmlToDocbookContentHandler.this.writer.writeAttribute("id", elementId);
            }
        }

        private void closeSection() throws XMLStreamException {
            if (this.next != null) {
                this.next.close();
                this.next = null;
            }
            HtmlToDocbookContentHandler.this.writer.writeEndElement();
            this.next = null;
            this.dispatching = false;
            this.sectionOpen = false;
        }

        private void closeTitle() throws XMLStreamException {
            HtmlToDocbookContentHandler.this.writer.writeEndElement();
        }

        public void close() throws XMLStreamException {
            if (this.next != null) {
                this.next.close();
                this.next = null;
            }
            if (this.sectionOpen) {
                this.closeSection();
            }
        }
    }

    private class ImageEmitter
    extends SimpleMappingEmitter {
        public ImageEmitter() {
            super("mediaobject", "imageobject", "imagedata");
        }

        public boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            boolean ok;
            String src = null;
            if (htmlElementName.equals("img")) {
                src = atts.getValue("src");
            }
            if ((ok = super.localStart(writer, htmlElementName, atts)) && src != null) {
                writer.writeAttribute("fileref", src);
            }
            return ok;
        }
    }

    private class NestingEmitter
    implements Emitter {
        private Emitter next = null;
        private String elementName = null;
        private int nestLevel = 0;

        private NestingEmitter() {
        }

        public void content(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
            if (this.next != null) {
                this.next.content(writer, ch, start, length);
            } else {
                this.localContent(writer, ch, start, length);
            }
        }

        public final boolean end(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            --this.nestLevel;
            if (this.nestLevel > 0 && this.next != null) {
                if (this.next.end(writer, htmlElementName)) {
                    this.next.close();
                    this.next = null;
                }
                return false;
            }
            if (this.next != null) {
                this.next.close();
                this.next = null;
            }
            return this.localEnd(writer, htmlElementName);
        }

        protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            return true;
        }

        protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            return true;
        }

        protected void localContent(XMLStreamWriter writer, char[] ch, int start, int length) throws XMLStreamException {
            writer.writeCharacters(ch, start, length);
        }

        public final boolean start(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            ++this.nestLevel;
            if (this.elementName == null) {
                this.elementName = htmlElementName;
                return this.localStart(writer, htmlElementName, atts);
            }
            if (this.next == null) {
                this.next = HtmlToDocbookContentHandler.this.newEmitter(htmlElementName);
            }
            if (!this.next.start(writer, htmlElementName, atts)) {
                this.next.close();
                this.next = null;
                if (this.permitsMultipleNexting()) {
                    this.next = HtmlToDocbookContentHandler.this.newEmitter(htmlElementName);
                    if (!this.next.start(writer, htmlElementName, atts)) {
                        throw new IllegalStateException();
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        protected boolean permitsMultipleNexting() {
            return true;
        }

        public void close() throws XMLStreamException {
            if (this.next != null) {
                this.next.close();
                this.next = null;
            }
        }

        /* synthetic */ NestingEmitter(NestingEmitter nestingEmitter, NestingEmitter nestingEmitter2) {
            this();
        }
    }

    private class SimpleMappingEmitter
    extends NestingEmitter {
        private final String[] tags;
        private Map<String, String> attributes;

        public SimpleMappingEmitter(String ... docbookTagNames) {
            this.tags = docbookTagNames;
        }

        public void setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new TreeMap<String, String>();
            }
            this.attributes.put(name, value);
        }

        protected boolean localEnd(XMLStreamWriter writer, String htmlElementName) throws XMLStreamException {
            int x = 0;
            while (x < this.tags.length) {
                writer.writeEndElement();
                ++x;
            }
            return true;
        }

        protected boolean localStart(XMLStreamWriter writer, String htmlElementName, Attributes atts) throws XMLStreamException {
            String elementId;
            String[] stringArray = this.tags;
            int n = this.tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                writer.writeStartElement(tag);
                ++n2;
            }
            boolean hasId = false;
            if (this.attributes != null) {
                for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
                    writer.writeAttribute(attr.getKey(), attr.getValue());
                }
                if (this.attributes.containsKey("id")) {
                    hasId = true;
                }
            }
            if (!hasId && (elementId = atts.getValue("id")) != null) {
                writer.writeAttribute("id", elementId);
            }
            return true;
        }
    }
}

