/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.helium.core.ant.taskdefs;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class ValidateUserLogin
extends Task
implements Condition {
    private String url;
    private String rootdn;
    private String filter;
    private String key;
    private String property;
    private String searchdn;
    private String password;

    public void execute() {
        if (this.property == null) {
            throw new BuildException("'property' attribute is not defined");
        }
        this.validateParameters(this.url, this.rootdn, this.filter, this.key, this.searchdn, this.password);
        this.log("Authenticating the user...");
        if (this.authenticateUser(this.url, this.searchUser(this.url, this.rootdn, this.filter, this.key, this.searchdn))) {
            this.getProject().setProperty(this.property, "true");
        } else {
            this.getProject().setProperty(this.property, "false");
        }
    }

    public boolean eval() {
        this.validateParameters(this.url, this.rootdn, this.filter, this.key, this.searchdn, this.password);
        return this.authenticateUser(this.url, this.searchUser(this.url, this.rootdn, this.filter, this.key, this.searchdn));
    }

    public String searchUser(String url, String rootdn, String filter, String key, String searchdn) {
        String userSearchDN = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url + "/" + rootdn);
        env.put("java.naming.security.authentication", "simple");
        InitialDirContext ctx = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            ctx = new InitialDirContext(env);
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            results = ctx.search("", filter, controls);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attr = attributes.get(key);
                userSearchDN = key + "=" + (String)attr.get() + ", " + searchdn + ", " + rootdn;
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new BuildException("LDAP Naming exception");
        }
        return userSearchDN;
    }

    public void validateParameters(String url, String rootdn, String filter, String key, String searchdn, String password) {
        if (url == null) {
            throw new BuildException("'url' attribute is not defined");
        }
        if (rootdn == null) {
            throw new BuildException("'rootdn' attribute is not defined");
        }
        if (filter == null) {
            throw new BuildException("'filter' attribute is not defined");
        }
        if (key == null) {
            throw new BuildException("'key' attribute is not defined");
        }
        if (searchdn == null) {
            throw new BuildException("'searchdn' attribute is not defined");
        }
        if (password == null) {
            throw new BuildException("'password' attribute is not defined");
        }
    }

    public boolean authenticateUser(String ldapurl, String rooTdn) {
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapurl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", rooTdn);
        env.put("java.naming.security.credentials", this.password);
        try {
            InitialDirContext authContext = new InitialDirContext(env);
            return true;
        }
        catch (NamingException e) {
            this.log("Not able to validate the user. " + e.getMessage(), 4);
            return false;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRootdn() {
        return this.rootdn;
    }

    public void setpassword(String password) {
        this.password = password;
    }

    public String getpassword() {
        return this.password;
    }

    public void setRootdn(String rootdn) {
        this.rootdn = rootdn;
    }

    public String getsearchdn() {
        return this.searchdn;
    }

    public void setsearchdn(String searchdn) {
        this.searchdn = searchdn;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getOutputProperty() {
        return this.property;
    }

    public void setOutputProperty(String property) {
        this.property = property;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

