/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.maven.scm.provider.hg.command.export;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.AbstractExportCommand;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;

public class HgExportCommand
extends AbstractExportCommand {
    protected ExportScmResult executeExportCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version, String outputDir) throws ScmException {
        File workingDir = fileSet.getBasedir();
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.isDirectory()) {
            throw new ScmException("Could not find directory: " + outputDirFile);
        }
        if (outputDirFile.list().length > 0) {
            throw new ScmException("Output directory must be empty.");
        }
        ArrayList<String> exportCmd = new ArrayList<String>();
        exportCmd.add("archive");
        exportCmd.add("--no-decode");
        exportCmd.add("-t");
        exportCmd.add("files");
        exportCmd.add("-r");
        exportCmd.add(version != null ? version.getName() : "tip");
        exportCmd.add(outputDirFile.getAbsolutePath());
        this.getLogger().debug("hg:export:workingDir: " + workingDir.getAbsolutePath());
        this.getLogger().debug("hg:export:outputDir: " + outputDirFile.getAbsolutePath());
        ScmResult exportResult = HgUtils.execute((File)workingDir, (String[])exportCmd.toArray(new String[exportCmd.size()]));
        if (!exportResult.isSuccess()) {
            return new ExportScmResult(exportResult.getCommandLine(), exportResult.getProviderMessage(), exportResult.getCommandOutput(), exportResult.isSuccess());
        }
        return new ExportScmResult(exportResult.getCommandLine(), this.getFiles(outputDirFile));
    }

    protected List<String> getFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                files.add(f.getAbsolutePath());
                continue;
            }
            if (!f.isDirectory()) continue;
            files.addAll(this.getFiles(f));
        }
        return files;
    }
}

