/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.util.filter.Filter;
import org.apache.tools.ant.BuildException;

public class IvyRetrieve
extends IvyPostResolveTask {
    private String pattern;
    private String ivypattern = null;
    private boolean sync = false;
    private boolean symlink = false;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (!this.getAllowedLogOptions().contains(this.getLog())) {
            throw new BuildException("invalid option for 'log': " + this.getLog() + ". Available options are " + this.getAllowedLogOptions());
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            Filter artifactFilter = this.getArtifactFilter();
            int targetsCopied = this.getIvyInstance().retrieve(this.getResolvedMrid(), this.pattern, ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(this.splitConfs(this.getConf())).setDestIvyPattern(this.ivypattern).setArtifactFilter(artifactFilter).setSync(this.sync).setUseOrigin(this.isUseOrigin()).setMakeSymlinks(this.symlink).setResolveId(this.getResolveId()));
            boolean haveTargetsBeenCopied = targetsCopied > 0;
            this.getProject().setProperty("ivy.nb.targets.copied", String.valueOf(targetsCopied));
            this.getProject().setProperty("ivy.targets.copied", String.valueOf(haveTargetsBeenCopied));
        }
        catch (Exception ex) {
            throw new BuildException("impossible to ivy retrieve: " + ex, (Throwable)ex);
        }
    }

    protected Collection getAllowedLogOptions() {
        return Arrays.asList("default", "download-only", "quiet");
    }

    public String getIvypattern() {
        return this.ivypattern;
    }

    public void setIvypattern(String ivypattern) {
        this.ivypattern = ivypattern;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }
}

