/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.ChannelLoop;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.core.ChannelTCP;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.ITransportProvider;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

public class TransportManager {
    private static final Collection<AbstractChannel> channels = new LinkedList<AbstractChannel>();
    private static final Collection<Protocol.ChannelOpenListener> listeners = new LinkedList<Protocol.ChannelOpenListener>();
    private static final HashMap<String, ITransportProvider> transports = new HashMap();

    static {
        TransportManager.addTransportProvider(new ITransportProvider(){

            public String getName() {
                return "TCP";
            }

            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                Map<String, String> attrs = peer.getAttributes();
                String host = attrs.get("Host");
                String port = attrs.get("Port");
                if (host == null) {
                    throw new Error("No host name");
                }
                if (port == null) {
                    throw new Error("No port number");
                }
                return new ChannelTCP(peer, host, Integer.parseInt(port), false);
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            public String getName() {
                return "SSL";
            }

            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                Map<String, String> attrs = peer.getAttributes();
                String host = attrs.get("Host");
                String port = attrs.get("Port");
                if (host == null) {
                    throw new Error("No host name");
                }
                if (port == null) {
                    throw new Error("No port number");
                }
                return new ChannelTCP(peer, host, Integer.parseInt(port), true);
            }
        });
        TransportManager.addTransportProvider(new ITransportProvider(){

            public String getName() {
                return "Loop";
            }

            public IChannel openChannel(IPeer peer) {
                if (!$assertionsDisabled && !this.getName().equals(peer.getTransportName())) {
                    throw new AssertionError();
                }
                return new ChannelLoop(peer);
            }
        });
    }

    public static void addTransportProvider(ITransportProvider transport) {
        String name = transport.getName();
        assert (name != null);
        if (transports.get(name) != null) {
            throw new Error("Already registered: " + name);
        }
        transports.put(name, transport);
    }

    public static void removeTransportProvider(ITransportProvider transport) {
        String name = transport.getName();
        assert (name != null);
        if (transports.get(name) == transport) {
            transports.remove(name);
        }
    }

    public static IChannel openChannel(IPeer peer) {
        String name = peer.getTransportName();
        if (name == null) {
            throw new Error("No transport name");
        }
        ITransportProvider transport = transports.get(name);
        if (transport == null) {
            throw new Error("Unknown transport name: " + name);
        }
        return transport.openChannel(peer);
    }

    public static void channelOpened(AbstractChannel channel) {
        Protocol.ChannelOpenListener[] array;
        assert (!channels.contains(channel));
        channels.add(channel);
        Protocol.ChannelOpenListener[] channelOpenListenerArray = array = listeners.toArray(new Protocol.ChannelOpenListener[listeners.size()]);
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Protocol.ChannelOpenListener l = channelOpenListenerArray[n2];
            try {
                l.onChannelOpen(channel);
            }
            catch (Throwable x) {
                Protocol.log("Exception in channel listener", x);
            }
            ++n2;
        }
    }

    public static void channelClosed(AbstractChannel channel, Throwable x) {
        assert (channels.contains(channel));
        channels.remove(channel);
    }

    public static IChannel[] getOpenChannels() {
        return channels.toArray(new IChannel[channels.size()]);
    }

    public static void addChanelOpenListener(Protocol.ChannelOpenListener listener) {
        assert (listener != null);
        listeners.add(listener);
    }

    public static void removeChanelOpenListener(Protocol.ChannelOpenListener listener) {
        listeners.remove(listener);
    }

    public static void peerDisposed(AbstractPeer peer) {
        Exception error = null;
        ArrayList<AbstractChannel> bf = new ArrayList<AbstractChannel>(channels);
        for (AbstractChannel c : bf) {
            if (c.getRemotePeer() != peer) continue;
            if (error == null) {
                error = new Exception("Peer is disposed");
            }
            c.terminate(error);
        }
    }

    public static void sendEvent(String service_name, String event_name, byte[] data) {
        for (AbstractChannel channel : channels) {
            IService s = channel.getLocalService(service_name);
            if (s == null) continue;
            channel.sendEvent(s, event_name, data);
        }
    }

    public static void sync(final Runnable done) {
        final HashSet<IToken> set = new HashSet<IToken>();
        ILocator.DoneSync done_sync = new ILocator.DoneSync(){

            public void doneSync(IToken token) {
                if (!$assertionsDisabled && !set.contains(token)) {
                    throw new AssertionError();
                }
                set.remove(token);
                if (set.isEmpty()) {
                    done.run();
                }
            }
        };
        for (AbstractChannel channel : channels) {
            ILocator s = channel.getRemoteService(ILocator.class);
            if (s == null) continue;
            set.add(s.sync(done_sync));
        }
        if (set.isEmpty()) {
            Protocol.invokeLater(done);
        }
    }
}

