/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.protocol;

import java.util.ArrayList;
import java.util.TreeSet;
import org.eclipse.tm.internal.tcf.core.LocalPeer;
import org.eclipse.tm.internal.tcf.core.ServiceManager;
import org.eclipse.tm.internal.tcf.core.TransportManager;
import org.eclipse.tm.internal.tcf.services.local.LocatorService;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IEventQueue;
import org.eclipse.tm.tcf.protocol.ILogger;
import org.eclipse.tm.tcf.protocol.IServiceProvider;
import org.eclipse.tm.tcf.protocol.ITransportProvider;
import org.eclipse.tm.tcf.services.ILocator;

public final class Protocol {
    private static IEventQueue event_queue;
    private static ILogger logger;
    private static final TreeSet<Timer> timer_queue;
    private static int timer_cnt;
    private static final Thread timer_dispatcher;
    private static final ArrayList<CongestionMonitor> congestion_monitors;

    static {
        timer_queue = new TreeSet();
        timer_dispatcher = new Thread(){

            public void run() {
                try {
                    TreeSet treeSet = timer_queue;
                    synchronized (treeSet) {
                        while (true) {
                            if (timer_queue.isEmpty()) {
                                timer_queue.wait();
                                continue;
                            }
                            long time = System.currentTimeMillis();
                            Timer t = (Timer)timer_queue.first();
                            if (t.time > time) {
                                timer_queue.wait(t.time - time);
                                continue;
                            }
                            timer_queue.remove(t);
                            Protocol.invokeLater(t.run);
                        }
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (Throwable x) {
                    Protocol.log("Exception in TCF dispatch loop", x);
                }
            }
        };
        congestion_monitors = new ArrayList();
    }

    public static void setEventQueue(IEventQueue event_queue) {
        assert (Protocol.event_queue == null);
        Protocol.event_queue = event_queue;
        event_queue.invokeLater(new Runnable(){

            public void run() {
                new LocatorService();
                new LocalPeer();
            }
        });
        timer_dispatcher.setName("TCF Timer Dispatcher");
        timer_dispatcher.setDaemon(true);
        timer_dispatcher.start();
    }

    public static IEventQueue getEventQueue() {
        return event_queue;
    }

    public static boolean isDispatchThread() {
        return event_queue != null && event_queue.isDispatchThread();
    }

    public static void invokeLater(Runnable runnable) {
        event_queue.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeLater(long delay, Runnable runnable) {
        if (delay <= 0L) {
            event_queue.invokeLater(runnable);
        } else {
            TreeSet<Timer> treeSet = timer_queue;
            synchronized (treeSet) {
                timer_queue.add(new Timer(System.currentTimeMillis() + delay, runnable));
                timer_queue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(final Runnable runnable) {
        if (event_queue.isDispatchThread()) {
            runnable.run();
        } else {
            Runnable r;
            Runnable runnable2 = r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        3 var2_2 = this;
                        synchronized (var2_2) {
                            this.notify();
                        }
                        throw throwable;
                    }
                    3 var2_3 = this;
                    synchronized (var2_3) {
                        this.notify();
                    }
                }
            };
            synchronized (runnable2) {
                event_queue.invokeLater(r);
                try {
                    r.wait();
                }
                catch (InterruptedException x) {
                    throw new Error(x);
                }
            }
        }
    }

    public static synchronized void setLogger(ILogger logger) {
        Protocol.logger = logger;
    }

    public static synchronized void log(String msg, Throwable x) {
        if (logger == null) {
            System.err.println(msg);
            if (x != null) {
                x.printStackTrace();
            }
        } else {
            logger.log(msg, x);
        }
    }

    public static ILocator getLocator() {
        return LocatorService.getLocator();
    }

    public static IChannel[] getOpenChannels() {
        assert (Protocol.isDispatchThread());
        return TransportManager.getOpenChannels();
    }

    public static void addChannelOpenListener(ChannelOpenListener listener) {
        assert (Protocol.isDispatchThread());
        TransportManager.addChanelOpenListener(listener);
    }

    public static void removeChannelOpenListener(ChannelOpenListener listener) {
        assert (Protocol.isDispatchThread());
        TransportManager.removeChanelOpenListener(listener);
    }

    public static void sendEvent(String service_name, String event_name, byte[] data) {
        assert (Protocol.isDispatchThread());
        TransportManager.sendEvent(service_name, event_name, data);
    }

    public static void sync(Runnable done) {
        assert (Protocol.isDispatchThread());
        TransportManager.sync(done);
    }

    public static void addCongestionMonitor(CongestionMonitor monitor) {
        assert (monitor != null);
        assert (Protocol.isDispatchThread());
        congestion_monitors.add(monitor);
    }

    public static void removeCongestionMonitor(CongestionMonitor monitor) {
        assert (Protocol.isDispatchThread());
        congestion_monitors.remove(monitor);
    }

    public static int getCongestionLevel() {
        int n;
        assert (Protocol.isDispatchThread());
        int level = -100;
        for (CongestionMonitor m : congestion_monitors) {
            int n2 = m.getCongestionLevel();
            if (n2 <= level) continue;
            level = n2;
        }
        if (event_queue != null && (n = event_queue.getCongestion()) > level) {
            level = n;
        }
        if (level > 100) {
            level = 100;
        }
        return level;
    }

    public static void addServiceProvider(IServiceProvider provider) {
        ServiceManager.addServiceProvider(provider);
    }

    public static void removeServiceProvider(IServiceProvider provider) {
        ServiceManager.removeServiceProvider(provider);
    }

    public static void addTransportProvider(ITransportProvider provider) {
        assert (Protocol.isDispatchThread());
        TransportManager.addTransportProvider(provider);
    }

    public static void removeTransportProvider(ITransportProvider provider) {
        assert (Protocol.isDispatchThread());
        TransportManager.removeTransportProvider(provider);
    }

    public static interface ChannelOpenListener {
        public void onChannelOpen(IChannel var1);
    }

    public static interface CongestionMonitor {
        public int getCongestionLevel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Timer
    implements Comparable<Timer> {
        final int id;
        final long time;
        final Runnable run;

        Timer(long time, Runnable run) {
            int n = timer_cnt;
            timer_cnt = n + 1;
            this.id = n;
            this.time = time;
            this.run = run;
        }

        @Override
        public int compareTo(Timer x) {
            if (x == this) {
                return 0;
            }
            if (this.time < x.time) {
                return -1;
            }
            if (this.time > x.time) {
                return 1;
            }
            if (this.id < x.id) {
                return -1;
            }
            if (this.id > x.id) {
                return 1;
            }
            assert (false);
            return 0;
        }
    }
}

