/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.IOException;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.protocol.IPeer;

public abstract class StreamChannel
extends AbstractChannel {
    public static final int ESC = 3;
    private int bin_data_size;

    public StreamChannel(IPeer remote_peer) {
        super(remote_peer);
    }

    public StreamChannel(IPeer local_peer, IPeer remote_peer) {
        super(local_peer, remote_peer);
    }

    protected abstract int get() throws IOException;

    protected abstract void put(int var1) throws IOException;

    protected void put(byte[] buf) throws IOException {
        byte[] byArray = buf;
        int n = buf.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.put(b & 0xFF);
            ++n2;
        }
    }

    protected final int read() throws IOException {
        block6: while (true) {
            int res;
            if ((res = this.get()) < 0) {
                return -1;
            }
            assert (res >= 0 && res <= 255);
            if (this.bin_data_size > 0) {
                --this.bin_data_size;
                return res;
            }
            if (res != 3) {
                return res;
            }
            int n = this.get();
            switch (n) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return -2;
                }
                case 2: {
                    return -1;
                }
                case 3: {
                    int i = 0;
                    while (true) {
                        res = this.get();
                        this.bin_data_size |= (res & 0x7F) << i;
                        if ((res & 0x80) == 0) continue block6;
                        i += 7;
                    }
                }
            }
            if (n < 0) {
                return -1;
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError();
    }

    protected final void write(int n) throws IOException {
        switch (n) {
            case 3: {
                this.put(3);
                this.put(0);
                break;
            }
            case -2: {
                this.put(3);
                this.put(1);
                break;
            }
            case -1: {
                this.put(3);
                this.put(2);
                break;
            }
            default: {
                assert (n >= 0 && n <= 255);
                this.put(n);
            }
        }
    }

    protected void write(byte[] buf) throws IOException {
        if (buf.length > 32 && this.isZeroCopySupported()) {
            this.put(3);
            this.put(3);
            int n = buf.length;
            while (true) {
                if (n <= 127) break;
                this.put(n & 0x7F | 0x80);
                n >>= 7;
            }
            this.put(n);
            this.put(buf);
        } else {
            byte[] byArray = buf;
            int n = buf.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                int n3 = b & 0xFF;
                this.put(n3);
                if (n3 == 3) {
                    this.put(0);
                }
                ++n2;
            }
        }
    }
}

