/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.util;

import java.util.HashSet;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCFDataCache<V>
implements Runnable {
    private Throwable error;
    private boolean valid;
    private boolean posted;
    private V data;
    protected final IChannel channel;
    protected IToken command;
    private final HashSet<Runnable> waiting_list = new HashSet();

    public TCFDataCache(IChannel channel) {
        assert (channel != null);
        this.channel = channel;
    }

    private void post() {
        if (this.posted) {
            return;
        }
        if (this.waiting_list.isEmpty()) {
            return;
        }
        Protocol.invokeLater(this);
        this.posted = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isPending() {
        return this.command != null;
    }

    public Throwable getError() {
        assert (this.valid);
        return this.error;
    }

    public V getData() {
        assert (Protocol.isDispatchThread());
        assert (this.valid);
        return this.data;
    }

    @Override
    public void run() {
        assert (Protocol.isDispatchThread());
        this.posted = false;
        Runnable[] arr = this.waiting_list.toArray(new Runnable[this.waiting_list.size()]);
        this.waiting_list.clear();
        Runnable[] runnableArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable r = runnableArray[n2];
            if (!(r instanceof TCFDataCache) || !((TCFDataCache)r).posted) {
                r.run();
            }
            ++n2;
        }
    }

    public void wait(Runnable cb) {
        assert (Protocol.isDispatchThread());
        assert (!this.valid);
        if (cb != null) {
            this.waiting_list.add(cb);
        }
    }

    public boolean validate() {
        assert (Protocol.isDispatchThread());
        if (this.channel.getState() != 1) {
            this.error = null;
            this.command = null;
            this.valid = true;
            this.data = null;
        } else {
            if (this.command != null) {
                return false;
            }
            if (!this.valid && !this.startDataRetrieval()) {
                return false;
            }
        }
        assert (this.valid);
        assert (this.command == null);
        this.post();
        return true;
    }

    public void set(IToken token, Throwable error, V data) {
        assert (Protocol.isDispatchThread());
        if (this.command != token) {
            return;
        }
        this.command = null;
        if (this.channel.getState() != 1) {
            data = null;
        }
        this.error = error;
        this.data = data;
        this.valid = true;
        this.post();
    }

    public void reset(V data) {
        assert (Protocol.isDispatchThread());
        if (this.command != null) {
            this.command.cancel();
            this.command = null;
        }
        this.data = data;
        this.error = null;
        this.valid = true;
        this.post();
    }

    public void reset() {
        assert (Protocol.isDispatchThread());
        this.error = null;
        this.valid = false;
        this.data = null;
        this.post();
    }

    public void cancel() {
        assert (Protocol.isDispatchThread());
        if (this.command != null) {
            this.command.cancel();
            this.command = null;
        }
        this.error = null;
        this.valid = false;
        this.data = null;
        this.post();
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append('[');
        if (this.valid) {
            bf.append("valid,");
        }
        if (this.posted) {
            bf.append("posted,");
        }
        if (this.error != null) {
            bf.append("error,");
        }
        bf.append("data=");
        bf.append(this.data == null ? "null" : this.data.toString());
        bf.append(']');
        return bf.toString();
    }

    protected abstract boolean startDataRetrieval();
}

