/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IRunControl;

public class RunControlProxy
implements IRunControl {
    private final IChannel channel;
    private final Map<IRunControl.RunControlListener, IChannel.IEventListener> listeners = new HashMap<IRunControl.RunControlListener, IChannel.IEventListener>();

    public RunControlProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "RunControl";
    }

    public void addListener(final IRunControl.RunControlListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                block18: {
                    try {
                        Object[] args = JSON.parseSequence(data);
                        if (name.equals("contextSuspended")) {
                            if (!$assertionsDisabled && args.length != 4) {
                                throw new AssertionError();
                            }
                            listener.contextSuspended((String)args[0], args[1] == null ? null : ((Number)args[1]).toString(), (String)args[2], (Map)args[3]);
                            break block18;
                        }
                        if (name.equals("contextResumed")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextResumed((String)args[0]);
                            break block18;
                        }
                        if (name.equals("contextAdded")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextAdded(RunControlProxy.this.toContextArray(args[0]));
                            break block18;
                        }
                        if (name.equals("contextChanged")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextChanged(RunControlProxy.this.toContextArray(args[0]));
                            break block18;
                        }
                        if (name.equals("contextRemoved")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextRemoved(RunControlProxy.this.toStringArray(args[0]));
                            break block18;
                        }
                        if (name.equals("contextException")) {
                            if (!$assertionsDisabled && args.length != 2) {
                                throw new AssertionError();
                            }
                            listener.contextException((String)args[0], (String)args[1]);
                            break block18;
                        }
                        if (name.equals("containerSuspended")) {
                            if (!$assertionsDisabled && args.length != 5) {
                                throw new AssertionError();
                            }
                            listener.containerSuspended((String)args[0], args[1] == null ? null : ((Number)args[1]).toString(), (String)args[2], (Map)args[3], RunControlProxy.this.toStringArray(args[4]));
                            break block18;
                        }
                        if (name.equals("containerResumed")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.containerResumed(RunControlProxy.this.toStringArray(args[0]));
                            break block18;
                        }
                        throw new IOException("RunControl service: unknown event: " + name);
                    }
                    catch (Throwable x) {
                        RunControlProxy.this.channel.terminate(x);
                    }
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    public void removeListener(IRunControl.RunControlListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    public IToken getContext(String context_id, final IRunControl.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{context_id}){

            public void done(Exception error, Object[] args) {
                RunContext ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new RunContext((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    public IToken getChildren(String parent_context_id, final IRunControl.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = RunControlProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    private IRunControl.RunControlContext[] toContextArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int n = 0;
        IRunControl.RunControlContext[] ctx = new IRunControl.RunControlContext[c.size()];
        for (Map m : c) {
            ctx[n++] = new RunContext(m);
        }
        return ctx;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RunContext
    implements IRunControl.RunControlContext {
        private final Map<String, Object> props;

        RunContext(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public boolean isContainer() {
            Boolean b = (Boolean)this.props.get("IsContainer");
            return b != null && b != false;
        }

        @Override
        public boolean hasState() {
            Boolean b = (Boolean)this.props.get("HasState");
            return b != null && b != false;
        }

        @Override
        public boolean canResume(int mode) {
            if (this.props.containsKey("CanResume")) {
                int b = ((Number)this.props.get("CanResume")).intValue();
                return (b & 1 << mode) != 0;
            }
            return false;
        }

        @Override
        public boolean canCount(int mode) {
            if (this.props.containsKey("CanCount")) {
                int b = ((Number)this.props.get("CanCount")).intValue();
                return (b & 1 << mode) != 0;
            }
            return false;
        }

        @Override
        public boolean canSuspend() {
            Boolean b = (Boolean)this.props.get("CanSuspend");
            return b != null && b != false;
        }

        @Override
        public boolean canTerminate() {
            Boolean b = (Boolean)this.props.get("CanTerminate");
            return b != null && b != false;
        }

        @Override
        public IToken getState(final IRunControl.DoneGetState done) {
            return new Command((IChannel)((RunControlProxy)RunControlProxy.this).channel, (IService)RunControlProxy.this, (String)"getState", (Object[])new Object[]{this.getID()}){

                public void done(Exception error, Object[] args) {
                    boolean susp = false;
                    String pc = null;
                    String reason = null;
                    Map map = null;
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 5) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                        susp = (Boolean)args[1];
                        if (args[2] != null) {
                            pc = ((Number)args[2]).toString();
                        }
                        reason = (String)args[3];
                        map = (Map)args[4];
                    }
                    done.doneGetState(this.token, error, susp, pc, reason, map);
                }
            }.token;
        }

        @Override
        public IToken resume(int mode, int count, IRunControl.DoneCommand done) {
            return this.command("resume", new Object[]{this.getID(), mode, count}, done);
        }

        @Override
        public IToken resume(int mode, int count, Map<String, Object> params, IRunControl.DoneCommand done) {
            if (params == null) {
                return this.resume(mode, count, done);
            }
            return this.command("resume", new Object[]{this.getID(), mode, count, params}, done);
        }

        @Override
        public IToken suspend(IRunControl.DoneCommand done) {
            return this.command("suspend", new Object[]{this.getID()}, done);
        }

        @Override
        public IToken terminate(IRunControl.DoneCommand done) {
            return this.command("terminate", new Object[]{this.getID()}, done);
        }

        private IToken command(String cmd, Object[] args, final IRunControl.DoneCommand done) {
            return new Command((IChannel)((RunControlProxy)RunControlProxy.this).channel, (IService)RunControlProxy.this, (String)cmd, (Object[])args){

                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneCommand(this.token, error);
                }
            }.token;
        }

        public String toString() {
            return "[Run Control Context " + this.props.toString() + "]";
        }
    }
}

