/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.ISymbols;

public class SymbolsProxy
implements ISymbols {
    private final IChannel channel;

    public SymbolsProxy(IChannel channel) {
        this.channel = channel;
    }

    public String getName() {
        return "Symbols";
    }

    public IToken getContext(String id, final ISymbols.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Context ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new Context((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    public IToken getChildren(String parent_context_id, final ISymbols.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            public void done(Exception error, Object[] args) {
                String[] lst = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    lst = SymbolsProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, lst);
            }
        }.token;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    implements ISymbols.Symbol {
        private final byte[] value;
        private final Map<String, Object> props;

        Context(Map<String, Object> props) {
            this.props = props;
            this.value = JSON.toByteArray(props.get("Value"));
        }

        @Override
        public Number getAddress() {
            return (Number)this.props.get("Address");
        }

        @Override
        public String getBaseTypeID() {
            return (String)this.props.get("BaseTypeID");
        }

        @Override
        public String getExeContextID() {
            return (String)this.props.get("ExeID");
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getIndexTypeID() {
            return (String)this.props.get("IndexTypeID");
        }

        @Override
        public int getLength() {
            Number n = (Number)this.props.get("Length");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public int getOffset() {
            Number n = (Number)this.props.get("Offset");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public int getSize() {
            Number n = (Number)this.props.get("Size");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public ISymbols.SymbolClass getSymbolClass() {
            Number n = (Number)this.props.get("Class");
            if (n != null) {
                switch (n.intValue()) {
                    case 1: {
                        return ISymbols.SymbolClass.value;
                    }
                    case 2: {
                        return ISymbols.SymbolClass.reference;
                    }
                    case 3: {
                        return ISymbols.SymbolClass.function;
                    }
                    case 4: {
                        return ISymbols.SymbolClass.type;
                    }
                }
            }
            return ISymbols.SymbolClass.unknown;
        }

        @Override
        public ISymbols.TypeClass getTypeClass() {
            Number n = (Number)this.props.get("TypeClass");
            if (n != null) {
                switch (n.intValue()) {
                    case 1: {
                        return ISymbols.TypeClass.cardinal;
                    }
                    case 2: {
                        return ISymbols.TypeClass.integer;
                    }
                    case 3: {
                        return ISymbols.TypeClass.real;
                    }
                    case 4: {
                        return ISymbols.TypeClass.pointer;
                    }
                    case 5: {
                        return ISymbols.TypeClass.array;
                    }
                    case 6: {
                        return ISymbols.TypeClass.composite;
                    }
                    case 7: {
                        return ISymbols.TypeClass.enumeration;
                    }
                    case 8: {
                        return ISymbols.TypeClass.function;
                    }
                }
            }
            return ISymbols.TypeClass.unknown;
        }

        @Override
        public String getTypeID() {
            return (String)this.props.get("TypeID");
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }
    }
}

