/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.local;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.tm.internal.tcf.core.LocalPeer;
import org.eclipse.tm.internal.tcf.core.RemotePeer;
import org.eclipse.tm.internal.tcf.core.ServiceManager;
import org.eclipse.tm.internal.tcf.core.TransportManager;
import org.eclipse.tm.internal.tcf.services.local.ChannelProxy;
import org.eclipse.tm.tcf.core.AbstractChannel;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IServiceProvider;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorService
implements ILocator {
    private static final int DISCOVEY_PORT = 1534;
    private static final int MAX_PACKET_SIZE = 8952;
    private static final int PREF_PACKET_SIZE = 1452;
    private static LocatorService locator;
    private static final Map<String, IPeer> peers;
    private static final ArrayList<ILocator.LocatorListener> listeners;
    private final HashSet<SubNet> subnets = new HashSet();
    private final ArrayList<Slave> slaves = new ArrayList();
    private final byte[] inp_buf = new byte[8952];
    private final byte[] out_buf = new byte[8952];
    private InetAddress loopback_addr;
    private static LocalPeer local_peer;
    private DatagramSocket socket;
    private long last_master_packet_time;
    private Thread timer_thread = new Thread(){

        public void run() {
            while (true) {
                try {
                    while (true) {
                        1.sleep(15000L);
                        Protocol.invokeAndWait(new Runnable(){

                            public void run() {
                                LocatorService.this.refresh_timer();
                            }
                        });
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                catch (Throwable x) {
                    Protocol.log("Unhandled exception in TCF discovery listening thread", x);
                    continue;
                }
                break;
            }
        }
    };
    private Thread input_thread = new Thread(){

        public void run() {
            while (true) {
                DatagramSocket socket = LocatorService.this.socket;
                try {
                    final DatagramPacket p = new DatagramPacket(LocatorService.this.inp_buf, LocatorService.this.inp_buf.length);
                    socket.receive(p);
                    Protocol.invokeAndWait(new Runnable(){

                        public void run() {
                            LocatorService.this.handleDatagramPacket(p);
                        }
                    });
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                catch (Exception x) {
                    if (socket != LocatorService.this.socket) continue;
                    Protocol.log("Cannot read from datagram socket", x);
                    continue;
                }
                break;
            }
        }
    };

    static {
        peers = new HashMap<String, IPeer>();
        listeners = new ArrayList();
        ServiceManager.addServiceProvider(new IServiceProvider(){

            public IService[] getLocalService(final IChannel channel) {
                channel.addCommandServer(locator, new IChannel.ICommandServer(){

                    public void command(IToken token, String name, byte[] data) {
                        locator.command((AbstractChannel)channel, token, name, data);
                    }
                });
                return new IService[]{locator};
            }

            public IService getServiceProxy(IChannel channel, String service_name) {
                return null;
            }
        });
    }

    public LocatorService() {
        locator = this;
        try {
            this.loopback_addr = InetAddress.getByName(null);
            this.out_buf[0] = 84;
            this.out_buf[1] = 67;
            this.out_buf[2] = 70;
            this.out_buf[3] = 50;
            this.out_buf[4] = 0;
            this.out_buf[5] = 0;
            this.out_buf[6] = 0;
            this.out_buf[7] = 0;
            try {
                this.socket = new DatagramSocket(1534);
            }
            catch (BindException bindException) {
                this.socket = new DatagramSocket();
            }
            this.socket.setBroadcast(true);
            this.input_thread.setName("TCF Locator Receiver");
            this.timer_thread.setName("TCF Locator Timer");
            this.input_thread.setDaemon(true);
            this.timer_thread.setDaemon(true);
            this.input_thread.start();
            this.timer_thread.start();
            listeners.add(new ILocator.LocatorListener(){

                public void peerAdded(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                public void peerChanged(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                public void peerHeartBeat(String id) {
                }

                public void peerRemoved(String id) {
                }
            });
            this.refreshSubNetList();
            this.sendPeersRequest(null, 0);
            this.sendAll(null, 0, null, System.currentTimeMillis());
        }
        catch (Exception x) {
            Protocol.log("Cannot open UDP socket for TCF discovery protocol", x);
        }
    }

    public static LocalPeer getLocalPeer() {
        return local_peer;
    }

    public static ILocator.LocatorListener[] getListeners() {
        return listeners.toArray(new ILocator.LocatorListener[listeners.size()]);
    }

    public static void addPeer(AbstractPeer peer) {
        assert (peers.get(peer.getID()) == null);
        if (peer instanceof LocalPeer) {
            local_peer = (LocalPeer)peer;
        }
        peers.put(peer.getID(), peer);
        peer.sendPeerAddedEvent();
    }

    public static void removePeer(AbstractPeer peer) {
        String id = peer.getID();
        assert (peers.get(id) == peer);
        peers.remove(id);
        peer.sendPeerRemovedEvent();
    }

    private Map<String, Object> makeErrorReport(int code, String msg) {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("Time", new Long(System.currentTimeMillis()));
        err.put("Code", new Integer(code));
        err.put("Format", msg);
        return err;
    }

    private void command(AbstractChannel channel, IToken token, String name, byte[] data) {
        try {
            if (name.equals("redirect")) {
                String peer_id = (String)JSON.parseSequence(data)[0];
                IPeer peer = peers.get(peer_id);
                if (peer == null) {
                    channel.sendResult(token, JSON.toJSONSequence(new Object[]{this.makeErrorReport(7, "Unknown peer ID")}));
                    return;
                }
                channel.sendResult(token, JSON.toJSONSequence(new Object[1]));
                if (peer instanceof LocalPeer) {
                    channel.sendEvent(Protocol.getLocator(), "Hello", JSON.toJSONSequence(new Object[]{channel.getLocalServices()}));
                    return;
                }
                new ChannelProxy(channel, peer.openChannel());
            } else if (name.equals("sync")) {
                channel.sendResult(token, null);
            } else if (name.equals("getPeers")) {
                int i = 0;
                Object[] arr = new Object[peers.size()];
                for (IPeer p : peers.values()) {
                    arr[i++] = p.getAttributes();
                }
                Object[] objectArray = new Object[2];
                objectArray[1] = arr;
                channel.sendResult(token, JSON.toJSONSequence(objectArray));
            } else {
                channel.rejectCommand(token);
            }
        }
        catch (Throwable x) {
            channel.terminate(x);
        }
    }

    private void refresh_timer() {
        long time = System.currentTimeMillis();
        if (this.slaves.size() > 0) {
            int i = 0;
            while (i < this.slaves.size()) {
                Slave s = this.slaves.get(i);
                if (s.last_packet_time + 60000L < time) {
                    this.slaves.remove(i);
                    continue;
                }
                ++i;
            }
        }
        ArrayList<RemotePeer> stale_peers = null;
        for (IPeer p : peers.values()) {
            RemotePeer r;
            if (!(p instanceof RemotePeer) || (r = (RemotePeer)p).getLastUpdateTime() + 60000L >= time) continue;
            if (stale_peers == null) {
                stale_peers = new ArrayList<RemotePeer>();
            }
            stale_peers.add(r);
        }
        if (stale_peers != null) {
            IChannel[] open_channels = TransportManager.getOpenChannels();
            HashSet<IPeer> connected_peers = new HashSet<IPeer>();
            IChannel[] iChannelArray = open_channels;
            int n = open_channels.length;
            int n2 = 0;
            while (n2 < n) {
                IChannel c = iChannelArray[n2];
                connected_peers.add(c.getRemotePeer());
                ++n2;
            }
            for (RemotePeer p : stale_peers) {
                if (connected_peers.contains(p)) continue;
                p.dispose();
            }
        }
        if (this.socket.getLocalPort() != 1534 && this.last_master_packet_time + 30000L <= time) {
            DatagramSocket s0 = this.socket;
            DatagramSocket s1 = null;
            try {
                s1 = new DatagramSocket(1534);
                s1.setBroadcast(true);
                this.socket = s1;
                s0.close();
            }
            catch (Throwable throwable) {}
        }
        this.refreshSubNetList();
        this.sendAll(null, 0, null, time);
    }

    private Slave addSlave(InetAddress addr, int port, long timestamp) {
        for (Slave s : this.slaves) {
            if (s.port != port || !s.address.equals(addr)) continue;
            if (s.last_packet_time < timestamp) {
                s.last_packet_time = timestamp;
            }
            return s;
        }
        long time = System.currentTimeMillis();
        Slave s = new Slave(addr, port);
        s.last_packet_time = timestamp;
        this.slaves.add(s);
        this.sendPeersRequest(addr, port);
        this.sendAll(addr, port, s, time);
        this.sendSlaveInfo(s, time);
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private void refreshSubNetList() {
        set = new HashSet<SubNet>();
        try {
            e = NetworkInterface.getNetworkInterfaces();
            block6: while (e.hasMoreElements()) {
                f = e.nextElement();
                try {
                    m0 = f.getClass().getMethod("getInterfaceAddresses", new Class[0]);
                    for (E ia : (List)m0.invoke((Object)f, new Object[0])) {
                        m1 = ia.getClass().getMethod("getNetworkPrefixLength", new Class[0]);
                        m2 = ia.getClass().getMethod("getAddress", new Class[0]);
                        m3 = ia.getClass().getMethod("getBroadcast", new Class[0]);
                        network_prefix_len = (Short)m1.invoke(ia, new Object[0]);
                        address = (InetAddress)m2.invoke(ia, new Object[0]);
                        broadcast = (InetAddress)m3.invoke(ia, new Object[0]);
                        if (broadcast == null) {
                            broadcast = address;
                        }
                        set.add(new SubNet(network_prefix_len, address, broadcast));
                    }
                    continue;
                }
                catch (Exception v0) {
                    n = f.getInetAddresses();
                    ** while (n.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    addr = n.nextElement();
                    buf = addr.getAddress();
                    if (buf.length != 4) continue;
                    buf[3] = -1;
                    try {
                        set.add(new SubNet(24, addr, InetAddress.getByAddress(buf)));
                    }
                    catch (UnknownHostException v1) {}
                    continue;
lbl34:
                    // 1 sources

                }
            }
        }
        catch (SocketException x) {
            Protocol.log("Cannot get list of network interfaces", x);
        }
        i = this.subnets.iterator();
        while (i.hasNext()) {
            s = i.next();
            if (set.contains(s)) continue;
            i.remove();
        }
        for (SubNet s : set) {
            if (this.subnets.contains(s)) continue;
            this.subnets.add(s);
        }
    }

    private void sendPeersRequest(InetAddress addr, int port) {
        this.out_buf[4] = 1;
        for (SubNet n : this.subnets) {
            try {
                if (addr == null) {
                    this.socket.send(new DatagramPacket(this.out_buf, 8, n.broadcast, 1534));
                    for (Slave slave : this.slaves) {
                        if (!n.contains(slave.address)) continue;
                        this.socket.send(new DatagramPacket(this.out_buf, 8, slave.address, slave.port));
                    }
                    continue;
                }
                if (!n.contains(addr)) continue;
                this.socket.send(new DatagramPacket(this.out_buf, 8, addr, port));
            }
            catch (Exception x) {
                Protocol.log("Cannot send datagram packet", x);
            }
        }
    }

    private void sendPeerInfo(IPeer peer, InetAddress addr, int port) {
        Map<String, String> attrs = peer.getAttributes();
        if (attrs.get("Host") == null) {
            return;
        }
        if (attrs.get("Port") == null) {
            return;
        }
        try {
            this.out_buf[4] = 2;
            int i = 8;
            for (String key : attrs.keySet()) {
                String s = String.valueOf(key) + "=" + attrs.get(key);
                byte[] bt = s.getBytes("UTF-8");
                if (i + bt.length >= this.out_buf.length) break;
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
                this.out_buf[i++] = 0;
            }
            InetAddress peer_addr = InetAddress.getByName(attrs.get("Host"));
            for (SubNet subnet : this.subnets) {
                if (peer instanceof RemotePeer) {
                    if (this.socket.getLocalPort() != 1534) {
                        return;
                    }
                    if (!subnet.address.equals(this.loopback_addr) && !subnet.address.equals(peer_addr)) continue;
                }
                if (!subnet.address.equals(this.loopback_addr) && !subnet.contains(peer_addr)) continue;
                if (addr == null) {
                    this.socket.send(new DatagramPacket(this.out_buf, i, subnet.broadcast, 1534));
                    for (Slave slave : this.slaves) {
                        if (!subnet.contains(slave.address)) continue;
                        this.socket.send(new DatagramPacket(this.out_buf, i, slave.address, slave.port));
                    }
                    subnet.send_all_ok = true;
                    continue;
                }
                if (!subnet.contains(addr)) continue;
                this.socket.send(new DatagramPacket(this.out_buf, i, addr, port));
                subnet.send_all_ok = true;
            }
        }
        catch (Exception x) {
            Protocol.log("Cannot send datagram packet", x);
        }
    }

    private void sendEmptyPacket(InetAddress addr, int port) {
        this.out_buf[4] = 4;
        for (SubNet n : this.subnets) {
            if (n.send_all_ok) continue;
            try {
                if (addr == null) {
                    this.socket.send(new DatagramPacket(this.out_buf, 8, n.broadcast, 1534));
                    for (Slave slave : this.slaves) {
                        if (!n.contains(slave.address)) continue;
                        this.socket.send(new DatagramPacket(this.out_buf, 8, slave.address, slave.port));
                    }
                    continue;
                }
                if (!n.contains(addr)) continue;
                this.socket.send(new DatagramPacket(this.out_buf, 8, addr, port));
            }
            catch (Exception x) {
                Protocol.log("Cannot send datagram packet", x);
            }
        }
    }

    private void sendAll(InetAddress addr, int port, Slave sl, long time) {
        for (SubNet n : this.subnets) {
            n.send_all_ok = false;
        }
        for (IPeer peer : peers.values()) {
            this.sendPeerInfo(peer, addr, port);
        }
        if (addr != null && sl != null && sl.last_req_slaves_time + 60000L >= time) {
            this.sendSlavesInfo(addr, port, time);
        }
        this.sendEmptyPacket(addr, port);
    }

    private void sendSlavesRequest(InetAddress addr, int port) {
        try {
            this.out_buf[4] = 3;
            this.socket.send(new DatagramPacket(this.out_buf, 8, addr, port));
        }
        catch (Exception x) {
            Protocol.log("Cannot send datagram packet", x);
        }
    }

    private void sendSlaveInfo(Slave x, long time) {
        this.out_buf[4] = 4;
        for (SubNet n : this.subnets) {
            if (!n.contains(x.address)) continue;
            try {
                int i = 8;
                String s = String.valueOf(x.last_packet_time) + ":" + x.port + ":" + x.address.getHostAddress();
                byte[] bt = s.getBytes("UTF-8");
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
                this.out_buf[i++] = 0;
                for (Slave y : this.slaves) {
                    if (!n.contains(y.address) || y.last_req_slaves_time + 60000L < time) continue;
                    this.socket.send(new DatagramPacket(this.out_buf, i, y.address, y.port));
                }
            }
            catch (Exception z) {
                Protocol.log("Cannot send datagram packet", z);
            }
        }
    }

    private void sendSlavesInfo(InetAddress addr, int port, long time) {
        this.out_buf[4] = 4;
        for (SubNet n : this.subnets) {
            if (!n.contains(addr)) continue;
            try {
                int i = 8;
                for (Slave x : this.slaves) {
                    if (x.last_packet_time + 60000L < time || x.port == port && x.address.equals(addr) || !n.address.equals(this.loopback_addr) && !n.contains(x.address)) continue;
                    n.send_all_ok = true;
                    String s = String.valueOf(x.last_packet_time) + ":" + x.port + ":" + x.address.getHostAddress();
                    byte[] bt = s.getBytes("UTF-8");
                    if (i > 8 && i + bt.length >= 1452) {
                        this.socket.send(new DatagramPacket(this.out_buf, i, addr, port));
                        i = 8;
                    }
                    System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                    i += bt.length;
                    this.out_buf[i++] = 0;
                }
                if (i <= 8) continue;
                this.socket.send(new DatagramPacket(this.out_buf, i, addr, port));
            }
            catch (Exception x) {
                Protocol.log("Cannot send datagram packet", x);
            }
        }
    }

    private boolean isRemote(InetAddress address, int port) {
        if (port != this.socket.getLocalPort()) {
            return true;
        }
        for (SubNet s : this.subnets) {
            if (!s.address.equals(address)) continue;
            return false;
        }
        return true;
    }

    private void handleDatagramPacket(DatagramPacket p) {
        try {
            long time = System.currentTimeMillis();
            byte[] buf = p.getData();
            int len = p.getLength();
            if (len < 8) {
                return;
            }
            if (buf[0] != 84) {
                return;
            }
            if (buf[1] != 67) {
                return;
            }
            if (buf[2] != 70) {
                return;
            }
            if (buf[3] != 50) {
                return;
            }
            int remote_port = p.getPort();
            InetAddress remote_address = p.getAddress();
            if (this.isRemote(remote_address, remote_port)) {
                Slave sl = null;
                if (p.getPort() != 1534) {
                    sl = this.addSlave(remote_address, remote_port, time);
                }
                switch (buf[4]) {
                    case 2: {
                        this.handlePeerInfoPacket(p);
                        break;
                    }
                    case 1: {
                        this.handleReqInfoPacket(p, sl, time);
                        break;
                    }
                    case 4: {
                        this.handleSlavesInfoPacket(p);
                        break;
                    }
                    case 3: {
                        this.handleReqSlavesPacket(p, sl, time);
                    }
                }
                for (SubNet s : this.subnets) {
                    if (!s.contains(remote_address)) continue;
                    long delay = 20000L;
                    if (remote_port != 1534) {
                        delay = 40000L;
                    } else if (!s.address.equals(remote_address)) {
                        delay = 30000L;
                    }
                    if (s.last_slaves_req_time + delay <= time) {
                        this.sendSlavesRequest(remote_address, remote_port);
                        s.last_slaves_req_time = time;
                    }
                    if (!s.address.equals(remote_address) || remote_port != 1534) continue;
                    this.last_master_packet_time = time;
                }
            }
        }
        catch (Throwable x) {
            Protocol.log("Invalid datagram packet received", x);
        }
    }

    private void handlePeerInfoPacket(DatagramPacket p) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            String s = new String(p.getData(), 8, p.getLength() - 8, "UTF-8");
            int l = s.length();
            int i = 0;
            while (i < l) {
                int i0 = i;
                while (i < l && s.charAt(i) != '=' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int i1 = i;
                if (i >= l || s.charAt(i) == '=') {
                    // empty if block
                }
                int i2 = ++i;
                while (i < l && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int i3 = i;
                if (i < l && s.charAt(i) == '\u0000') {
                    ++i;
                }
                String key = s.substring(i0, i1);
                String val = s.substring(i2, i3);
                map.put(key, val);
            }
            String id = (String)map.get("ID");
            if (id == null) {
                throw new Exception("Invalid peer info: no ID");
            }
            String peer_host = (String)map.get("Host");
            if (peer_host == null) {
                return;
            }
            InetAddress peer_addr = InetAddress.getByName(peer_host);
            for (SubNet subnet : this.subnets) {
                if (!subnet.contains(peer_addr)) continue;
                IPeer peer = peers.get(id);
                if (peer instanceof RemotePeer) {
                    ((RemotePeer)peer).updateAttributes(map);
                } else if (peer == null) {
                    new RemotePeer(map);
                }
                break;
            }
        }
        catch (Exception x) {
            Protocol.log("Invalid datagram packet received", x);
        }
    }

    private void handleReqInfoPacket(DatagramPacket p, Slave sl, long time) {
        this.sendAll(p.getAddress(), p.getPort(), sl, time);
    }

    private void handleSlavesInfoPacket(DatagramPacket p) {
        try {
            String s = new String(p.getData(), 8, p.getLength() - 8, "UTF-8");
            int l = s.length();
            int i = 0;
            while (i < l) {
                int port;
                int time0 = i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int time1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int port0 = ++i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int port1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int host0 = ++i;
                while (i < l && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int host1 = i;
                if (i < l && s.charAt(i) == '\u0000') {
                    ++i;
                }
                if ((port = Integer.parseInt(s.substring(port0, port1))) == 1534) continue;
                String host = s.substring(host0, host1);
                long time = time0 != time1 ? Long.parseLong(s.substring(time0, time1)) : System.currentTimeMillis();
                this.addSlave(InetAddress.getByName(host), port, time);
            }
        }
        catch (Exception x) {
            Protocol.log("Invalid datagram packet received", x);
        }
    }

    private void handleReqSlavesPacket(DatagramPacket p, Slave sl, long time) {
        if (sl != null) {
            sl.last_req_slaves_time = time;
        }
        this.sendSlavesInfo(p.getAddress(), p.getPort(), time);
    }

    public static LocatorService getLocator() {
        return locator;
    }

    @Override
    public String getName() {
        return "Locator";
    }

    @Override
    public Map<String, IPeer> getPeers() {
        assert (Protocol.isDispatchThread());
        return peers;
    }

    @Override
    public IToken redirect(String peer_id, ILocator.DoneRedirect done) {
        throw new Error("Channel redirect cannot be done on local peer");
    }

    @Override
    public IToken sync(ILocator.DoneSync done) {
        throw new Error("Channel sync cannot be done on local peer");
    }

    @Override
    public void addListener(ILocator.LocatorListener listener) {
        assert (listener != null);
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
    }

    @Override
    public void removeListener(ILocator.LocatorListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
    }

    private static class Slave {
        final InetAddress address;
        final int port;
        long last_packet_time;
        long last_req_slaves_time;

        Slave(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public String toString() {
            return String.valueOf(this.address.getHostAddress()) + ":" + this.port;
        }
    }

    private static class SubNet {
        final int prefix_length;
        final InetAddress address;
        final InetAddress broadcast;
        long last_slaves_req_time;
        boolean send_all_ok;

        SubNet(int prefix_length, InetAddress address, InetAddress broadcast) {
            this.prefix_length = prefix_length;
            this.address = address;
            this.broadcast = broadcast;
        }

        boolean contains(InetAddress addr) {
            int n;
            if (addr == null) {
                return false;
            }
            byte[] a1 = addr.getAddress();
            byte[] a2 = this.broadcast.getAddress();
            int i = 0;
            while (i + 8 <= this.prefix_length) {
                n = i / 8;
                if (a1[n] != a2[n]) {
                    return false;
                }
                i += 8;
            }
            while (i < this.prefix_length) {
                n = i / 8;
                int m = 1 << 7 - i % 8;
                if ((a1[n] & m) != (a2[n] & m)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SubNet)) {
                return false;
            }
            SubNet x = (SubNet)o;
            return this.prefix_length == x.prefix_length && this.broadcast.equals(x.broadcast) && this.address.equals(x.address);
        }

        public int hashCode() {
            return this.broadcast.hashCode();
        }

        public String toString() {
            return String.valueOf(this.broadcast.getHostAddress()) + "/" + this.prefix_length;
        }
    }
}

