/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IErrorReport;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IFileSystem;

public class FileSystemProxy
implements IFileSystem {
    private final IChannel channel;

    public FileSystemProxy(IChannel channel) {
        this.channel = channel;
    }

    public IToken close(IFileSystem.IFileHandle handle, final IFileSystem.DoneClose done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        return new FileSystemCommand((String)"close", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneClose(this.token, s);
            }
        }.token;
    }

    public IToken setstat(String path, IFileSystem.FileAttrs attrs, final IFileSystem.DoneSetStat done) {
        Object dt = this.toObject(attrs);
        return new FileSystemCommand((String)"setstat", (Object[])new Object[]{path, dt}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneSetStat(this.token, s);
            }
        }.token;
    }

    public IToken fsetstat(IFileSystem.IFileHandle handle, IFileSystem.FileAttrs attrs, final IFileSystem.DoneSetStat done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        Object dt = this.toObject(attrs);
        return new FileSystemCommand((String)"fsetstat", (Object[])new Object[]{id, dt}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneSetStat(this.token, s);
            }
        }.token;
    }

    public IToken stat(String path, final IFileSystem.DoneStat done) {
        return new FileSystemCommand((String)"stat", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                IFileSystem.FileAttrs a = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        a = FileSystemProxy.this.toFileAttrs(args[1]);
                    }
                }
                done.doneStat(this.token, s, a);
            }
        }.token;
    }

    public IToken fstat(IFileSystem.IFileHandle handle, final IFileSystem.DoneStat done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        return new FileSystemCommand((String)"fstat", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                IFileSystem.FileAttrs a = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        a = FileSystemProxy.this.toFileAttrs(args[1]);
                    }
                }
                done.doneStat(this.token, s, a);
            }
        }.token;
    }

    public IToken lstat(String path, final IFileSystem.DoneStat done) {
        return new FileSystemCommand((String)"lstat", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                IFileSystem.FileAttrs a = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        a = FileSystemProxy.this.toFileAttrs(args[1]);
                    }
                }
                done.doneStat(this.token, s, a);
            }
        }.token;
    }

    public IToken mkdir(String path, IFileSystem.FileAttrs attrs, final IFileSystem.DoneMkDir done) {
        Object dt = this.toObject(attrs);
        return new FileSystemCommand((String)"mkdir", (Object[])new Object[]{path, dt}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneMkDir(this.token, s);
            }
        }.token;
    }

    public IToken open(String file_name, int flags, IFileSystem.FileAttrs attrs, final IFileSystem.DoneOpen done) {
        Object dt = this.toObject(attrs);
        return new FileSystemCommand((String)"open", (Object[])new Object[]{file_name, new Integer((int)flags), dt}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                FileHandle h = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        h = FileSystemProxy.this.toFileHandle(args[1]);
                    }
                }
                done.doneOpen(this.token, s, h);
            }
        }.token;
    }

    public IToken opendir(String path, final IFileSystem.DoneOpen done) {
        return new FileSystemCommand((String)"opendir", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                FileHandle h = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        h = FileSystemProxy.this.toFileHandle(args[1]);
                    }
                }
                done.doneOpen(this.token, s, h);
            }
        }.token;
    }

    public IToken read(IFileSystem.IFileHandle handle, long offset, int len, final IFileSystem.DoneRead done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        return new FileSystemCommand((String)"read", (Object[])new Object[]{id, Long.valueOf((long)offset), Integer.valueOf((int)len)}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                byte[] b = null;
                boolean eof = false;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 3) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[1]);
                    if (s == null) {
                        b = JSON.toByteArray(args[0]);
                        eof = (Boolean)args[2];
                    }
                }
                done.doneRead(this.token, s, b, eof);
            }
        }.token;
    }

    public IToken readdir(IFileSystem.IFileHandle handle, final IFileSystem.DoneReadDir done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        return new FileSystemCommand((String)"readdir", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                IFileSystem.DirEntry[] b = null;
                boolean eof = false;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 3) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[1]);
                    if (s == null) {
                        b = FileSystemProxy.this.toDirEntryArray(args[0]);
                        eof = (Boolean)args[2];
                    }
                }
                done.doneReadDir(this.token, s, b, eof);
            }
        }.token;
    }

    public IToken roots(final IFileSystem.DoneRoots done) {
        return new FileSystemCommand((String)"roots", null){

            public void done(Exception error, Object[] args) {
                Status s = null;
                IFileSystem.DirEntry[] b = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[1]);
                    if (s == null) {
                        b = FileSystemProxy.this.toDirEntryArray(args[0]);
                    }
                }
                done.doneRoots(this.token, s, b);
            }
        }.token;
    }

    public IToken readlink(String path, final IFileSystem.DoneReadLink done) {
        return new FileSystemCommand((String)"readlink", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                String p = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        p = (String)args[1];
                    }
                }
                done.doneReadLink(this.token, s, p);
            }
        }.token;
    }

    public IToken realpath(String path, final IFileSystem.DoneRealPath done) {
        return new FileSystemCommand((String)"realpath", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                String p = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                    if (s == null) {
                        p = (String)args[1];
                    }
                }
                done.doneRealPath(this.token, s, p);
            }
        }.token;
    }

    public IToken remove(String file_name, final IFileSystem.DoneRemove done) {
        return new FileSystemCommand((String)"remove", (Object[])new Object[]{file_name}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneRemove(this.token, s);
            }
        }.token;
    }

    public IToken rename(String old_path, String new_path, final IFileSystem.DoneRename done) {
        return new FileSystemCommand((String)"rename", (Object[])new Object[]{old_path, new_path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneRename(this.token, s);
            }
        }.token;
    }

    public IToken rmdir(String path, final IFileSystem.DoneRemove done) {
        return new FileSystemCommand((String)"rmdir", (Object[])new Object[]{path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneRemove(this.token, s);
            }
        }.token;
    }

    public IToken symlink(String link_path, String target_path, final IFileSystem.DoneSymLink done) {
        return new FileSystemCommand((String)"symlink", (Object[])new Object[]{link_path, target_path}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneSymLink(this.token, s);
            }
        }.token;
    }

    public IToken write(IFileSystem.IFileHandle handle, long offset, byte[] data, int data_pos, int data_size, final IFileSystem.DoneWrite done) {
        assert (handle.getService() == this);
        String id = ((FileHandle)handle).id;
        return new FileSystemCommand((String)"write", (Object[])new Object[]{id, Long.valueOf((long)offset), new JSON.Binary((byte[])data, (int)data_pos, (int)data_size)}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneWrite(this.token, s);
            }
        }.token;
    }

    public IToken copy(String src_path, String dst_path, boolean copy_permissions, boolean copy_uidgid, final IFileSystem.DoneCopy done) {
        return new FileSystemCommand((String)"copy", (Object[])new Object[]{src_path, dst_path, Boolean.valueOf((boolean)copy_permissions), Boolean.valueOf((boolean)copy_uidgid)}){

            public void done(Exception error, Object[] args) {
                Status s = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    s = this.toFSError(args[0]);
                }
                done.doneCopy(this.token, s);
            }
        }.token;
    }

    public IToken user(final IFileSystem.DoneUser done) {
        return new FileSystemCommand((String)"user", null){

            public void done(Exception error, Object[] args) {
                Status s = null;
                int r_uid = 0;
                int e_uid = 0;
                int r_gid = 0;
                int e_gid = 0;
                String home = null;
                if (error != null) {
                    s = new Status(error);
                } else {
                    if (!$assertionsDisabled && args.length != 5) {
                        throw new AssertionError();
                    }
                    r_uid = ((Number)args[0]).intValue();
                    e_uid = ((Number)args[1]).intValue();
                    r_gid = ((Number)args[2]).intValue();
                    e_gid = ((Number)args[3]).intValue();
                    home = (String)args[4];
                }
                done.doneUser(this.token, s, r_uid, e_uid, r_gid, e_gid, home);
            }
        }.token;
    }

    public String getName() {
        return "FileSystem";
    }

    private Object toObject(IFileSystem.FileAttrs attrs) {
        if (attrs == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (attrs.attributes != null) {
            m.putAll(attrs.attributes);
        }
        if ((attrs.flags & 1) != 0) {
            m.put("Size", attrs.size);
        }
        if ((attrs.flags & 2) != 0) {
            m.put("UID", attrs.uid);
            m.put("GID", attrs.gid);
        }
        if ((attrs.flags & 4) != 0) {
            m.put("Permissions", attrs.permissions);
        }
        if ((attrs.flags & 8) != 0) {
            m.put("ATime", attrs.atime);
            m.put("MTime", attrs.mtime);
        }
        return m;
    }

    private IFileSystem.FileAttrs toFileAttrs(Object o) {
        if (o == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>((Map)o);
        int flags = 0;
        long size = 0L;
        int uid = 0;
        int gid = 0;
        int permissions = 0;
        long atime = 0L;
        long mtime = 0L;
        Number n = (Number)m.remove("Size");
        if (n != null) {
            size = n.longValue();
            flags |= 1;
        }
        Number n1 = (Number)m.remove("UID");
        Number n2 = (Number)m.remove("GID");
        if (n1 != null && n2 != null) {
            uid = n1.intValue();
            gid = n2.intValue();
            flags |= 2;
        }
        if ((n = (Number)m.remove("Permissions")) != null) {
            permissions = n.intValue();
            flags |= 4;
        }
        n1 = (Number)m.remove("ATime");
        n2 = (Number)m.remove("MTime");
        if (n1 != null && n2 != null) {
            atime = n1.longValue();
            mtime = n2.longValue();
            flags |= 8;
        }
        return new IFileSystem.FileAttrs(flags, size, uid, gid, permissions, atime, mtime, m);
    }

    private FileHandle toFileHandle(Object o) {
        if (o == null) {
            return null;
        }
        return new FileHandle(o.toString());
    }

    private IFileSystem.DirEntry[] toDirEntryArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        IFileSystem.DirEntry[] res = new IFileSystem.DirEntry[c.size()];
        int i = 0;
        for (Map m : c) {
            res[i++] = new IFileSystem.DirEntry((String)m.get("FileName"), (String)m.get("LongName"), this.toFileAttrs(m.get("Attrs")));
        }
        return res;
    }

    private final class FileHandle
    implements IFileSystem.IFileHandle {
        final String id;

        FileHandle(String id) {
            this.id = id;
        }

        public IFileSystem getService() {
            return FileSystemProxy.this;
        }

        public String toString() {
            return "[File Handle '" + this.id + "']";
        }
    }

    private abstract class FileSystemCommand
    extends Command {
        FileSystemCommand(String command, Object[] args) {
            super(FileSystemProxy.this.channel, FileSystemProxy.this, command, args);
        }

        public Status toFSError(Object data) {
            if (data == null) {
                return null;
            }
            Map map = (Map)data;
            Number error_code = (Number)map.get("Code");
            String cmd = this.getCommandString();
            if (cmd.length() > 72) {
                cmd = String.valueOf(cmd.substring(0, 72)) + "...";
            }
            Status s = new Status(error_code.intValue(), "TCF command exception:\nCommand: " + cmd + "\nException: " + FileSystemCommand.toErrorString(data) + "\nError code: " + error_code, map);
            Object caused_by = map.get("CausedBy");
            if (caused_by != null) {
                s.initCause(this.toError(caused_by, false));
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Status
    extends IFileSystem.FileSystemException
    implements IErrorReport {
        private static final long serialVersionUID = -1636567076145085980L;
        private final int status;
        private final Map<String, Object> attrs;

        Status(int status, String message, Map<String, Object> attrs) {
            super(message);
            this.status = status;
            this.attrs = attrs;
        }

        Status(Exception x) {
            super(x);
            this.status = 1;
            this.attrs = new HashMap<String, Object>();
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public int getErrorCode() {
            Number n = (Number)this.attrs.get("Code");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public int getAltCode() {
            Number n = (Number)this.attrs.get("AltCode");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getAltOrg() {
            return (String)this.attrs.get("AltOrg");
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attrs;
        }
    }
}

