/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.tcf.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tm.tcf.core.Command;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.protocol.JSON;
import org.eclipse.tm.tcf.services.IBreakpoints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreakpointsProxy
implements IBreakpoints {
    private final IChannel channel;
    private final Map<IBreakpoints.BreakpointsListener, IChannel.IEventListener> listeners = new HashMap<IBreakpoints.BreakpointsListener, IChannel.IEventListener>();

    public BreakpointsProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public IToken set(Map<String, Object>[] properties, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"set", (Object[])new Object[]{properties}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken add(Map<String, Object> properties, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"add", (Object[])new Object[]{properties}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken change(Map<String, Object> properties, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"change", (Object[])new Object[]{properties}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken disable(String[] ids, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"disable", (Object[])new Object[]{ids}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken enable(String[] ids, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"enable", (Object[])new Object[]{ids}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken remove(String[] ids, final IBreakpoints.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"remove", (Object[])new Object[]{ids}){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken getIDs(final IBreakpoints.DoneGetIDs done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getIDs", null){

            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = BreakpointsProxy.this.toStringArray(args[1]);
                }
                done.doneGetIDs(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken getProperties(String id, final IBreakpoints.DoneGetProperties done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getProperties", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Map map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = (Map)args[1];
                }
                done.doneGetProperties(this.token, error, map);
            }
        }.token;
    }

    @Override
    public IToken getStatus(String id, final IBreakpoints.DoneGetStatus done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getStatus", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Map map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = (Map)args[1];
                }
                done.doneGetStatus(this.token, error, map);
            }
        }.token;
    }

    @Override
    public IToken getCapabilities(String id, final IBreakpoints.DoneGetCapabilities done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getCapabilities", (Object[])new Object[]{id}){

            public void done(Exception error, Object[] args) {
                Map map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = (Map)args[1];
                }
                done.doneGetCapabilities(this.token, error, map);
            }
        }.token;
    }

    @Override
    public String getName() {
        return "Breakpoints";
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private Map<String, Object>[] toBreakpointArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new Map[c.size()]);
    }

    @Override
    public void addListener(final IBreakpoints.BreakpointsListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            public void event(String name, byte[] data) {
                block10: {
                    try {
                        Object[] args = JSON.parseSequence(data);
                        if (name.equals("status")) {
                            if (!$assertionsDisabled && args.length != 2) {
                                throw new AssertionError();
                            }
                            listener.breakpointStatusChanged((String)args[0], (Map)args[1]);
                            break block10;
                        }
                        if (name.equals("contextAdded")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextAdded(BreakpointsProxy.this.toBreakpointArray(args[0]));
                            break block10;
                        }
                        if (name.equals("contextChanged")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextChanged(BreakpointsProxy.this.toBreakpointArray(args[0]));
                            break block10;
                        }
                        if (name.equals("contextRemoved")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextRemoved(BreakpointsProxy.this.toStringArray(args[0]));
                            break block10;
                        }
                        throw new IOException("Breakpoints service: unknown event: " + name);
                    }
                    catch (Throwable x) {
                        BreakpointsProxy.this.channel.terminate(x);
                    }
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeListener(IBreakpoints.BreakpointsListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }
}

