/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.services.IFileSystem;
import org.eclipse.tm.tcf.util.TCFTask;

public final class TCFFileOutputStream
extends OutputStream {
    private static final int MAX_WRITE_BACK = 8;
    private final IFileSystem.IFileHandle handle;
    private final IFileSystem fs;
    private final int buf_size;
    private final Set<IToken> write_commands = new HashSet<IToken>();
    private final int[] dirty = new int[1];
    private final byte[] buf;
    private int buf_pos = 0;
    private long offset = 0L;
    private IOException flush_error;
    private boolean closed;

    public TCFFileOutputStream(IFileSystem.IFileHandle handle) {
        this(handle, 4096);
    }

    public TCFFileOutputStream(IFileSystem.IFileHandle handle, int buf_size) {
        this.handle = handle;
        this.fs = handle.getService();
        this.buf_size = buf_size;
        this.buf = new byte[buf_size];
    }

    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.buf_pos == this.buf_size) {
            this.flush();
        }
        this.buf[this.buf_pos++] = (byte)b;
    }

    /*
     * Unable to fully structure code
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off >= 0 && off <= b.length && len >= 0 && off + len <= b.length && off + len >= 0) ** GOTO lbl19
        throw new IndexOutOfBoundsException();
lbl-1000:
        // 1 sources

        {
            if (this.buf_pos == this.buf_size) {
                this.flush();
            }
            if (this.buf_pos == 0 && len > this.buf_size) {
                this.flush(b, off, len);
                return;
            }
            n = this.buf_size - this.buf_pos;
            if (len < n) {
                n = len;
            }
            System.arraycopy(b, off, this.buf, this.buf_pos, n);
            off += n;
            len -= n;
            this.buf_pos += n;
lbl19:
            // 2 sources

            ** while (len > 0)
        }
lbl20:
        // 1 sources

    }

    public synchronized void flush() throws IOException {
        if (this.buf_pos == 0) {
            return;
        }
        this.flush(this.buf, 0, this.buf_pos);
        this.buf_pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void flush(final byte[] buf, final int off, final int len) throws IOException {
        var4_4 = this.dirty;
        synchronized (this.dirty) {
            if (this.flush_error == null) ** GOTO lbl11
            throw this.flush_error;
lbl-1000:
            // 1 sources

            {
                try {
                    this.dirty.wait();
                    continue;
                }
                catch (InterruptedException v0) {
                    throw new InterruptedIOException();
                }
lbl11:
                // 2 sources

                ** while (this.dirty[0] >= 8)
            }
lbl12:
            // 1 sources

            // ** MonitorExit[var4_4] (shouldn't be in output)
            new TCFTask<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TCFFileOutputStream.this.write_commands.add(TCFFileOutputStream.this.fs.write(TCFFileOutputStream.this.handle, TCFFileOutputStream.this.offset, buf, off, len, new IFileSystem.DoneWrite(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
                            if (!$assertionsDisabled && !TCFFileOutputStream.this.write_commands.contains(token)) {
                                throw new AssertionError();
                            }
                            TCFFileOutputStream.this.write_commands.remove(token);
                            if (error != null) {
                                Iterator i = TCFFileOutputStream.this.write_commands.iterator();
                                while (i.hasNext()) {
                                    if (!((IToken)i.next()).cancel()) continue;
                                    i.remove();
                                }
                            }
                            int[] nArray = TCFFileOutputStream.this.dirty;
                            synchronized (nArray) {
                                if (error != null && TCFFileOutputStream.this.flush_error == null) {
                                    TCFFileOutputStream.this.flush_error = error;
                                }
                                ((TCFFileOutputStream)(this).TCFFileOutputStream.this).dirty[0] = TCFFileOutputStream.this.write_commands.size();
                                TCFFileOutputStream.this.dirty.notifyAll();
                            }
                        }
                    }));
                    int[] nArray = TCFFileOutputStream.this.dirty;
                    synchronized (nArray) {
                        ((TCFFileOutputStream)TCFFileOutputStream.this).dirty[0] = TCFFileOutputStream.this.write_commands.size();
                    }
                    this.done(this);
                }
            }.getIO();
            this.offset += (long)len;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        int[] nArray = this.dirty;
        synchronized (this.dirty) {
            while (this.dirty[0] > 0) {
                try {
                    this.dirty.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            new TCFTask<Object>(){

                @Override
                public void run() {
                    TCFFileOutputStream.this.fs.close(TCFFileOutputStream.this.handle, new IFileSystem.DoneClose(){

                        public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                            if (error != null) {
                                this.error(error);
                            } else {
                                this.done(this);
                            }
                        }
                    });
                }
            }.getIO();
            this.closed = true;
            return;
        }
    }
}

