/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.tcf.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.core.ChannelTCP;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.Protocol;

public class ServerTCP
extends ServerSocket {
    private final String name;
    private List<ServerPeer> peers;
    private Thread thread;

    public ServerTCP(String name, int port) throws IOException {
        super(port);
        this.name = name;
        this.peers = new ArrayList<ServerPeer>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface f = e.nextElement();
            Enumeration<InetAddress> n = f.getInetAddresses();
            while (n.hasMoreElements()) {
                this.peers.add(this.getLocalPeer(n.nextElement().getHostAddress()));
            }
        }
        this.thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        final Socket socket = ServerTCP.this.accept();
                        Protocol.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    new ChannelTCP(ServerTCP.this.getLocalPeer(socket), ServerTCP.this.getRemotePeer(socket), socket);
                                }
                                catch (Throwable x) {
                                    Protocol.log("TCF Server: failed to create a channel", x);
                                }
                            }
                        });
                    }
                }
                catch (Throwable x) {
                    Protocol.invokeLater(new Runnable(){

                        public void run() {
                            Protocol.log("TCF Server thread aborted", x);
                        }
                    });
                    return;
                }
            }
        };
        this.thread.setName(name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private ServerPeer getLocalPeer(String addr) {
        for (ServerPeer p : this.peers) {
            if (!addr.equals(p.getAttributes().get("Host"))) continue;
            return p;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("ID", "TCP:" + addr + ":" + this.getLocalPort());
        attrs.put("Name", this.name);
        attrs.put("OSName", System.getProperty("os.name"));
        attrs.put("TransportName", "TCP");
        attrs.put("Host", addr);
        attrs.put("Port", Integer.toString(this.getLocalPort()));
        attrs.put("Proxy", "");
        ServerPeer p = new ServerPeer(attrs);
        this.peers.add(p);
        return p;
    }

    private IPeer getLocalPeer(Socket socket) {
        return this.getLocalPeer(socket.getLocalAddress().getHostAddress());
    }

    private IPeer getRemotePeer(Socket socket) {
        String addr = socket.getInetAddress().getHostAddress();
        for (IPeer p : Protocol.getLocator().getPeers().values()) {
            if (!addr.equals(p.getAttributes().get("Host"))) continue;
            return p;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("ID", "TCP:" + addr + ":");
        attrs.put("TransportName", "TCP");
        attrs.put("Host", addr);
        return new RemotePeer(attrs);
    }

    public void close() throws IOException {
        if (this.peers != null) {
            for (ServerPeer s : this.peers) {
                s.dispose();
            }
            this.peers = null;
        }
        super.close();
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemotePeer
    extends AbstractPeer {
        RemotePeer(Map<String, String> attrs) {
            super(attrs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServerPeer
    extends AbstractPeer {
        ServerPeer(Map<String, String> attrs) {
            super(attrs);
        }
    }
}

