/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionAccess;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.RemoteDevice;

abstract class BluetoothL2CAPConnection
implements L2CAPConnection,
BluetoothConnectionAccess {
    protected BluetoothStack bluetoothStack;
    protected volatile long handle;
    protected int securityOpt;
    private RemoteDevice remoteDevice;
    private boolean isClosed;

    protected BluetoothL2CAPConnection(BluetoothStack bluetoothStack, long handle) {
        this.bluetoothStack = bluetoothStack;
        this.handle = handle;
        this.isClosed = false;
    }

    public long getRemoteAddress() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        return this.bluetoothStack.l2RemoteAddress(this.handle);
    }

    public int getReceiveMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        return this.bluetoothStack.l2GetReceiveMTU(this.handle);
    }

    public int getTransmitMTU() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        return this.bluetoothStack.l2GetTransmitMTU(this.handle);
    }

    public boolean ready() throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        return this.bluetoothStack.l2Ready(this.handle);
    }

    public int receive(byte[] inBuf) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        if (inBuf == null) {
            throw new NullPointerException("inBuf is null");
        }
        return this.bluetoothStack.l2Receive(this.handle, inBuf);
    }

    public void send(byte[] data) throws IOException {
        if (this.isClosed) {
            throw new IOException("Connection closed");
        }
        if (data == null) {
            throw new NullPointerException("data is null");
        }
        this.bluetoothStack.l2Send(this.handle, data);
    }

    abstract void closeConnectionHandle(long var1) throws IOException;

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        if (this.handle != 0L) {
            long synchronizedHandle;
            DebugLog.debug("closing L2CAP Connection", this.handle);
            BluetoothL2CAPConnection bluetoothL2CAPConnection = this;
            synchronized (bluetoothL2CAPConnection) {
                synchronizedHandle = this.handle;
                this.handle = 0L;
            }
            if (synchronizedHandle != 0L) {
                this.closeConnectionHandle(synchronizedHandle);
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void markAuthenticated() {
        if (this.securityOpt == 0) {
            this.securityOpt = 1;
        }
    }

    public int getSecurityOpt() {
        try {
            this.securityOpt = this.bluetoothStack.l2GetSecurityOpt(this.handle, this.securityOpt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.securityOpt;
    }

    public boolean encrypt(long address, boolean on) throws IOException {
        if (this.isClosed) {
            throw new IOException("L2CAP Connection is already closed");
        }
        boolean changed = this.bluetoothStack.l2Encrypt(address, this.handle, on);
        if (changed) {
            this.securityOpt = on ? 2 : 1;
        }
        return changed;
    }

    public RemoteDevice getRemoteDevice() {
        return this.remoteDevice;
    }

    public void setRemoteDevice(RemoteDevice remoteDevice) {
        this.remoteDevice = remoteDevice;
    }

    public BluetoothStack getBluetoothStack() {
        return this.bluetoothStack;
    }
}

