
///////////////////////////////////////////////////////////////////////////////
// Reference to the WRTKit user interface manager and main view.
var uiManager;
var mainView, photoSetView, photosView;

var jsonFlickrUserDetails = null;
function getFlickrUserIdSuccess(json)
{
	jsonFlickrUserDetails = json;
	if(json['stat'] == 'ok')
	{
		// init Step-2
		uiManager.showNotification(-1, "wait", "Getting Flickr photosets from <strong>"+ json['user']['username']['_content'] + "</strong> account");
		callAsync(flickrPhotoSetsGetlist + json['user']['id'], getFlickrPhotoSetsSuccess);
	}
	else
	{
		uiManager.showNotification(2000, "warning", json['message']);
	}
	
}

var jsonFlickrPhotoSets = null;
function getFlickrPhotoSetsSuccess(json)
{
	jsonFlickrPhotoSets = json;
	if(json['stat'] == 'ok')
	{
		if(!json['photosets'])
		{
			uiManager.showNotification(2000, "warning", "No Photo sets found!");
			return false;
		}	

		if(!json['photosets']['photoset'].length)
		{
			uiManager.showNotification(2000, "warning", "No Photo sets found!");
			return false;
		}	

		/*
		 * Create the Photo Sets list view
		 */
		photoSetView.setCaption(jsonFlickrUserDetails['user']['username']['_content']);
	    for(var i=0; i<json['photosets']['photoset'].length; i++)
		{
			var row = json['photosets']['photoset'][i];
			var thumbnailImgUrl = "http://farm4.static.flickr.com/"+ row['server'] +"/"+ row['primary'] +"_"+ row['secret'] +"_s.jpg";
			var setContainer = new NavigationButton(i, thumbnailImgUrl, row['title']['_content']+"<br/><span class='numPhotos'>"+row['photos']+" Photos</span>");
			setContainer.addEventListener("ActionPerformed", getPhotosFromSet);
			photoSetView.addControl(setContainer);
		}

		uiManager.setView(photoSetView);
	}
	else
	{
		uiManager.showNotification(2000, "warning", json['message']);
	}
	
}


function getPhotosFromSet(event)
{
	// Step-3
	// Show all the set of images fromm the selected set
	uiManager.showNotification(-1, "wait", "Getting Images from the set: <strong>"+ jsonFlickrPhotoSets['photosets']['photoset'][event.source.id]['title']['_content'] + "</strong>");
	photosView.setCaption(jsonFlickrPhotoSets['photosets']['photoset'][event.source.id]['title']['_content'].substr(0, 25) + '...');
	callAsync(flickrGetPhotos + jsonFlickrPhotoSets['photosets']['photoset'][event.source.id]['id'], getFlickrPhotosSuccess);
}

var jsonFlickrPhotos = null;
function getFlickrPhotosSuccess(json)
{
	jsonFlickrPhotos = json;
	if(json['stat'] == 'ok')
	{
		if(!json['photoset'])
		{
			uiManager.showNotification(2000, "warning", "No Photo sets found in the set!");
			return false;
		}	

		if(!json['photoset']['photo'].length)
		{
			uiManager.showNotification(2000, "warning", "No Photo sets found in the set!");
			return false;
		}	
		
		/*
		 * Remove all the existing controls
		 */
		var controlArr = photosView.getControls();
	    for (var j = controlArr.length-1; j > -1 ; j--) 
		{
			photosView.removeControl(controlArr[j]);
		}		
		
		/*
		 * Create the Photo list view
		 */
		var setContainer, thumbnailImgUrl, row;

		//	Show Softkeys to go to Previous view
		if (window.menu) {
			menu.setRightSoftkeyLabel("Back", showPhotoSetView);
		}


	    for(var i=0; i<json['photoset']['photo'].length; i++)
		{
			row = json['photoset']['photo'][i];
			thumbnailImgUrl = "http://farm4.static.flickr.com/"+ row['server'] +"/"+ row['id'] +"_"+ row['secret'] +"_s.jpg";
			photosView.addControl(new NavigationButton(i, thumbnailImgUrl, row['title']));
		}
		
		uiManager.setView(photosView);
		
	}
	else
	{
		uiManager.showNotification(2000, "warning", json['message']);
	}
	
}


function showPhotoSetView()
{
	//	Show Softkeys to go to Previous view
	if (window.menu) {
		menu.setRightSoftkeyLabel("", null);
	}
	
	// Show Photo-Set view
	uiManager.setView(photoSetView);
}


var jsonObj;
var xmlhttp = null;
function callAsync(url, callbackSuccess)
{
	xmlhttp = new Ajax();
	xmlhttp.open("GET", url, true);
	xmlhttp.onreadystatechange=function() 
	{
		// readyState = 4 ; "complete"
		if (xmlhttp.readyState==4)
		{
			// status = 200 ; "ok"
			if(xmlhttp.status == 200)
			{
				uiManager.showNotification(1000, "ok", "Done");
				/*
				 * 	Remove the substr "jsonFlickrApi(" from the responseText
				 */
				var text = xmlhttp.responseText;
				text = text.substr(14, text.length-15);
	
				//	Create JSON Oject
				jsonObj = eval('(' + text + ')');
				
				callbackSuccess(jsonObj);
			}
			else
			{
				uiManager.showNotification(1000, "warning", "Failed to get data from server");
			}
		}
	};
	xmlhttp.send(null);
}

