/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionNotifierParams;
import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.DeviceInquiryRunnable;
import com.intel.bluetooth.DeviceInquiryThread;
import com.intel.bluetooth.NotSupportedIOException;
import com.intel.bluetooth.NotSupportedRuntimeException;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesDeviceNotReachableException;
import com.intel.bluetooth.SearchServicesException;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesTerminatedException;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;

class BluetoothStackBlueZ
implements BluetoothStack {
    public static final String NATIVE_BLUECOVE_LIB_BLUEZ = "bluecove";
    static final int NATIVE_LIBRARY_VERSION = 2010051;
    private static final int ATTR_RETRIEVABLE_MAX = 256;
    private static final int LISTEN_BACKLOG_RFCOMM = 4;
    private static final int LISTEN_BACKLOG_L2CAP = 4;
    private static final Vector devicesUsed = new Vector();
    private int deviceID = -1;
    private int deviceDescriptor;
    private long localDeviceBTAddress;
    private long sdpSesion;
    private int registeredServicesCount = 0;
    private Hashtable propertiesMap;
    private DiscoveryListener discoveryListener;
    private Vector discoveredDevices;
    private boolean deviceInquiryCanceled = false;
    private final int l2cap_receiveMTU_max = 65535;

    BluetoothStackBlueZ() {
    }

    public String getStackID() {
        return "bluez";
    }

    public String toString() {
        if (this.deviceID >= 0) {
            return this.getStackID() + ":" + this.deviceID;
        }
        return this.getStackID();
    }

    public native boolean isNativeCodeLoaded();

    public BluetoothStack.LibraryInformation[] requireNativeLibraries() {
        return BluetoothStack.LibraryInformation.library(NATIVE_BLUECOVE_LIB_BLUEZ);
    }

    public native int getLibraryVersionNative();

    public int getLibraryVersion() throws BluetoothStateException {
        int version = this.getLibraryVersionNative();
        if (version != 2010051) {
            DebugLog.fatal("BlueCove native library version mismatch " + version + " expected " + 2010051);
            throw new BluetoothStateException("BlueCove native library version mismatch");
        }
        return version;
    }

    public int detectBluetoothStack() {
        return 32;
    }

    private native int nativeGetDeviceID(int var1, long var2) throws BluetoothStateException;

    private native int nativeOpenDevice(int var1) throws BluetoothStateException;

    public void initialize() throws BluetoothStateException {
        int foundDeviceID;
        long findLocalDeviceBTAddress = -1L;
        int findID = BlueCoveImpl.getConfigProperty("bluecove.deviceID", -1);
        String deviceAddressStr = BlueCoveImpl.getConfigProperty("bluecove.deviceAddress");
        if (deviceAddressStr != null) {
            findLocalDeviceBTAddress = Long.parseLong(deviceAddressStr, 16);
        }
        if (devicesUsed.contains(new Long(foundDeviceID = this.nativeGetDeviceID(findID, findLocalDeviceBTAddress)))) {
            throw new BluetoothStateException("LocalDevice " + foundDeviceID + " alredy in use");
        }
        this.deviceID = foundDeviceID;
        DebugLog.debug("localDeviceID", this.deviceID);
        this.deviceDescriptor = this.nativeOpenDevice(this.deviceID);
        this.localDeviceBTAddress = this.getLocalDeviceBluetoothAddressImpl(this.deviceDescriptor);
        this.propertiesMap = new Hashtable();
        String TRUE = "true";
        String FALSE = "false";
        this.propertiesMap.put("bluetooth.connected.devices.max", "7");
        this.propertiesMap.put("bluetooth.sd.trans.max", "7");
        this.propertiesMap.put("bluetooth.connected.inquiry.scan", "true");
        this.propertiesMap.put("bluetooth.connected.page.scan", "true");
        this.propertiesMap.put("bluetooth.connected.inquiry", "true");
        this.propertiesMap.put("bluetooth.connected.page", "true");
        this.propertiesMap.put("bluetooth.sd.attr.retrievable.max", String.valueOf(256));
        this.propertiesMap.put("bluetooth.master.switch", "false");
        this.propertiesMap.put("bluetooth.l2cap.receiveMTU.max", String.valueOf(65535));
        this.propertiesMap.put("bluecove.deviceID", String.valueOf(this.deviceID));
        devicesUsed.addElement(new Long(this.deviceID));
    }

    private native void nativeCloseDevice(int var1);

    public void destroy() {
        if (this.sdpSesion != 0L) {
            try {
                long s = this.sdpSesion;
                this.sdpSesion = 0L;
                this.closeSDPSessionImpl(s, true);
            }
            catch (ServiceRegistrationException serviceRegistrationException) {
                // empty catch block
            }
        }
        this.nativeCloseDevice(this.deviceDescriptor);
        if (this.deviceID >= 0) {
            devicesUsed.removeElement(new Long(this.deviceID));
            this.deviceID = -1;
        }
    }

    public native void enableNativeDebug(Class var1, boolean var2);

    public boolean isCurrentThreadInterruptedCallback() {
        return UtilsJavaSE.isCurrentThreadInterrupted();
    }

    public int getFeatureSet() {
        return 3;
    }

    private native int[] getLocalDevicesID();

    private native long getLocalDeviceBluetoothAddressImpl(int var1) throws BluetoothStateException;

    public String getLocalDeviceBluetoothAddress() throws BluetoothStateException {
        return RemoteDeviceHelper.getBluetoothAddress(this.getLocalDeviceBluetoothAddressImpl(this.deviceDescriptor));
    }

    private native int nativeGetDeviceClass(int var1);

    public DeviceClass getLocalDeviceClass() {
        int record = this.nativeGetDeviceClass(this.deviceDescriptor);
        if (record == -16777216) {
            return null;
        }
        return new DeviceClass(record);
    }

    private native String nativeGetDeviceName(int var1);

    public String getLocalDeviceName() {
        return this.nativeGetDeviceName(this.deviceDescriptor);
    }

    public boolean isLocalDevicePowerOn() {
        return true;
    }

    public String getLocalDeviceProperty(String property) {
        if ("bluecove.local_devices_ids".equals(property)) {
            int[] ids = this.getLocalDevicesID();
            StringBuffer b = new StringBuffer();
            if (ids != null) {
                for (int i = 0; i < ids.length; ++i) {
                    if (i != 0) {
                        b.append(',');
                    }
                    b.append(String.valueOf(ids[i]));
                }
            }
            return b.toString();
        }
        if (property.startsWith("bluecove.nativeFunction:")) {
            String functionDescr = property.substring(property.indexOf(58) + 1, property.length());
            int paramIdx = functionDescr.indexOf(58);
            if (paramIdx == -1) {
                throw new RuntimeException("Invalid native function " + functionDescr + "; arguments expected");
            }
            String function = functionDescr.substring(0, paramIdx);
            long address = RemoteDeviceHelper.getAddress(functionDescr.substring(function.length() + 1, functionDescr.length()));
            if ("getRemoteDeviceVersionInfo".equals(function)) {
                return this.getRemoteDeviceVersionInfo(address);
            }
            if ("getRemoteDeviceRSSI".equals(function)) {
                return String.valueOf(this.getRemoteDeviceRSSI(address));
            }
            return null;
        }
        return (String)this.propertiesMap.get(property);
    }

    private native int nativeGetLocalDeviceDiscoverable(int var1);

    public int getLocalDeviceDiscoverable() {
        return this.nativeGetLocalDeviceDiscoverable(this.deviceDescriptor);
    }

    private native int nativeSetLocalDeviceDiscoverable(int var1, int var2);

    public boolean setLocalDeviceDiscoverable(int mode) throws BluetoothStateException {
        int curentMode = this.getLocalDeviceDiscoverable();
        if (curentMode == mode) {
            return true;
        }
        int error = this.nativeSetLocalDeviceDiscoverable(this.deviceDescriptor, mode);
        if (error != 0) {
            DebugLog.error("Unable to change discovery mode. It may be because you aren't root; " + error);
            return false;
        }
        return true;
    }

    public void setLocalDeviceServiceClasses(int classOfDevice) {
        throw new NotSupportedRuntimeException(this.getStackID());
    }

    public boolean authenticateRemoteDevice(long address) throws IOException {
        return false;
    }

    public boolean authenticateRemoteDevice(long address, String passkey) throws IOException {
        return false;
    }

    public void removeAuthenticationWithRemoteDevice(long address) throws IOException {
        throw new NotSupportedIOException(this.getStackID());
    }

    private native String getRemoteDeviceVersionInfoImpl(int var1, long var2);

    public String getRemoteDeviceVersionInfo(long address) {
        return this.getRemoteDeviceVersionInfoImpl(this.deviceDescriptor, address);
    }

    private native int getRemoteDeviceRSSIImpl(int var1, long var2);

    public int getRemoteDeviceRSSI(long address) {
        return this.getRemoteDeviceRSSIImpl(this.deviceDescriptor, address);
    }

    public RemoteDevice[] retrieveDevices(int option) {
        return null;
    }

    public Boolean isRemoteDeviceTrusted(long address) {
        return null;
    }

    public Boolean isRemoteDeviceAuthenticated(long address) {
        return null;
    }

    private native int runDeviceInquiryImpl(DeviceInquiryRunnable var1, DeviceInquiryThread var2, int var3, int var4, int var5, int var6, int var7, DiscoveryListener var8) throws BluetoothStateException;

    public boolean startInquiry(int accessCode, DiscoveryListener listener) throws BluetoothStateException {
        if (this.discoveryListener != null) {
            throw new BluetoothStateException("Another inquiry already running");
        }
        this.discoveryListener = listener;
        this.discoveredDevices = new Vector();
        this.deviceInquiryCanceled = false;
        DeviceInquiryRunnable inquiryRunnable = new DeviceInquiryRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int runDeviceInquiry(DeviceInquiryThread startedNotify, int accessCode, DiscoveryListener listener) throws BluetoothStateException {
                try {
                    int discType = BluetoothStackBlueZ.this.runDeviceInquiryImpl(this, startedNotify, BluetoothStackBlueZ.this.deviceID, BluetoothStackBlueZ.this.deviceDescriptor, accessCode, 8, 20, listener);
                    if (BluetoothStackBlueZ.this.deviceInquiryCanceled) {
                        int n = 5;
                        return n;
                    }
                    int n = discType;
                    return n;
                }
                finally {
                    BluetoothStackBlueZ.this.discoveryListener = null;
                    BluetoothStackBlueZ.this.discoveredDevices = null;
                }
            }

            public void deviceDiscoveredCallback(DiscoveryListener listener, long deviceAddr, int deviceClass, String deviceName, boolean paired) {
                RemoteDevice remoteDevice = RemoteDeviceHelper.createRemoteDevice(BluetoothStackBlueZ.this, deviceAddr, deviceName, paired);
                if (BluetoothStackBlueZ.this.deviceInquiryCanceled || BluetoothStackBlueZ.this.discoveryListener == null || BluetoothStackBlueZ.this.discoveredDevices == null || BluetoothStackBlueZ.this.discoveredDevices.contains(remoteDevice)) {
                    return;
                }
                BluetoothStackBlueZ.this.discoveredDevices.addElement(remoteDevice);
                DeviceClass cod = new DeviceClass(deviceClass);
                DebugLog.debug("deviceDiscoveredCallback address", remoteDevice.getBluetoothAddress());
                DebugLog.debug("deviceDiscoveredCallback deviceClass", cod);
                listener.deviceDiscovered(remoteDevice, cod);
            }
        };
        return DeviceInquiryThread.startInquiry(this, inquiryRunnable, accessCode, listener);
    }

    private native boolean deviceInquiryCancelImpl(int var1);

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (this.discoveryListener != null && this.discoveryListener == listener) {
            this.deviceInquiryCanceled = true;
            return this.deviceInquiryCancelImpl(this.deviceDescriptor);
        }
        return false;
    }

    private native String getRemoteDeviceFriendlyNameImpl(int var1, long var2) throws IOException;

    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        return this.getRemoteDeviceFriendlyNameImpl(this.deviceDescriptor, address);
    }

    private native int runSearchServicesImpl(SearchServicesThread var1, long var2, byte[][] var4, long var5) throws SearchServicesException;

    public int searchServices(int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        SearchServicesRunnable searchRunnable = new SearchServicesRunnable(){

            public int runSearchServices(SearchServicesThread sst, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
                sst.searchServicesStartedCallback();
                try {
                    byte[][] uuidValues = new byte[uuidSet.length][];
                    for (int i = 0; i < uuidSet.length; ++i) {
                        uuidValues[i] = Utils.UUIDToByteArray(uuidSet[i]);
                    }
                    int respCode = BluetoothStackBlueZ.this.runSearchServicesImpl(sst, BluetoothStackBlueZ.this.localDeviceBTAddress, uuidValues, RemoteDeviceHelper.getAddress(device));
                    if (respCode != 3 && sst.isTerminated()) {
                        return 2;
                    }
                    if (respCode == 1) {
                        Vector records = sst.getServicesRecords();
                        if (records.size() != 0) {
                            DebugLog.debug("SearchServices finished", sst.getTransID());
                            ServiceRecord[] servRecordArray = (ServiceRecord[])Utils.vector2toArray(records, new ServiceRecord[records.size()]);
                            listener.servicesDiscovered(sst.getTransID(), servRecordArray);
                        }
                        if (records.size() != 0) {
                            return 1;
                        }
                        return 4;
                    }
                    return respCode;
                }
                catch (SearchServicesDeviceNotReachableException e) {
                    return 6;
                }
                catch (SearchServicesTerminatedException e) {
                    return 2;
                }
                catch (SearchServicesException e) {
                    return 3;
                }
            }
        };
        return SearchServicesThread.startSearchServices(this, searchRunnable, attrSet, uuidSet, device, listener);
    }

    public boolean serviceDiscoveredCallback(SearchServicesThread sst, long sdpSession, long handle) {
        if (sst.isTerminated()) {
            return true;
        }
        ServiceRecordImpl servRecord = new ServiceRecordImpl(this, sst.getDevice(), handle);
        int[] attrIDs = sst.getAttrSet();
        long remoteDeviceAddress = RemoteDeviceHelper.getAddress(sst.getDevice());
        this.populateServiceRecordAttributeValuesImpl(this.localDeviceBTAddress, remoteDeviceAddress, sdpSession, handle, attrIDs, servRecord);
        sst.addServicesRecords(servRecord);
        return false;
    }

    public boolean cancelServiceSearch(int transID) {
        SearchServicesThread sst = SearchServicesThread.getServiceSearchThread(transID);
        if (sst != null) {
            return sst.setTerminated();
        }
        return false;
    }

    private native boolean populateServiceRecordAttributeValuesImpl(long var1, long var3, long var5, long var7, int[] var9, ServiceRecordImpl var10);

    public boolean populateServicesRecordAttributeValues(ServiceRecordImpl serviceRecord, int[] attrIDs) throws IOException {
        long remoteDeviceAddress = RemoteDeviceHelper.getAddress(serviceRecord.getHostDevice());
        return this.populateServiceRecordAttributeValuesImpl(this.localDeviceBTAddress, remoteDeviceAddress, 0L, serviceRecord.getHandle(), attrIDs, serviceRecord);
    }

    private native long openSDPSessionImpl() throws ServiceRegistrationException;

    private synchronized long getSDPSession() throws ServiceRegistrationException {
        if (this.sdpSesion == 0L) {
            this.sdpSesion = this.openSDPSessionImpl();
            DebugLog.debug("created SDPSession", this.sdpSesion);
        }
        return this.sdpSesion;
    }

    private native void closeSDPSessionImpl(long var1, boolean var3) throws ServiceRegistrationException;

    private native long registerSDPServiceImpl(long var1, long var3, byte[] var5) throws ServiceRegistrationException;

    private native void updateSDPServiceImpl(long var1, long var3, long var5, byte[] var7) throws ServiceRegistrationException;

    private native void unregisterSDPServiceImpl(long var1, long var3, long var5, byte[] var7) throws ServiceRegistrationException;

    private byte[] getSDPBinary(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        byte[] blob;
        try {
            blob = serviceRecord.toByteArray();
        }
        catch (IOException e) {
            throw new ServiceRegistrationException(e.toString());
        }
        return blob;
    }

    private synchronized void registerSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        long handle = this.registerSDPServiceImpl(this.getSDPSession(), this.localDeviceBTAddress, this.getSDPBinary(serviceRecord));
        serviceRecord.setHandle(handle);
        serviceRecord.populateAttributeValue(0, new DataElement(10, handle));
        ++this.registeredServicesCount;
    }

    private void updateSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        this.updateSDPServiceImpl(this.getSDPSession(), this.localDeviceBTAddress, serviceRecord.getHandle(), this.getSDPBinary(serviceRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unregisterSDPRecord(ServiceRecordImpl serviceRecord) throws ServiceRegistrationException {
        try {
            this.unregisterSDPServiceImpl(this.getSDPSession(), this.localDeviceBTAddress, serviceRecord.getHandle(), this.getSDPBinary(serviceRecord));
        }
        finally {
            --this.registeredServicesCount;
            if (this.registeredServicesCount <= 0) {
                this.registeredServicesCount = 0;
                DebugLog.debug("closeSDPSession", this.sdpSesion);
                long s = this.sdpSesion;
                this.sdpSesion = 0L;
                this.closeSDPSessionImpl(s, false);
            }
        }
    }

    private native long connectionRfOpenClientConnectionImpl(long var1, long var3, int var5, boolean var6, boolean var7, int var8) throws IOException;

    public long connectionRfOpenClientConnection(BluetoothConnectionParams params) throws IOException {
        return this.connectionRfOpenClientConnectionImpl(this.localDeviceBTAddress, params.address, params.channel, params.authenticate, params.encrypt, params.timeout);
    }

    public native void connectionRfCloseClientConnection(long var1) throws IOException;

    public native int rfGetSecurityOptImpl(long var1) throws IOException;

    public int rfGetSecurityOpt(long handle, int expected) throws IOException {
        return this.rfGetSecurityOptImpl(handle);
    }

    public boolean rfEncrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }

    private native long rfServerOpenImpl(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8) throws IOException;

    private native int rfServerGetChannelIDImpl(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rfServerOpen(BluetoothConnectionNotifierParams params, ServiceRecordImpl serviceRecord) throws IOException {
        long socket = this.rfServerOpenImpl(this.localDeviceBTAddress, params.authorize, params.authenticate, params.encrypt, params.master, params.timeouts, 4);
        boolean success = false;
        try {
            int channel = this.rfServerGetChannelIDImpl(socket);
            serviceRecord.populateRFCOMMAttributes(0L, channel, params.uuid, params.name, params.obex);
            this.registerSDPRecord(serviceRecord);
            success = true;
            long l = socket;
            return l;
        }
        finally {
            if (!success) {
                this.rfServerCloseImpl(socket, true);
            }
        }
    }

    private native void rfServerCloseImpl(long var1, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rfServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.unregisterSDPRecord(serviceRecord);
        }
        finally {
            this.rfServerCloseImpl(handle, false);
        }
    }

    public void rfServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.updateSDPRecord(serviceRecord);
    }

    public native long rfServerAcceptAndOpenRfServerConnection(long var1) throws IOException;

    public void connectionRfCloseServerConnection(long clientHandle) throws IOException {
        this.connectionRfCloseClientConnection(clientHandle);
    }

    public int connectionRfRead(long handle) throws IOException {
        byte[] data = new byte[1];
        int size = this.connectionRfRead(handle, data, 0, 1);
        if (size == -1) {
            return -1;
        }
        return 0xFF & data[0];
    }

    public native int connectionRfRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native int connectionRfReadAvailable(long var1) throws IOException;

    public native void connectionRfWrite(long var1, int var3) throws IOException;

    public native void connectionRfWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    public native void connectionRfFlush(long var1) throws IOException;

    public native long getConnectionRfRemoteAddress(long var1) throws IOException;

    private void validateMTU(int receiveMTU, int transmitMTU) {
        if (receiveMTU > 65535) {
            throw new IllegalArgumentException("invalid ReceiveMTU value " + receiveMTU);
        }
    }

    private native long l2OpenClientConnectionImpl(long var1, long var3, int var5, boolean var6, boolean var7, int var8, int var9, int var10) throws IOException;

    public long l2OpenClientConnection(BluetoothConnectionParams params, int receiveMTU, int transmitMTU) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        return this.l2OpenClientConnectionImpl(this.localDeviceBTAddress, params.address, params.channel, params.authenticate, params.encrypt, receiveMTU, transmitMTU, params.timeout);
    }

    public native void l2CloseClientConnection(long var1) throws IOException;

    private native long l2ServerOpenImpl(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, int var10, int var11) throws IOException;

    public native int l2ServerGetPSMImpl(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long l2ServerOpen(BluetoothConnectionNotifierParams params, int receiveMTU, int transmitMTU, ServiceRecordImpl serviceRecord) throws IOException {
        this.validateMTU(receiveMTU, transmitMTU);
        long socket = this.l2ServerOpenImpl(this.localDeviceBTAddress, params.authorize, params.authenticate, params.encrypt, params.master, params.timeouts, 4, receiveMTU, transmitMTU, params.bluecove_ext_psm);
        boolean success = false;
        try {
            int channel = this.l2ServerGetPSMImpl(socket);
            serviceRecord.populateL2CAPAttributes(0, channel, params.uuid, params.name);
            this.registerSDPRecord(serviceRecord);
            success = true;
            long l = socket;
            return l;
        }
        finally {
            if (!success) {
                this.l2ServerCloseImpl(socket, true);
            }
        }
    }

    public void l2ServerUpdateServiceRecord(long handle, ServiceRecordImpl serviceRecord, boolean acceptAndOpen) throws ServiceRegistrationException {
        this.updateSDPRecord(serviceRecord);
    }

    public native long l2ServerAcceptAndOpenServerConnection(long var1) throws IOException;

    public void l2CloseServerConnection(long handle) throws IOException {
        this.l2CloseClientConnection(handle);
    }

    private native void l2ServerCloseImpl(long var1, boolean var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l2ServerClose(long handle, ServiceRecordImpl serviceRecord) throws IOException {
        try {
            this.unregisterSDPRecord(serviceRecord);
        }
        finally {
            this.l2ServerCloseImpl(handle, false);
        }
    }

    public native boolean l2Ready(long var1) throws IOException;

    public native int l2Receive(long var1, byte[] var3) throws IOException;

    public native void l2Send(long var1, byte[] var3) throws IOException;

    public native int l2GetReceiveMTU(long var1) throws IOException;

    public native int l2GetTransmitMTU(long var1) throws IOException;

    public native long l2RemoteAddress(long var1) throws IOException;

    public native int l2GetSecurityOpt(long var1, int var3) throws IOException;

    public boolean l2Encrypt(long address, long handle, boolean on) throws IOException {
        return false;
    }
}

