
///////////////////////////////////////////////////////////////////////////////
// Some font management functions to enable better user experiences for a range
// of devices with different resolutions

function setDefaultFontSizeForScreenSize(){
	// no preference available, check screen size
	if (window.innerWidth > 400 || window.innerHeight > 400) {
		// hi res screen, use large font
		setLargeView();
	}
	else {
		// lo res screen, use small font
		setSmallView();
	}
}

function setLargeView(){
//	document.getElementById('stylesheet').href = 'WRTKit/Resources/UI-large.css';
	setCssBodyFontSize(22);
}

function setSmallView(){
//	document.getElementById('stylesheet').href = 'WRTKit/Resources/UI.css';
	setCssBodyFontSize(14);
}

function increaseFontSize(){
    if (window.widget) {
		setCssBodyFontSize(currentFontSize + 2);
	}
}

function decreaseFontSize(){
    if (window.widget) {
		if (currentFontSize > 4) {
			setCssBodyFontSize(currentFontSize - 2);
		}
	}
}

function setCssBodyFontSize(size){
	if (window.widget) {
		currentFontSize = size;
		var sizestring = "" + size;
		document.body.style.fontSize = sizestring + "px";
		widget.setPreferenceForKey(sizestring, "fontsize");
	}
}
