package org.symbian.tools.wrttools.wizards;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension2;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

@SuppressWarnings("restriction")
public class WrtLibraryWizardPage extends NewElementWizardPage implements IJsGlobalScopeContainerPage,
        IJsGlobalScopeContainerPageExtension, IJsGlobalScopeContainerPageExtension2 {

    public static final String CONTAINER_ID = "org.symbian.wrt";

    public WrtLibraryWizardPage() {
        super("WrtLib");
        setTitle("WebRuntime Toolkit JavaScript Library");
    }

    public boolean finish() {
        return true;
    }

    public IIncludePathEntry getSelection() {
        System.out.println("Unimplemented method:BaseLibraryWizardPage.getSelection");
        return null;
    }

    public void setSelection(IIncludePathEntry containerEntry) {
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setFont(parent.getFont());
        DialogField field = new DialogField();

        field.setLabelText("Symbian WebRuntime Toolkit support was added to your project");
        LayoutUtil.doDefaultLayout(composite, new DialogField[] { field }, false, SWT.DEFAULT, SWT.DEFAULT);
        Dialog.applyDialogFont(composite);
        setControl(composite);
        setDescription("Symbian WebRuntime Toolkit Support");
    }

    public void initialize(IJavaScriptProject project, IIncludePathEntry[] currentEntries) {
        // nothing to initialize
    }

    public IIncludePathEntry[] getNewContainers() {
        IIncludePathEntry library = JavaScriptCore.newContainerEntry(new Path(CONTAINER_ID));
        return new IIncludePathEntry[] { library };
    }

}
