/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.RS;

class Stmt
extends RS
implements Statement,
Codes {
    private ArrayList batch = null;

    Stmt(Conn conn) {
        super(conn);
    }

    protected boolean exec() throws SQLException {
        if (this.pointer == 0L) {
            throw new SQLException("SQLite JDBC internal error: pointer == 0 on exec.");
        }
        if (this.isRS()) {
            throw new SQLException("SQLite JDBC internal error: isRS() on exec.");
        }
        this.resultsWaiting = false;
        int n = this.db.step(this.pointer);
        if (n == 1) {
            n = this.db.reset(this.pointer);
        }
        switch (n) {
            case 101: {
                this.db.reset(this.pointer);
                break;
            }
            case 100: {
                this.resultsWaiting = true;
                break;
            }
            case 5: {
                throw new SQLException("database locked");
            }
            case 21: {
                throw new SQLException("JDBC internal consistency error");
            }
            default: {
                int n2 = this.db.finalize(this.pointer);
                this.pointer = 0L;
                throw this.db.ex();
            }
        }
        return this.db.column_count(this.pointer) != 0;
    }

    public Statement getStatement() {
        return this;
    }

    public void close() throws SQLException {
        if (this.pointer == 0L) {
            return;
        }
        this.clearRS();
        this.colsMeta = null;
        this.meta = null;
        this.batch = null;
        int n = this.db.finalize(this.pointer);
        this.pointer = 0L;
        if (n != 0 && n != 21) {
            throw this.db.ex();
        }
    }

    protected void finalize() throws SQLException {
        this.close();
        if (this.conn != null) {
            this.conn.remove(this);
        }
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.pointer == 0L || this.resultsWaiting) {
            return -1;
        }
        return this.db.changes();
    }

    public boolean execute(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.pointer = this.db.prepare(string);
        return this.exec();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.pointer = this.db.prepare(string);
        if (!this.exec()) {
            this.close();
            throw new SQLException("query does not return ResultSet");
        }
        return this.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        this.checkOpen();
        this.close();
        this.pointer = this.db.prepare(string);
        int n = 0;
        try {
            n = this.db.executeUpdate(this.pointer, null);
        }
        finally {
            this.close();
        }
        return n;
    }

    public void addBatch(String string) throws SQLException {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new ArrayList();
        }
        this.batch.add(string);
    }

    public void clearBatch() throws SQLException {
        this.checkOpen();
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.close();
        if (this.batch == null) {
            return new int[0];
        }
        ArrayList arrayList = this.batch;
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            this.pointer = this.db.prepare((String)arrayList.get(i));
            try {
                nArray[i] = this.db.executeUpdate(this.pointer, null);
                continue;
            }
            catch (SQLException sQLException) {
                throw new BatchUpdateException("batch entry " + i + ": " + sQLException.getMessage(), nArray);
            }
            finally {
                this.close();
            }
        }
        return nArray;
    }
}

