/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.lang.ref.WeakReference;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sqlite.DB;
import org.sqlite.MetaData;
import org.sqlite.PrepStmt;
import org.sqlite.RS;
import org.sqlite.Stmt;

class Conn
implements Connection {
    private final String url;
    private DB db = new DB();
    private Set stmts = Collections.synchronizedSet(new HashSet());
    private MetaData meta = null;
    private boolean autoCommit = true;
    private int timeout = 0;

    public Conn(String string, String string2) throws SQLException {
        this.url = string;
        this.db.open(string2);
        this.setTimeout(3000);
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int n) {
        this.timeout = n;
        this.db.busy_timeout(n);
    }

    String url() {
        return this.url;
    }

    String libversion() {
        return this.db.libversion();
    }

    DB db() {
        return this.db;
    }

    private void checkOpen() throws SQLException {
        if (this.db == null) {
            throw new SQLException("database connection closed");
        }
    }

    private void checkCursor(int n, int n2, int n3) throws SQLException {
        if (n != 1003) {
            throw new SQLException("SQLite only supports TYPE_FORWARD_ONLY cursors");
        }
        if (n2 != 1007) {
            throw new SQLException("SQLite only supports CONCUR_READ_ONLY cursors");
        }
        if (n3 != 2) {
            throw new SQLException("SQLite only supports closing cursors at commit");
        }
    }

    void remove(RS rS) throws SQLException {
        this.removePointer(rS);
        this.stmts.remove(rS);
    }

    private void removePointer(RS rS) throws SQLException {
        if (rS == null) {
            return;
        }
        rS.close();
        if (rS.pointer != 0L) {
            this.db.finalize(rS.pointer);
            rS.pointer = 0L;
        }
        rS.db = null;
    }

    public void finalize() throws SQLException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.db == null) {
            return;
        }
        if (this.meta != null) {
            this.meta.close();
        }
        this.db.free_functions();
        DB dB = this.db;
        synchronized (dB) {
            Set set = this.stmts;
            synchronized (set) {
                Iterator iterator = this.stmts.iterator();
                while (iterator.hasNext()) {
                    RS rS = (RS)((WeakReference)iterator.next()).get();
                    this.removePointer(rS);
                    iterator.remove();
                }
                this.db.close();
                this.db = null;
            }
        }
    }

    public boolean isClosed() throws SQLException {
        return this.db == null;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        if (n != 2) {
            throw new SQLException("SQLite only supports CLOSE_CURSORS_AT_COMMIT");
        }
    }

    public int getTransactionIsolation() {
        return 8;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 8) {
            throw new SQLException("SQLite supports only TRANSACTION_SERIALIZABLE");
        }
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public DatabaseMetaData getMetaData() {
        if (this.meta == null) {
            this.meta = new MetaData(this);
        }
        return this.meta;
    }

    public String nativeSQL(String string) {
        return string;
    }

    public void clearWarnings() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        if (this.autoCommit == bl) {
            return;
        }
        this.autoCommit = bl;
        this.db.exec(this.autoCommit ? "COMMIT;" : "BEGIN DEFERRED;");
    }

    public void commit() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("COMMIT;");
        this.db.exec("BEGIN DEFERRED;");
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.autoCommit) {
            throw new SQLException("database in auto-commit mode");
        }
        this.db.exec("ROLLBACK;");
        this.db.exec("BEGIN DEFERRED;");
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkCursor(n, n2, n3);
        Stmt stmt = new Stmt(this);
        this.stmts.add(new WeakReference<Stmt>(stmt));
        return stmt;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, 2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException("SQLite does not support Stored Procedures");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("NYI");
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, 2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkCursor(n, n2, n3);
        PrepStmt prepStmt = new PrepStmt(this, string);
        this.stmts.add(new WeakReference<PrepStmt>(prepStmt));
        return prepStmt;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("unsupported by SQLite: savepoints");
    }
}

