/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    static final long serialVersionUID = 2762574228534679611L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private static Hashtable exclusionList = null;
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private static final Class ContextClass = class$org$mozilla$javascript$Context == null ? (class$org$mozilla$javascript$Context = ScriptableObject.class$("org.mozilla.javascript.Context")) : class$org$mozilla$javascript$Context;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$FunctionObject;
    static /* synthetic */ Class class$org$mozilla$javascript$ScriptableObject;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;

    public abstract String getClassName();

    public boolean has(String name, Scriptable start) {
        Slot slot = this.lastAccess;
        if (name != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.getSlot(name, name.hashCode());
            if (slot == null) {
                return false;
            }
            slot.stringKey = name;
            this.lastAccess = slot;
        }
        return true;
    }

    public boolean has(int index, Scriptable start) {
        return this.getSlot(null, index) != null;
    }

    public Object get(String name, Scriptable start) {
        Slot slot = this.lastAccess;
        if (name != slot.stringKey || slot.wasDeleted != 0) {
            slot = this.getSlot(name, name.hashCode());
            if (slot == null) {
                return Scriptable.NOT_FOUND;
            }
            slot.stringKey = name;
            this.lastAccess = slot;
        }
        if ((slot.flags & 1) != 0) {
            return this.getByGetter((GetterSlot)slot, start);
        }
        return slot.value;
    }

    private Object getByGetter(GetterSlot slot, Scriptable start) {
        try {
            if (slot.delegateTo == null) {
                Class<?> clazz = slot.getter.getDeclaringClass();
                while (!clazz.isInstance(start)) {
                    if ((start = start.getPrototype()) != null) continue;
                    start = this;
                    break;
                }
                return slot.getter.invoke((Object)start, ScriptRuntime.emptyArgs);
            }
            Object[] args = new Object[]{this};
            return slot.getter.invoke(slot.delegateTo, args);
        }
        catch (InvocationTargetException e) {
            throw WrappedException.wrapException(e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
    }

    public Object get(int index, Scriptable start) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String name, Scriptable start, Object value) {
        int hash;
        Slot slot = this.lastAccess;
        if ((name != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(name, hash = name.hashCode())) == null) {
            if (start != this) {
                start.put(name, start, value);
                return;
            }
            slot = this.getSlotToSet(name, hash);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            this.setBySetter((GetterSlot)slot, start, value);
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(name, start, value);
        }
    }

    private void setBySetter(GetterSlot slot, Scriptable start, Object value) {
        Object setterResult;
        Object[] args;
        Object setterThis;
        Context cx = Context.getContext();
        Class<?>[] pTypes = slot.setter.getParameterTypes();
        Class<?> desired = pTypes[pTypes.length - 1];
        Object actualArg = FunctionObject.convertArg(cx, start, value, desired);
        if (slot.delegateTo == null) {
            Class<?> clazz = slot.setter.getDeclaringClass();
            while (!clazz.isInstance(start)) {
                if ((start = start.getPrototype()) != null) continue;
                start = this;
                break;
            }
            setterThis = start;
            args = new Object[]{actualArg};
        } else {
            setterThis = slot.delegateTo;
            args = new Object[]{this, actualArg};
        }
        try {
            setterResult = slot.setter.invoke(setterThis, args);
        }
        catch (InvocationTargetException e) {
            throw WrappedException.wrapException(e);
        }
        catch (IllegalAccessException e) {
            throw WrappedException.wrapException(e);
        }
        if (slot.setterReturnsValue) {
            Slot replacement = new Slot();
            replacement.intKey = slot.intKey;
            replacement.stringKey = slot.stringKey;
            replacement.attributes = slot.attributes;
            replacement.value = setterResult;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int i = ScriptableObject.getSlotPosition(this.slots, slot.stringKey, slot.intKey);
                if (i >= 0 && this.slots[i] == slot) {
                    this.slots[i] = replacement;
                }
            }
        }
    }

    public void put(int index, Scriptable start, Object value) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            if (start != this) {
                start.put(index, start, value);
                return;
            }
            slot = this.getSlotToSet(null, index);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(index, start, value);
        }
    }

    public void delete(String name) {
        this.removeSlot(name, name.hashCode());
    }

    public void delete(int index) {
        this.removeSlot(null, index);
    }

    public int getAttributes(String name, Scriptable start) throws PropertyException {
        Slot slot = this.getSlot(name, name.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public int getAttributes(int index, Scriptable start) throws PropertyException {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        return slot.attributes;
    }

    public void setAttributes(String name, Scriptable start, int attributes) throws PropertyException {
        int mask = 7;
        attributes &= 7;
        Slot slot = this.getSlot(name, name.hashCode());
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)attributes;
    }

    public void setAttributes(int index, Scriptable start, int attributes) throws PropertyException {
        int mask = 7;
        attributes &= 7;
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw PropertyException.withMessage0("msg.prop.not.found");
        }
        slot.attributes = (short)attributes;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class typeHint) {
        Context cx = null;
        try {
            int i = 0;
            while (i < 2) {
                block23: {
                    Object u;
                    Object val;
                    block24: {
                        String hint;
                        block22: {
                            boolean bl = typeHint == ScriptRuntime.StringClass ? i == 0 : i == 1;
                            if (!bl) break block22;
                            Object v = ScriptableObject.getProperty((Scriptable)this, "toString");
                            if (!(v instanceof Function)) break block23;
                            Function fun = (Function)v;
                            if (cx == null) {
                                cx = Context.getContext();
                            }
                            val = fun.call(cx, fun.getParentScope(), this, ScriptRuntime.emptyArgs);
                            break block24;
                        }
                        if (typeHint == null) {
                            hint = "undefined";
                        } else if (typeHint == ScriptRuntime.StringClass) {
                            hint = "string";
                        } else if (typeHint == ScriptRuntime.ScriptableClass) {
                            hint = "object";
                        } else if (typeHint == ScriptRuntime.FunctionClass) {
                            hint = "function";
                        } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                            hint = "boolean";
                        } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                            hint = "number";
                        } else {
                            throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                        }
                        Object v = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                        if (!(v instanceof Function)) break block23;
                        Function fun = (Function)v;
                        Object[] args = new Object[]{hint};
                        if (cx == null) {
                            cx = Context.getContext();
                        }
                        val = fun.call(cx, fun.getParentScope(), this, args);
                    }
                    if (!(val == null || val != Undefined.instance && val instanceof Scriptable && typeHint != (class$org$mozilla$javascript$Scriptable == null ? ScriptableObject.class$("org.mozilla.javascript.Scriptable") : class$org$mozilla$javascript$Scriptable) && typeHint != (class$org$mozilla$javascript$Function == null ? ScriptableObject.class$("org.mozilla.javascript.Function") : class$org$mozilla$javascript$Function))) {
                        return val;
                    }
                    if (val instanceof NativeJavaObject && (u = ((Wrapper)val).unwrap()) instanceof String) {
                        return u;
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptException jse) {
            // empty catch block
        }
        String arg = typeHint == null ? "undefined" : typeHint.toString();
        throw NativeGlobal.typeError1("msg.default.value", arg, this);
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public static void defineClass(Scriptable scope, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scope, clazz, false);
    }

    public static void defineClass(Scriptable scope, Class clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        FunctionObject ctor;
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("init")) {
                Class<?>[] parmTypes = method.getParameterTypes();
                if (parmTypes.length == 3 && parmTypes[0] == ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                    method.invoke(null, args);
                    return;
                }
                if (parmTypes.length == 1 && parmTypes[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{scope};
                    method.invoke(null, args);
                    return;
                }
            }
            ++i;
        }
        Hashtable exclusionList = ScriptableObject.getExclusionList();
        Constructor<?>[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        int i2 = 0;
        while (i2 < ctors.length) {
            if (ctors[i2].getParameterTypes().length == 0) {
                protoCtor = ctors[i2];
                break;
            }
            ++i2;
        }
        if (protoCtor == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        proto.setPrototype(ScriptableObject.getObjectPrototype(scope));
        String className = proto.getClassName();
        String genericPrefix = "js_";
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String propertyPrefix = "jsProperty_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        boolean hasPrefix = false;
        Method[] ctorMeths = FunctionObject.findMethods(clazz, "jsConstructor");
        Executable ctorMember = null;
        if (ctorMeths != null) {
            if (ctorMeths.length > 1) {
                throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", ctorMeths[0], ctorMeths[1]));
            }
            ctorMember = ctorMeths[0];
            hasPrefix = true;
        }
        int i3 = 0;
        while (i3 < methods.length) {
            String name = methods[i3].getName();
            String prefix = null;
            if (!name.startsWith("js")) {
                prefix = null;
            } else if (name.startsWith("js_")) {
                prefix = "js_";
            } else if (name.startsWith("jsFunction_")) {
                prefix = "jsFunction_";
            } else if (name.startsWith("jsStaticFunction_")) {
                prefix = "jsStaticFunction_";
            } else if (name.startsWith("jsProperty_")) {
                prefix = "jsProperty_";
            } else if (name.startsWith("jsGet_")) {
                prefix = "jsGet_";
            } else if (name.startsWith("jsSet_")) {
                prefix = "jsSet_";
            }
            if (prefix != null) {
                hasPrefix = true;
                name = name.substring(prefix.length());
            }
            if (name.equals(className)) {
                if (ctorMember != null) {
                    throw new ClassDefinitionException(Context.getMessage2("msg.multiple.ctors", ctorMember, methods[i3]));
                }
                ctorMember = methods[i3];
            }
            ++i3;
        }
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (ctors[0].getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (ctors[1].getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if ((ctor = new FunctionObject(className, ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.addAsConstructor(scope, proto);
        if (!hasPrefix && exclusionList == null) {
            exclusionList = ScriptableObject.getExclusionList();
        }
        Method finishInit = null;
        int i4 = 0;
        while (i4 < methods.length) {
            block58: {
                String prefix;
                String name;
                block67: {
                    block60: {
                        block62: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block61: {
                                                block59: {
                                                    Class<?>[] parmTypes;
                                                    if (!hasPrefix && methods[i4].getDeclaringClass() != clazz) break block58;
                                                    name = methods[i4].getName();
                                                    if (!name.equals("finishInit") || (parmTypes = methods[i4].getParameterTypes()).length != 3 || parmTypes[0] != ScriptRuntime.ScriptableClass || parmTypes[1] != (class$org$mozilla$javascript$FunctionObject == null ? ScriptableObject.class$("org.mozilla.javascript.FunctionObject") : class$org$mozilla$javascript$FunctionObject) || parmTypes[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methods[i4].getModifiers())) break block59;
                                                    finishInit = methods[i4];
                                                    break block58;
                                                }
                                                if (name.indexOf(36) != -1 || name.equals("jsConstructor")) break block58;
                                                prefix = null;
                                                if (!hasPrefix) break block60;
                                                if (!name.startsWith("js_")) break block61;
                                                prefix = "js_";
                                                break block62;
                                            }
                                            if (!name.startsWith("jsFunction_")) break block63;
                                            prefix = "jsFunction_";
                                            break block62;
                                        }
                                        if (!name.startsWith("jsStaticFunction_")) break block64;
                                        prefix = "jsStaticFunction_";
                                        if (!Modifier.isStatic(methods[i4].getModifiers())) {
                                            throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                                        }
                                        break block62;
                                    }
                                    if (!name.startsWith("jsProperty_")) break block65;
                                    prefix = "jsProperty_";
                                    break block62;
                                }
                                if (!name.startsWith("jsGet_")) break block66;
                                prefix = "jsGet_";
                                break block62;
                            }
                            if (!name.startsWith("jsSet_")) break block58;
                            prefix = "jsSet_";
                        }
                        name = name.substring(prefix.length());
                        break block67;
                    }
                    if (exclusionList.get(name) != null) break block58;
                }
                if (!(methods[i4] == ctorMember || prefix != null && prefix.equals("jsSet_"))) {
                    if (prefix != null && prefix.equals("jsGet_")) {
                        if (!(proto instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", proto.getClass().toString(), name);
                        }
                        Method[] setter = FunctionObject.findMethods(clazz, "jsSet_" + name);
                        if (setter != null && setter.length != 1) {
                            throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
                        }
                        int attr = 6 | (setter != null ? 0 : 1);
                        Method m = setter == null ? null : setter[0];
                        ((ScriptableObject)proto).defineProperty(name, null, methods[i4], m, attr);
                    } else if (!(!name.startsWith("get") && !name.startsWith("set") || name.length() <= 3 || hasPrefix && (prefix.equals("jsFunction_") || prefix.equals("jsStaticFunction_")))) {
                        if (!(proto instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", proto.getClass().toString(), name);
                        }
                        if (!name.startsWith("set")) {
                            StringBuffer buf = new StringBuffer();
                            char c = name.charAt(3);
                            buf.append(Character.toLowerCase(c));
                            if (name.length() > 4) {
                                buf.append(name.substring(4));
                            }
                            String propertyName = buf.toString();
                            buf.setCharAt(0, c);
                            buf.insert(0, "set");
                            String setterName = buf.toString();
                            Method[] setter = FunctionObject.findMethods(clazz, hasPrefix ? "js_" + setterName : setterName);
                            if (setter != null && setter.length != 1) {
                                throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
                            }
                            if (setter == null && hasPrefix) {
                                setter = FunctionObject.findMethods(clazz, "jsProperty_" + setterName);
                            }
                            int attr = 6 | (setter != null ? 0 : 1);
                            Method m = setter == null ? null : setter[0];
                            ((ScriptableObject)proto).defineProperty(propertyName, null, methods[i4], m, attr);
                        }
                    } else {
                        FunctionObject f = new FunctionObject(name, methods[i4], proto);
                        if (f.isVarArgsConstructor()) {
                            throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
                        }
                        Scriptable dest = prefix == "jsStaticFunction_" ? ctor : proto;
                        ScriptableObject.defineProperty(dest, name, f, 2);
                        if (sealed) {
                            f.sealObject();
                            f.addPropertyAttribute(1);
                        }
                    }
                }
            }
            ++i4;
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            ctor.addPropertyAttribute(1);
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
                ((ScriptableObject)proto).addPropertyAttribute(1);
            }
        }
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.put(propertyName, (Scriptable)this, value);
        try {
            this.setAttributes(propertyName, (Scriptable)this, attributes);
        }
        catch (PropertyException e) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        ScriptableObject obj;
        try {
            obj = (ScriptableObject)destination;
        }
        catch (ClassCastException e) {
            destination.put(propertyName, destination, value);
            return;
        }
        obj.defineProperty(propertyName, value, attributes);
    }

    public void defineProperty(String propertyName, Class clazz, int attributes) throws PropertyException {
        StringBuffer buf = new StringBuffer(propertyName);
        buf.setCharAt(0, Character.toUpperCase(propertyName.charAt(0)));
        String s = buf.toString();
        Method[] getter = FunctionObject.findMethods(clazz, "get" + s);
        Method[] setter = FunctionObject.findMethods(clazz, "set" + s);
        if (setter == null) {
            attributes |= 1;
        }
        if (getter.length != 1 || setter != null && setter.length != 1) {
            throw PropertyException.withMessage2("msg.no.overload", propertyName, clazz.getName());
        }
        this.defineProperty(propertyName, null, getter[0], setter == null ? null : setter[0], attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) throws PropertyException {
        Class<?>[] parmTypes;
        int flags = 1;
        if (delegateTo == null && Modifier.isStatic(getter.getModifiers())) {
            delegateTo = HAS_STATIC_ACCESSORS;
        }
        if ((parmTypes = getter.getParameterTypes()).length != 0) {
            if (parmTypes.length != 1 || parmTypes[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", getter.toString());
            }
        } else if (delegateTo != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", getter.toString());
        }
        if (setter != null) {
            flags |= 2;
            if (delegateTo == HAS_STATIC_ACCESSORS != Modifier.isStatic(setter.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 2) {
                if (parmTypes[0] != (class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject)) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (delegateTo == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", setter.toString());
                }
            } else if (parmTypes.length == 1) {
                if (delegateTo != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", setter.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
        }
        GetterSlot slot = new GetterSlot();
        slot.delegateTo = delegateTo;
        slot.getter = getter;
        slot.setter = setter;
        slot.setterReturnsValue = setter != null && setter.getReturnType() != Void.TYPE;
        slot.value = null;
        slot.attributes = (short)attributes;
        slot.flags = (byte)flags;
        Slot inserted = this.addSlot(propertyName, propertyName.hashCode(), slot);
        if (inserted != slot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] names, Class clazz, int attributes) throws PropertyException {
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Method[] m = FunctionObject.findMethods(clazz, name);
            if (m == null) {
                throw PropertyException.withMessage2("msg.method.not.found", name, clazz.getName());
            }
            if (m.length > 1) {
                throw PropertyException.withMessage2("msg.no.overload", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m[0], this);
            this.defineProperty(name, f, attributes);
            ++i;
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor == Scriptable.NOT_FOUND || !(ctor instanceof Scriptable)) {
            return null;
        }
        Scriptable ctorObj = (Scriptable)ctor;
        if (!ctorObj.has("prototype", ctorObj)) {
            return null;
        }
        Object proto = ctorObj.get("prototype", ctorObj);
        if (!(proto instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)proto;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable next = obj;
        while ((next = (obj = next).getParentScope()) != null) {
        }
        return obj;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return null != ScriptableObject.getBase(obj, name);
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return null != ScriptableObject.getBase(obj, index);
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        ObjToIntMap map = new ObjToIntMap();
        while (obj != null) {
            Object[] ids = obj.getIds();
            int i = 0;
            while (i < ids.length) {
                map.put(ids[i], 0);
                ++i;
            }
            obj = obj.getPrototype();
        }
        return map.getKeys();
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) throws JavaScriptException {
        Object object;
        Context cx = Context.enter();
        try {
            Object fun = ScriptableObject.getProperty(obj, methodName);
            if (fun == Scriptable.NOT_FOUND) {
                fun = methodName;
            }
            object = ScriptRuntime.call(cx, fun, obj, args, ScriptableObject.getTopLevelScope(obj));
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        Scriptable start = obj;
        while (!obj.has(name, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        Scriptable start = obj;
        while (!obj.has(index, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    synchronized void addPropertyAttribute(int attribute) {
        if (this.slots == null) {
            return;
        }
        int i = 0;
        while (i < this.slots.length) {
            Slot slot = this.slots[i];
            if (slot != null && slot != REMOVED) {
                slot.attributes = (short)(slot.attributes | attribute);
            }
            ++i;
        }
    }

    private Slot getSlot(String id, int index) {
        Slot[] slots = this.slots;
        int i = ScriptableObject.getSlotPosition(slots, id, index);
        return i < 0 ? null : slots[i];
    }

    private static int getSlotPosition(Slot[] slots, String id, int index) {
        if (slots != null) {
            Slot slot;
            int start;
            int i = start = (index & Integer.MAX_VALUE) % slots.length;
            while ((slot = slots[i]) != null) {
                if (slot != REMOVED && slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                    return i;
                }
                if (++i == slots.length) {
                    i = 0;
                }
                if (i != start) continue;
            }
        }
        return -1;
    }

    private Slot getSlotToSet(String id, int index) {
        Slot[] array = this.slots;
        if (array == null) {
            return this.addSlot(id, index, null);
        }
        int start = (index & Integer.MAX_VALUE) % array.length;
        boolean sawRemoved = false;
        int i = start;
        do {
            Slot slot;
            if ((slot = array[i]) == null) {
                return this.addSlot(id, index, null);
            }
            if (slot == REMOVED) {
                sawRemoved = true;
            } else if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != array.length) continue;
            i = 0;
        } while (i != start);
        if (!sawRemoved) {
            Context.codeBug();
        }
        return this.addSlot(id, index, null);
    }

    private synchronized Slot addSlot(String id, int index, Slot newSlot) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.add.sealed");
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(id, index, newSlot);
    }

    private Slot addSlotImpl(String id, int index, Slot newSlot) {
        int start;
        int i = start = (index & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[i]) == null || slot == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(id, index, newSlot);
                }
                slot = newSlot == null ? new Slot() : newSlot;
                slot.stringKey = id;
                slot.intKey = index;
                this.slots[i] = slot;
                ++this.count;
                return slot;
            }
            if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != this.slots.length) continue;
            i = 0;
        } while (i != start);
        Context.codeBug();
        return null;
    }

    private synchronized void removeSlot(String name, int index) {
        if (this.count < 0) {
            throw Context.reportRuntimeError0("msg.remove.sealed");
        }
        int i = ScriptableObject.getSlotPosition(this.slots, name, index);
        if (i >= 0) {
            Slot slot = this.slots[i];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                this.slots[i] = REMOVED;
                --this.count;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
            }
        }
    }

    private void grow() {
        Slot[] newSlots = new Slot[this.slots.length * 2 + 1];
        int j = this.slots.length - 1;
        while (j >= 0) {
            Slot slot = this.slots[j];
            if (slot != null && slot != REMOVED) {
                int k = (slot.intKey & Integer.MAX_VALUE) % newSlots.length;
                while (newSlots[k] != null) {
                    if (++k != newSlots.length) continue;
                    k = 0;
                }
                newSlots[k] = slot;
            }
            --j;
        }
        this.slots = newSlots;
    }

    private static Hashtable getExclusionList() {
        if (exclusionList != null) {
            return exclusionList;
        }
        Hashtable<String, Boolean> result = new Hashtable<String, Boolean>(17);
        Method[] methods = ScriptRuntime.FunctionClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            result.put(methods[i].getName(), Boolean.TRUE);
            ++i;
        }
        exclusionList = result;
        return result;
    }

    Object[] getIds(boolean getAll) {
        Slot[] s = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s == null) {
            return a;
        }
        int c = 0;
        int i = 0;
        while (i < s.length) {
            Slot slot = s[i];
            if (slot != null && slot != REMOVED && (getAll || (slot.attributes & 2) == 0)) {
                if (c == 0) {
                    a = new Object[s.length - i];
                }
                a[c++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
            }
            ++i;
        }
        if (c == a.length) {
            return a;
        }
        Object[] result = new Object[c];
        System.arraycopy(a, 0, result, 0, c);
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Slot[] s;
        out.defaultWriteObject();
        int N = this.count;
        if (N < 0) {
            N = -1 - this.count;
        }
        if ((s = this.slots) == null) {
            if (N != 0) {
                Context.codeBug();
            }
            out.writeInt(0);
        } else {
            out.writeInt(s.length);
            int i = 0;
            while (N != 0) {
                Slot slot = s[i];
                if (slot != null && slot != REMOVED) {
                    --N;
                    out.writeObject(slot);
                }
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastAccess = REMOVED;
        int capacity = in.readInt();
        if (capacity != 0) {
            this.slots = new Slot[capacity];
            int N = this.count;
            boolean wasSealed = false;
            if (N < 0) {
                N = -1 - N;
                wasSealed = true;
            }
            this.count = 0;
            int i = 0;
            while (i != N) {
                Slot s = (Slot)in.readObject();
                this.addSlotImpl(s.stringKey, s.intKey, s);
                ++i;
            }
            if (wasSealed) {
                this.count = -1 - this.count;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GetterSlot
    extends Slot
    implements Serializable {
        Object delegateTo;
        transient Method getter;
        transient Method setter;
        boolean setterReturnsValue;

        GetterSlot() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            FunctionObject.writeMember(out, this.getter);
            FunctionObject.writeMember(out, this.setter);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.getter = (Method)FunctionObject.readMember(in);
            this.setter = (Method)FunctionObject.readMember(in);
        }
    }

    private static class Slot
    implements Serializable {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        static final long serialVersionUID = -2158009919774350004L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }
    }
}

