/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FOTreeBuilder;
import org.xml.sax.helpers.DefaultHandler;

public class Fop
implements Constants {
    private int renderType = 0;
    private OutputStream stream = null;
    private FOUserAgent foUserAgent = null;

    public Fop(int renderType, FOUserAgent ua) {
        if (renderType < 1 || renderType > 10) {
            throw new IllegalArgumentException("Invalid render type #" + renderType);
        }
        this.renderType = renderType;
        this.foUserAgent = ua;
        if (this.foUserAgent == null) {
            this.foUserAgent = new FOUserAgent();
        }
    }

    public Fop(int renderType) {
        this(renderType, new FOUserAgent());
    }

    public FOUserAgent getUserAgent() {
        return this.foUserAgent;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public DefaultHandler getDefaultHandler() throws FOPException {
        return new FOTreeBuilder(this.renderType, this.foUserAgent, this.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLineOptions options = null;
        FOUserAgent foUserAgent = null;
        FilterOutputStream bos = null;
        try {
            options = new CommandLineOptions();
            options.parse(args);
            foUserAgent = options.getFOUserAgent();
            Fop fop = new Fop(options.getRenderer(), foUserAgent);
            try {
                if (options.getOutputFile() != null) {
                    bos = new BufferedOutputStream(new FileOutputStream(options.getOutputFile()));
                    fop.setOutputStream(bos);
                }
                foUserAgent.getInputHandler().render(fop);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
            if (options.getOutputMode() != 2) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            if (options != null) {
                options.getLogger().error("Exception", e);
            }
            System.exit(1);
        }
    }

    public static String getVersion() {
        return "1.0dev";
    }
}

