/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGFeImageElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feImage";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        AffineTransform affineTransform;
        Rectangle2D rectangle2D2;
        String string = XLinkSupport.getXLinkHref((Element)element);
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"xlink:href"});
        }
        Document document = element.getOwnerDocument();
        boolean bl = string.indexOf("#") != -1;
        Element element3 = null;
        element3 = bl ? document.createElementNS("http://www.w3.org/2000/svg", "use") : document.createElementNS("http://www.w3.org/2000/svg", "image");
        element3.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", string);
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        element4.appendChild(element3);
        Rectangle2D rectangle2D3 = rectangle2D;
        AffineTransform affineTransform2 = new AffineTransform();
        Element element5 = (Element)element.getParentNode();
        boolean bl2 = false;
        String string2 = SVGUtilities.getChainableAttributeNS(element5, null, "primitiveUnits", bridgeContext);
        short s = string2.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element5, "primitiveUnits", string2);
        if (s == 2) {
            bl2 = true;
            affineTransform2 = SVGUtilities.toObjectBBox(affineTransform2, graphicsNode);
        }
        Rectangle2D rectangle2D4 = rectangle2D2 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D3, rectangle2D, bridgeContext);
        if (bl2) {
            try {
                affineTransform = affineTransform2.createInverse();
                rectangle2D4 = affineTransform.createTransformedShape(rectangle2D4).getBounds2D();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
        }
        element3.setAttributeNS(null, "x", "" + rectangle2D4.getX());
        element3.setAttributeNS(null, "y", "" + rectangle2D4.getY());
        element3.setAttributeNS(null, "width", "" + rectangle2D4.getWidth());
        element3.setAttributeNS(null, "height", "" + rectangle2D4.getHeight());
        affineTransform = bridgeContext.getGVTBuilder().build(bridgeContext, element4);
        Filter filter2 = affineTransform.getGraphicsNodeRable(true);
        filter2 = new AffineRable8Bit(filter2, affineTransform2);
        SVGFeImageElementBridge.handleColorInterpolationFilters(filter2, element);
        filter2 = new PadRable8Bit(filter2, rectangle2D2, PadMode.ZERO_PAD);
        SVGFeImageElementBridge.updateFilterMap(element, filter2, map);
        return filter2;
    }

    protected static Filter createSVGFeImage(BridgeContext bridgeContext, Rectangle2D rectangle2D, Element element, boolean bl, Element element2, GraphicsNode graphicsNode) {
        GraphicsNode graphicsNode2 = bridgeContext.getGVTBuilder().build(bridgeContext, element);
        Filter filter = graphicsNode2.getGraphicsNodeRable(true);
        AffineTransform affineTransform = new AffineTransform();
        if (bl) {
            Element element3 = (Element)element2.getParentNode();
            String string = SVGUtilities.getChainableAttributeNS(element3, null, "primitiveUnits", bridgeContext);
            short s = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element3, "primitiveUnits", string);
            if (s == 2) {
                affineTransform = SVGUtilities.toObjectBBox(affineTransform, graphicsNode);
            }
            Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(rectangle2D.getX() - rectangle2D2.getX(), rectangle2D.getY() - rectangle2D2.getY()));
        } else {
            affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        }
        return new AffineRable8Bit(filter, affineTransform);
    }

    protected static Filter createRasterFeImage(BridgeContext bridgeContext, Rectangle2D rectangle2D, ParsedURL parsedURL) {
        Filter filter = ImageTagRegistry.getRegistry().readURL(parsedURL);
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle2D.getX(), rectangle2D.getY());
        affineTransform.scale(rectangle2D.getWidth() / (rectangle2D2.getWidth() - 1.0), rectangle2D.getHeight() / (rectangle2D2.getHeight() - 1.0));
        affineTransform.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
        return new AffineRable8Bit(filter, affineTransform);
    }
}

