/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class IdFunction
extends BaseFunction {
    public static final int FUNCTION_ONLY = 0;
    public static final int CONSTRUCTOR_ONLY = 1;
    public static final int FUNCTION_AND_CONSTRUCTOR = 2;
    protected IdFunctionMaster master;
    protected int methodId;
    protected int functionType = 0;

    public IdFunction(IdFunctionMaster master, String name, int id) {
        this.functionName = name;
        this.master = master;
        this.methodId = id;
    }

    public final int functionType() {
        return this.functionType;
    }

    public void setFunctionType(int type) {
        this.functionType = type;
    }

    public Scriptable getPrototype() {
        Scriptable proto = super.getPrototype();
        if (proto == null) {
            proto = ScriptableObject.getFunctionPrototype(this.getParentScope());
            this.setPrototype(proto);
        }
        return proto;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        if (this.functionType != 1) {
            return this.master.execMethod(this.methodId, this, cx, scope, thisObj, args);
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        if (this.functionType != 0) {
            Scriptable result = (Scriptable)this.master.execMethod(this.methodId, this, cx, scope, null, args);
            this.postConstruction(result);
            return result;
        }
        return Undefined.instance;
    }

    public String decompile(Context cx, int indent, boolean justbody) {
        StringBuffer sb = new StringBuffer();
        if (!justbody) {
            sb.append("function ");
            sb.append(this.getFunctionName());
            sb.append("() { ");
        }
        sb.append("[native code for ");
        if (this.master instanceof Scriptable) {
            Scriptable smaster = (Scriptable)((Object)this.master);
            sb.append(smaster.getClassName());
            sb.append('.');
        }
        sb.append(this.getFunctionName());
        sb.append(", arity=");
        sb.append(this.getArity());
        sb.append(justbody ? "]\n" : "] }\n");
        return sb.toString();
    }

    public int getArity() {
        int arity = this.master.methodArity(this.methodId);
        if (arity < 0) {
            throw IdFunction.onBadMethodId(this.master, this.methodId);
        }
        return arity;
    }

    public int getLength() {
        return this.getArity();
    }

    public void initAsConstructor(Scriptable scope, Scriptable prototype) {
        this.setFunctionType(2);
        this.setParentScope(scope);
        this.setImmunePrototypeProperty(prototype);
    }

    static RuntimeException onBadMethodId(IdFunctionMaster master, int id) {
        return new RuntimeException("BAD FUNCTION ID=" + id + " MASTER=" + master);
    }

    private void postConstruction(Scriptable newObj) {
        Scriptable parent;
        if (newObj.getPrototype() == null) {
            newObj.setPrototype(this.getClassPrototype());
        }
        if (newObj.getParentScope() == null && newObj != (parent = this.getParentScope())) {
            newObj.setParentScope(parent);
        }
    }
}

