/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class VariableNode {
    Scriptable scope;
    String name;
    int index;
    Object[] children;
    static final Object[] empty = new Object[0];

    public VariableNode(Scriptable scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public VariableNode(Scriptable scope, int index) {
        this.scope = scope;
        this.name = null;
        this.index = index;
    }

    public String toString() {
        return this.name != null ? this.name : "[" + this.index + "]";
    }

    public Object getObject() {
        try {
            if (this.scope == null) {
                return null;
            }
            if (this.name != null) {
                if (this.name.equals("this")) {
                    return this.scope;
                }
                Object result = Scriptable.NOT_FOUND;
                if (this.name.equals("__proto__")) {
                    result = this.scope.getPrototype();
                } else if (this.name.equals("__parent__")) {
                    result = this.scope.getParentScope();
                } else {
                    try {
                        result = ScriptableObject.getProperty(this.scope, this.name);
                    }
                    catch (RuntimeException e) {
                        result = e.getMessage();
                    }
                }
                if (result == Scriptable.NOT_FOUND) {
                    result = Undefined.instance;
                }
                return result;
            }
            Object result = ScriptableObject.getProperty(this.scope, this.index);
            if (result == Scriptable.NOT_FOUND) {
                result = Undefined.instance;
            }
            return result;
        }
        catch (Exception exc) {
            return "undefined";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getChildren() {
        Object[] objectArray;
        block27: {
            Object[] objectArray2;
            block26: {
                if (this.children != null) {
                    return this.children;
                }
                Context cx = Context.enter();
                try {
                    block28: {
                        try {
                            int i;
                            Object value = this.getObject();
                            if (value == null) {
                                this.children = empty;
                                objectArray2 = empty;
                                Object var15_5 = null;
                                break block26;
                            }
                            if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
                                this.children = empty;
                                objectArray = empty;
                                break block27;
                            }
                            if (!(value instanceof Scriptable)) break block28;
                            Scriptable scrip = (Scriptable)value;
                            Scriptable proto = scrip.getPrototype();
                            Scriptable parent = scrip.getParentScope();
                            if (scrip.has(0, scrip)) {
                                int len = 0;
                                try {
                                    Scriptable start;
                                    Scriptable obj = start = scrip;
                                    Object result = Undefined.instance;
                                    while (!(obj.has("length", start) && (result = obj.get("length", start)) != Scriptable.NOT_FOUND || (obj = obj.getPrototype()) == null)) {
                                    }
                                    if (result instanceof Number) {
                                        len = ((Number)result).intValue();
                                    }
                                }
                                catch (Exception exc) {
                                    // empty catch block
                                }
                                if (parent != null) {
                                    ++len;
                                }
                                if (proto != null) {
                                    ++len;
                                }
                                this.children = new VariableNode[len];
                                int i2 = 0;
                                int j = 0;
                                if (parent != null) {
                                    this.children[i2++] = new VariableNode(scrip, "__parent__");
                                    ++j;
                                }
                                if (proto != null) {
                                    this.children[i2++] = new VariableNode(scrip, "__proto__");
                                    ++j;
                                }
                                while (i2 < len) {
                                    this.children[i2] = new VariableNode(scrip, i2 - j);
                                    ++i2;
                                }
                                break block28;
                            }
                            int len = 0;
                            Hashtable<Object, Object> t = new Hashtable<Object, Object>();
                            Object[] ids = scrip instanceof ScriptableObject ? ((ScriptableObject)scrip).getAllIds() : scrip.getIds();
                            if (ids == null) {
                                ids = empty;
                            }
                            if (proto != null) {
                                t.put("__proto__", "__proto__");
                            }
                            if (parent != null) {
                                t.put("__parent__", "__parent__");
                            }
                            if (ids.length > 0) {
                                int j = 0;
                                while (j < ids.length) {
                                    t.put(ids[j], ids[j]);
                                    ++j;
                                }
                            }
                            ids = new Object[t.size()];
                            Enumeration e = t.keys();
                            int j = 0;
                            while (true) {
                                if (!e.hasMoreElements()) {
                                    if (ids != null && ids.length > 0) {
                                        Arrays.sort(ids, new Comparator(){

                                            public int compare(Object l, Object r) {
                                                return l.toString().compareToIgnoreCase(r.toString());
                                            }
                                        });
                                        len = ids.length;
                                    }
                                    this.children = new VariableNode[len];
                                    i = 0;
                                    break;
                                }
                                ids[j++] = e.nextElement().toString();
                            }
                            while (i < len) {
                                Object id = ids[i];
                                this.children[i] = new VariableNode(scrip, id.toString());
                                ++i;
                            }
                        }
                        catch (Exception exc) {
                            exc.printStackTrace();
                            Object var15_8 = null;
                            Context.exit();
                            return this.children;
                        }
                    }
                    Object var15_7 = null;
                    Context.exit();
                    return this.children;
                }
                catch (Throwable throwable) {
                    Object var15_9 = null;
                    Context.exit();
                    throw throwable;
                }
            }
            Context.exit();
            return objectArray2;
        }
        Object var15_6 = null;
        Context.exit();
        return objectArray;
    }
}

