/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.fop.svg.FOPSAXSVGDocumentFactory;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.EntityResolver;

public abstract class AbstractFOPTranscoder
extends SVGAbstractTranscoder {
    public static final TranscodingHints.Key KEY_STROKE_TEXT = new BooleanKey();
    public static final Boolean VALUE_FORMAT_ON = Boolean.TRUE;
    public static final Boolean VALUE_FORMAT_OFF = Boolean.FALSE;
    protected UserAgent userAgent = this.createUserAgent();
    private Log logger;
    private EntityResolver resolver;

    public AbstractFOPTranscoder() {
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        this.hints.put((Object)KEY_DOCUMENT_ELEMENT, (Object)"svg");
        this.hints.put((Object)KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
    }

    protected UserAgent createUserAgent() {
        return new FOPTranscoderUserAgent();
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver = resolver;
    }

    protected final Log getLogger() {
        if (this.logger == null) {
            this.logger = new SimpleLog("FOP/Transcoder");
            ((SimpleLog)this.logger).setLevel(3);
        }
        return this.logger;
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        FOPSAXSVGDocumentFactory factory = new FOPSAXSVGDocumentFactory(parserClassname);
        if (this.resolver != null) {
            factory.setAdditionalEntityResolver(this.resolver);
        }
        return factory;
    }

    protected class FOPTranscoderUserAgent
    extends SVGAbstractTranscoder.SVGAbstractTranscoderUserAgent {
        protected FOPTranscoderUserAgent() {
            super((SVGAbstractTranscoder)AbstractFOPTranscoder.this);
        }

        public void displayError(String message) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception e) {
            try {
                AbstractFOPTranscoder.this.getErrorHandler().error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String message) {
            AbstractFOPTranscoder.this.getLogger().info(message);
        }

        public float getPixelUnitToMillimeter() {
            TranscodingHints.Key key = ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER;
            if (AbstractFOPTranscoder.this.getTranscodingHints().containsKey((Object)key)) {
                return ((Float)AbstractFOPTranscoder.this.getTranscodingHints().get((Object)key)).floatValue();
            }
            return 0.26458332f;
        }

        public String getMedia() {
            return "print";
        }
    }

    protected class FOPErrorHandler
    implements ErrorHandler {
        protected FOPErrorHandler() {
        }

        public void error(TranscoderException te) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().error(te.getMessage());
        }

        public void fatalError(TranscoderException te) throws TranscoderException {
            throw te;
        }

        public void warning(TranscoderException te) throws TranscoderException {
            AbstractFOPTranscoder.this.getLogger().warn(te.getMessage());
        }
    }
}

