/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.pdf.AbstractPDFStream;

public class PDFT1Stream
extends AbstractPDFStream {
    private PFBData pfb;

    protected int getSizeHint() throws IOException {
        if (this.pfb != null) {
            return this.pfb.getLength();
        }
        return 0;
    }

    protected int output(OutputStream stream) throws IOException {
        if (this.pfb == null) {
            throw new IllegalStateException("pfb must not be null at this point");
        }
        log.debug("Writing " + this.pfb.getLength() + " bytes of Type 1 font data");
        int length = super.output(stream);
        log.debug("Embedded Type1 font");
        return length;
    }

    protected String buildStreamDict(String lengthEntry) {
        String filterEntry = this.getFilterList().buildFilterDictEntries();
        return this.getObjectID() + "<< /Length " + lengthEntry + " /Length1 " + this.pfb.getLength1() + " /Length2 " + this.pfb.getLength2() + " /Length3 " + this.pfb.getLength3() + "\n" + filterEntry + "\n>>\n";
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.pfb.outputAllParts(out);
    }

    public void setData(PFBData pfb) throws IOException {
        this.pfb = pfb;
    }
}

