/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.g2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.ext.awt.g2d.TransformStackElement;

public class GraphicContext
implements Cloneable {
    protected AffineTransform defaultTransform = new AffineTransform();
    protected AffineTransform transform = new AffineTransform();
    protected Vector transformStack = new Vector();
    protected boolean transformStackValid = true;
    protected Paint paint = Color.black;
    protected Stroke stroke = new BasicStroke();
    protected Composite composite = AlphaComposite.SrcOver;
    protected Shape clip = null;
    protected RenderingHints hints = new RenderingHints(null);
    protected Font font = new Font("sanserif", 0, 12);
    protected Color background = new Color(0, 0, 0, 0);
    protected Color foreground = Color.black;

    public GraphicContext() {
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    }

    public GraphicContext(AffineTransform affineTransform) {
        this();
        this.defaultTransform = new AffineTransform(affineTransform);
        this.transform = new AffineTransform(this.defaultTransform);
        if (!this.defaultTransform.isIdentity()) {
            this.transformStack.addElement(TransformStackElement.createGeneralTransformElement(this.defaultTransform));
        }
    }

    public Object clone() {
        GraphicContext graphicContext = new GraphicContext(this.defaultTransform);
        graphicContext.transform = new AffineTransform(this.transform);
        graphicContext.transformStack = new Vector();
        for (int i = 0; i < this.transformStack.size(); ++i) {
            TransformStackElement transformStackElement = (TransformStackElement)this.transformStack.elementAt(i);
            graphicContext.transformStack.addElement(transformStackElement.clone());
        }
        graphicContext.transformStackValid = this.transformStackValid;
        graphicContext.paint = this.paint;
        graphicContext.stroke = this.stroke;
        graphicContext.composite = this.composite;
        graphicContext.clip = this.clip != null ? new GeneralPath(this.clip) : null;
        graphicContext.hints = (RenderingHints)this.hints.clone();
        graphicContext.font = this.font;
        graphicContext.background = this.background;
        graphicContext.foreground = this.foreground;
        return graphicContext;
    }

    public Color getColor() {
        return this.foreground;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.paint != color) {
            this.setPaint(color);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public Rectangle getClipBounds() {
        Shape shape = this.getClip();
        if (shape == null) {
            return null;
        }
        return shape.getBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setClip(Shape shape) {
        this.clip = shape != null ? this.transform.createTransformedShape(shape) : null;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.foreground = (Color)paint;
        }
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.hints = new RenderingHints(map);
    }

    public void addRenderingHints(Map map) {
        this.hints.putAll((Map<?, ?>)map);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void translate(int n, int n2) {
        if (n != 0 || n2 != 0) {
            this.transform.translate(n, n2);
            this.transformStack.addElement(TransformStackElement.createTranslateElement(n, n2));
        }
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        this.transformStack.addElement(TransformStackElement.createTranslateElement(d, d2));
    }

    public void rotate(double d) {
        this.transform.rotate(d);
        this.transformStack.addElement(TransformStackElement.createRotateElement(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
        this.transformStack.addElement(TransformStackElement.createTranslateElement(d2, d3));
        this.transformStack.addElement(TransformStackElement.createRotateElement(d));
        this.transformStack.addElement(TransformStackElement.createTranslateElement(-d2, -d3));
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        this.transformStack.addElement(TransformStackElement.createScaleElement(d, d2));
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
        this.transformStack.addElement(TransformStackElement.createShearElement(d, d2));
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.transformStack.addElement(TransformStackElement.createGeneralTransformElement(affineTransform));
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = new AffineTransform(affineTransform);
        this.invalidateTransformStack();
        if (!affineTransform.isIdentity()) {
            this.transformStack.addElement(TransformStackElement.createGeneralTransformElement(affineTransform));
        }
    }

    public void validateTransformStack() {
        this.transformStackValid = true;
    }

    public boolean isTransformStackValid() {
        return this.transformStackValid;
    }

    public TransformStackElement[] getTransformStack() {
        Object[] objectArray = new TransformStackElement[this.transformStack.size()];
        this.transformStack.copyInto(objectArray);
        return objectArray;
    }

    protected void invalidateTransformStack() {
        this.transformStack.removeAllElements();
        this.transformStackValid = false;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (shape != null) {
            shape = this.transform.createTransformedShape(shape);
        }
        if (this.clip != null) {
            Area area = new Area(this.clip);
            area.intersect(new Area(shape));
            this.clip = new GeneralPath(area);
        } else {
            this.clip = shape;
        }
    }

    public FontRenderContext getFontRenderContext() {
        Object object = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
        boolean bl = true;
        if (object != RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
            if (object != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                object = this.hints.get(RenderingHints.KEY_ANTIALIASING);
                if (object != RenderingHints.VALUE_ANTIALIAS_ON && object != RenderingHints.VALUE_ANTIALIAS_DEFAULT && object == RenderingHints.VALUE_ANTIALIAS_OFF) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        boolean bl2 = true;
        if (this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) == RenderingHints.VALUE_FRACTIONALMETRICS_OFF) {
            bl2 = false;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(this.defaultTransform, bl, bl2);
        return fontRenderContext;
    }
}

