/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.util.ASCII85OutputStream;
import org.apache.fop.util.Finalizable;
import org.apache.fop.util.FlateEncodeOutputStream;
import org.apache.fop.util.RunLengthEncodeOutputStream;

public class PSImageUtils {
    public static void renderFopImage(FopImage img, int x, int y, int w, int h, PSGenerator gen) throws IOException {
        boolean iscolor = img.getColorSpace().getType() != 1003;
        byte[] imgmap = img.getBitmaps();
        gen.saveGraphicsState();
        if (img.getColorSpace().getType() == 9) {
            gen.writeln("/DeviceCMYK setcolorspace");
        } else if (img.getColorSpace().getType() == 1003) {
            gen.writeln("/DeviceGray setcolorspace");
        } else {
            gen.writeln("/DeviceRGB setcolorspace");
        }
        gen.writeln(x + " " + y + " translate");
        gen.writeln(w + " " + h + " scale");
        gen.writeln("{{");
        if (img instanceof JpegImage) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData << >> /DCTDecode filter def");
        } else if (gen.getPSLevel() >= 3) {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /FlateDecode filter def");
        } else {
            gen.writeln("/RawData currentfile /ASCII85Decode filter def");
            gen.writeln("/Data RawData /RunLengthDecode filter def");
        }
        gen.writeln("<<");
        gen.writeln("  /ImageType 1");
        gen.writeln("  /Width " + img.getWidth());
        gen.writeln("  /Height " + img.getHeight());
        gen.writeln("  /BitsPerComponent 8");
        if (img.getColorSpace().getType() == 9) {
            gen.writeln("  /Decode [0 1 0 1 0 1 0 1]");
        } else if (iscolor) {
            gen.writeln("  /Decode [0 1 0 1 0 1]");
        } else {
            gen.writeln("  /Decode [0 1]");
        }
        gen.writeln("  /ImageMatrix [" + img.getWidth() + " 0 0 " + img.getHeight() + " 0 0]");
        gen.writeln("  /DataSource Data");
        gen.writeln(">>");
        gen.writeln("image");
        gen.writeln("} stopped {handleerror} if");
        gen.writeln("  RawData flushfile");
        gen.writeln("} exec");
        OutputStream out = gen.getOutputStream();
        out = new ASCII85OutputStream(out);
        if (!(img instanceof JpegImage)) {
            out = gen.getPSLevel() >= 3 ? new FlateEncodeOutputStream(out) : new RunLengthEncodeOutputStream(out);
        }
        out.write(imgmap);
        if (out instanceof Finalizable) {
            ((Finalizable)((Object)out)).finalizeStream();
        } else {
            out.flush();
        }
        gen.writeln("");
        gen.restoreGraphicsState();
    }
}

