/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of the License "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
/* Generated By:JavaCC: Do not edit this line. SymbianRssParser.java */
package com.nokia.sdt.sourcegen.doms.rss.parser.gen;

import com.nokia.cpp.internal.api.utils.core.IMessage;
import com.nokia.cpp.internal.api.utils.core.TextUtils;
import com.nokia.sdt.sourcegen.core.Messages;

import com.nokia.sdt.sourcegen.doms.rss.dom.*;
import com.nokia.sdt.sourcegen.doms.rss.dom.impl.*;
import com.nokia.sdt.sourcegen.doms.rss.parser.*;

public class SymbianRssParser extends ParserBase implements SymbianRssParserConstants {
    public SymbianRssParser(RssParser parser, TokenManager tokenMgr) {
        this(tokenMgr);
        this.parser = parser;
    }

  void errorToken(Token tok) throws ParseException {
      Messages.emit(
              IMessage.ERROR,
              makeSourceRef(tok),
              "SymbianRssParser.ParseErrorUnexpectedToken",
              new String[] { tok.image });
  }

  void error(ParseException e) throws ParseException {
        Messages.emit(
                IMessage.ERROR,
                makeSourceRef(token),
                "SymbianRssParser.ParseError",
                new String[] { e.getMessage() });
  }

  final public void SourceFile(IAstRssSourceFile file) throws ParseException {
    SafeTopLevelNode(file);

  }

  void SafeTopLevelNode(IAstRssSourceFile rssFile) throws ParseException {
        while (((jj_ntk==-1)?jj_ntk():jj_ntk) != EOF) {
                try {
                        TopLevelNode(rssFile);
                } catch (ParseException e) {
                        error(e);
                        getNextToken();
                }
        }
  }

  final public void TopLevelNode(IAstRssSourceFile rssFile) throws ParseException {
        IAstTopLevelNode node=null;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ENUM:
        node = ENUM();
        break;
      case STRUCT:
        node = STRUCT();
        break;
      case RESOURCE:
        node = RESOURCE();
        break;
      case NAME:
        node = NAME();
        break;
      case CHARACTER_SET:
        node = CHARACTER_SET();
        break;
      case UID2:
      case UID3:
        node = UID();
        break;
      case RLS_STRING:
        node = RLS_STRING();
        break;
      case LBRACE:
      case RBRACE:
      case IDENTIFIER:
      case BYTE:
      case WORD:
      case LT:
      case GT:
      case LPAREN:
      case RPAREN:
      case LBRACKET:
      case RBRACKET:
      case LONG:
      case TEXT:
      case DOUBLE:
      case LTEXT:
      case LTEXT8:
      case BUF:
      case BUF8:
      case LINK:
      case SRLINK:
      case EQUALS:
      case PLUS:
      case MINUS:
      case OR:
      case TIMES:
      case DIV:
      case MOD:
      case INTEGER:
      case CHAR:
      case STRING:
      case ERROR:
        IGNORE();
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                if (node != null) {
                        parser.addTopLevelNode(node);
                    }
    } catch (ParseException e) {
                error(e);
                getNextToken();
    }
  }

  final public IAstEnumDeclaration ENUM() throws ParseException {
    IAstName name = null;
    IAstEnumDeclaration decl;
        Token start, end, lbrace, rbrace;
    start = jj_consume_token(ENUM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      name = id();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
        decl = new AstEnumDeclaration(name);
    lbrace = jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      enumerator_list(decl);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    end = jj_consume_token(RBRACE);
                                                             rbrace=end;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      end = jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
        setSourceRangePlusNewLine(decl, start, end);
                setListSourceRange(decl.getEnumeratorList(), lbrace, rbrace);
        decl.setDirtyTree(false); // special comma placement makes dirty flags appear

                setExtendedSourceRangeFromComments(decl, true, false);

        {if (true) return decl;}
    throw new Error("Missing return statement in function");
  }

  final public void enumerator_list(IAstEnumDeclaration decl) throws ParseException {
        Token comma;
    enumerator(decl);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      comma = jj_consume_token(COMMA);
                        // add the comma to the enumerator's extended range (so we can include comments)
                        setSourceRangeContaining(decl.getLastEnumerator(), null, decl.getLastEnumerator(), comma);
                        includeNewLineInSourceRange(decl.getLastEnumerator());
                        setExtendedSourceRangeFromComments(decl.getLastEnumerator(), false, false);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        enumerator(decl);
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
    }
  }

  final public void enumerator(IAstEnumDeclaration decl) throws ParseException {
        Token t;
        IAstName name;
        IAstInitializerExpression init = null;
    t = jj_consume_token(IDENTIFIER);
                         name=make_id(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      init = init_expression(t);
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
                IAstEnumerator enm = new AstEnumerator(name, init);
                decl.addEnumerator(enm);
                setSourceRangeSpanning(enm, new IAstNode[] { name, init });
                includeNewLineInSourceRange(enm);
                setExtendedSourceRangeFromComments(enm, false, false);
  }

  final public IAstStructDeclaration STRUCT() throws ParseException {
        IAstName name;
        IAstStructDeclaration decl;
        IAstLengthPrefixDeclarator lp = null;
        Token start, end;
        Token lbrace;
    start = jj_consume_token(STRUCT);
    name = id();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BYTE:
    case WORD:
      lp = length_prefix();
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
            decl = new AstStructDeclaration(lp, name);
    lbrace = jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRUCT:
    case BYTE:
    case WORD:
    case LEN:
    case LONG:
    case TEXT:
    case DOUBLE:
    case LTEXT:
    case LTEXT8:
    case TEXT16:
    case LTEXT16:
    case BUF:
    case BUF8:
    case LINK:
    case LLINK:
    case SRLINK:
      struct_member_list(decl);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    end = jj_consume_token(RBRACE);
        setSourceRangePlusNewLine(decl, start, end);
        setListSourceRange(decl.getMemberList(), lbrace, end);
        decl.getMemberList().setDirty(false);
                setExtendedSourceRangeFromComments(decl, true, false);

                parser.getCurrentTranslationUnit().markDirty(); // when it gets added next time
        {if (true) return decl;}
    throw new Error("Missing return statement in function");
  }

  final public IAstLengthPrefixDeclarator length_prefix() throws ParseException {
        Token t;
        IAstLengthPrefixDeclarator decl;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BYTE:
      t = jj_consume_token(BYTE);
                decl = new AstLengthPrefixDeclarator(IAstLengthPrefixDeclarator.K_BYTE_PREFIXED);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case WORD:
      t = jj_consume_token(WORD);
                decl = new AstLengthPrefixDeclarator(IAstLengthPrefixDeclarator.K_WORD_PREFIXED);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void struct_member_list(IAstStructDeclaration decl) throws ParseException {
    label_2:
    while (true) {
      struct_member(decl);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRUCT:
      case BYTE:
      case WORD:
      case LEN:
      case LONG:
      case TEXT:
      case DOUBLE:
      case LTEXT:
      case LTEXT8:
      case TEXT16:
      case LTEXT16:
      case BUF:
      case BUF8:
      case LINK:
      case LLINK:
      case SRLINK:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_2;
      }
    }
  }

  final public void struct_member(IAstStructDeclaration decl) throws ParseException {
        Token t;
        IAstSimpleDeclaration type;
        IAstExpression lengthLimit = null;
        IAstName name;
        IAstInitializerExpression init = null;
        IAstArrayDeclarator array = null;
        IAstLengthPrefixDeclarator lengthPrefix = null;
        boolean templateStyle = false;
        Token lenStart = null, end;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEN:
      lenStart = jj_consume_token(LEN);
      lengthPrefix = length_prefix();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    type = type_name();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LT:
      jj_consume_token(LT);
      lengthLimit = expression();
                                          templateStyle=true;
      jj_consume_token(GT);
      break;
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    /* for BUF */
            t = jj_consume_token(IDENTIFIER);
                         name=make_id(t);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      lengthLimit = expression();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      array = array_declarator();
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
      init = init_or_array_expression(type, t);
      break;
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    label_3:
    while (true) {
      end = jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_3;
      }
    }
                IAstMemberDeclaration mem =
                        new AstMemberDeclaration(lengthPrefix, type, array, name,
                                lengthLimit, templateStyle, init);
                decl.addMember(mem);
                setSourceRangeSpanning(mem, new IAstNode[] { lengthPrefix, type, name, lengthLimit, array, init });
                setSourceRangeContaining(mem, lenStart, mem, end);
                includeNewLineInSourceRange(mem);
                setExtendedSourceRangeFromComments(mem, false, false);
  }

  final public IAstArrayDeclarator array_declarator() throws ParseException {
        IAstExpression expr = null;
        Token start, end;
    start = jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case LT:
    case LPAREN:
    case MINUS:
    case INTEGER:
    case FLOAT:
    case CHAR:
    case STRING:
      expr = expression();
      break;
    default:
      jj_la1[17] = jj_gen;
      ;
    }
    end = jj_consume_token(RBRACKET);
                IAstArrayDeclarator decl = new AstArrayDeclarator(expr);
                setSourceRange(decl, start, end);
                {if (true) return decl;}
    throw new Error("Missing return statement in function");
  }

  final public IAstResourceDefinition RESOURCE() throws ParseException {
        IAstStructDeclaration decl;
        IAstName name = null;
        IAstResourceDefinition def = null;
        Token start, end, lbrace;
    start = jj_consume_token(RESOURCE);
    decl = struct_type();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      name = id();
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
            if (decl != null) {
                        def = new AstResourceDefinition(decl, name);
                }
    lbrace = jj_consume_token(LBRACE);
    resource_initializer_list(def);
    end = jj_consume_token(RBRACE);
        if (def != null) {
                setSourceRangePlusNewLine(def, start, end);
                setListSourceRange(def.getInitializerList(), lbrace, end);
                def.getInitializerList().setDirty(false);
                        setExtendedSourceRangeFromComments(def, true, false);
                }

        {if (true) return def;}
    throw new Error("Missing return statement in function");
  }

  final public IAstStructDeclaration struct_type() throws ParseException {
        Token t;
    t = jj_consume_token(IDENTIFIER);
            IAstStructDeclaration decl = parser.findStructDeclaration(t.image);
            if (decl == null) {
                Messages.emit(
                                IMessage.ERROR,
                                makeSourceRef(t),
                                "SymbianRssParser.UndefinedStruct",
                                new String[] { t.image } );
                }
                {if (true) return decl;}
    throw new Error("Missing return statement in function");
  }

  final public void resource_initializer_list(IAstResource def) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      resource_member_initializer(def);
      resource_initializer_list(def);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
  }

  final public void resource_member_initializer(IAstResource def) throws ParseException {
        Token start, end = null;
        IAstExpression memberExpr = null;
        IAstExpression lengthLimit = null;
        IAstMemberDeclaration member = null;
        IAstInitializerExpression init = null;
        IAstExpression arrayIndex = null;
        Token rbracket = null;
        Token name;
                start = token;
    name = jj_consume_token(IDENTIFIER);
                member = member_lookup(def != null ? def.getStructType() : null, name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      arrayIndex = expression();
      rbracket = jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
                if (member != null) {
                        if (arrayIndex != null) {
                                memberExpr = new AstBinaryExpression(
                                        IAstBinaryExpression.K_SUBSCRIPT,
                                        new AstIdExpression(member.getMemberName()),
                                        arrayIndex);
                                setSourceRange(memberExpr, name, rbracket);
                        } else {
                                memberExpr = new AstIdExpression(member.getMemberName());
                                setSourceRange(memberExpr, name, name);
                        }
                        //setExtendedSourceRangeFromComments(memberExpr, false, false);
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      lengthLimit = integralExpression();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
          if (member != null) {
                        if (member.getMemberType().getKind() == IAstSimpleDeclaration.K_STRUCT) {
                                if (member.getArrayDeclarator() != null)
                                        init = init_resource_array_expression(member.getMemberType(), member.getArrayDeclarator(), name);
                                else
                                        init = init_resource_expression(name);
                        } else
                                init = init_or_array_expression(member.getMemberType(), name);
                }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      end = jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
                if (def != null && memberExpr != null) {
                        // TODO: validate expression type without implicit IllegalArgumentException

                        IAstMemberInitializer memberInit = new AstMemberInitializer(
                                memberExpr, lengthLimit, init);
                        def.addInitializer(memberInit);

                        setSourceRangeSpanning(memberInit, new IAstNode[] { arrayIndex, lengthLimit, init });
                        setSourceRangeContaining(memberInit, start.next, memberInit, end);
                        includeNewLineInSourceRange(memberInit);
                        setExtendedSourceRangeFromComments(memberInit, false, false);
                }
  }

  final public IAstName id() throws ParseException {
        Token t;
    t = jj_consume_token(IDENTIFIER);
                IAstName name = new AstName(t.image, null);
                setSourceRange(name, t, t);
                {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  IAstName make_id(Token t) throws ParseException {
        IAstName name = new AstName(t.image, null);
        setSourceRange(name, t, t);
        return name;
  }

  IAstMemberDeclaration member_lookup(IAstStructDeclaration decl, Token t) throws ParseException {
                // get the member
                if (decl == null)
                        return null;
                IAstMemberDeclaration memberDecl = decl.findMember(t.image);
                if (memberDecl == null) {
                        Messages.emit(
                                IMessage.ERROR,
                                makeSourceRef(t),
                                "SymbianRssParser.UndefinedMember",
                                new String[] { t.image, decl.getStructName().getName() } );
                        return null;
                } else {
                        return memberDecl;
                }
  }

  final public IAstSimpleDeclaration type_name() throws ParseException {
        Token t;
        IAstSimpleDeclaration decl;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BYTE:
      t = jj_consume_token(BYTE);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_BYTE);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case WORD:
      t = jj_consume_token(WORD);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_WORD);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LONG:
      t = jj_consume_token(LONG);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LONG);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case TEXT:
      t = jj_consume_token(TEXT);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_TEXT);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case DOUBLE:
      t = jj_consume_token(DOUBLE);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_DOUBLE);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LTEXT:
      t = jj_consume_token(LTEXT);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LTEXT);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LTEXT8:
      t = jj_consume_token(LTEXT8);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LTEXT8);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case TEXT16:
      t = jj_consume_token(TEXT16);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_TEXT16);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LTEXT16:
      t = jj_consume_token(LTEXT16);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LTEXT16);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case BUF:
      t = jj_consume_token(BUF);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_BUF);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case BUF8:
      t = jj_consume_token(BUF8);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_BUF8);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LINK:
      t = jj_consume_token(LINK);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LINK);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case LLINK:
      t = jj_consume_token(LLINK);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_LLINK);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case SRLINK:
      t = jj_consume_token(SRLINK);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_SRLINK);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    case STRUCT:
      t = jj_consume_token(STRUCT);
                decl = new AstSimpleDeclaration(IAstSimpleDeclaration.K_STRUCT);
                setSourceRange(decl, t, t);
                {if (true) return decl;}
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IAstInitializerExpression init_expression(Token limit) throws ParseException {
        IAstExpression expr;
        Token t;
    t = jj_consume_token(EQUALS);
    expr = expression();
                IAstInitializerExpression init = new AstInitializerExpression(expr);
                setSourceRangeContaining(init, t, expr, null);
                setExtendedSourceRangeFromComments(init, false, false);
                //extendSourceRangeWithLeadingWhitespace(limit, init);
                {if (true) return init;}
    throw new Error("Missing return statement in function");
  }

  final public IAstInitializerExpression init_or_array_expression(IAstSimpleDeclaration memberType, Token start) throws ParseException {
        IAstExpression expr;
        Token t;
        Token rbrace = null;
    t = jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case LT:
    case LPAREN:
    case MINUS:
    case INTEGER:
    case FLOAT:
    case CHAR:
    case STRING:
      expr = expression();
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      expr = array_expression(memberType);
      rbrace = jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                IAstInitializerExpression init = new AstInitializerExpression(expr);
                if (rbrace != null) {
                        //extendSourceRangeWithLeadingWhitespace(lbrace, expr);
                        //extendSourceRangeWithTrailingWhitespace(expr, rbrace);
                        setSourceRangeContaining(init, t, expr, rbrace);
                }
                else
                        setSourceRangeContaining(init, t, expr, null);
                setExtendedSourceRangeFromComments(init, false, false);
                //extendSourceRangeWithLeadingWhitespace(start, init);
                {if (true) return init;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression array_expression(IAstSimpleDeclaration elementType) throws ParseException {
        IAstExpressionList el;
        Token start;
                start = token;
    array_elements(el = new AstExpressionList(), elementType);
                setSourceRange(el, start.next, token);
                //if (elementType.getKind() == IAstSimpleDeclaration.K_STRUCT)
                //	setExtendedSourceRangeFromComments(el, false, true);
                //else
                        setExtendedSourceRangeFromComments(el, false, false);
                {if (true) return el;}
    throw new Error("Missing return statement in function");
  }

  final public void array_elements(IAstExpressionList el, IAstSimpleDeclaration elementType) throws ParseException {
        IAstExpression expr;
        expr=(elementType.getKind() == IAstSimpleDeclaration.K_STRUCT ?
                resource_expression() : expression());
                el.addExpression(expr);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      array_elements(el, elementType);
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
  }

  final public IAstInitializerExpression init_resource_array_expression(IAstSimpleDeclaration elementType, IAstArrayDeclarator array, Token limit) throws ParseException {
        IAstExpression expr;
        Token start, end;
    start = jj_consume_token(EQUALS);
    jj_consume_token(LBRACE);
    expr = array_expression(elementType);
    end = jj_consume_token(RBRACE);
                IAstInitializerExpression init = new AstInitializerExpression(expr);
                setSourceRangeContaining(init, start, expr, end);
                setExtendedSourceRangeFromComments(init, false, false);
                //extendSourceRangeWithLeadingWhitespace(limit, init);
                {if (true) return init;}
    throw new Error("Missing return statement in function");
  }

  final public IAstInitializerExpression init_resource_expression(Token limit) throws ParseException {
        IAstExpression expr;
        Token start;
    start = jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      expr = resource_expression();
      break;
    case LBRACE:
      expr = resource_expression_braced();
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                IAstInitializerExpression init = new AstInitializerExpression(expr);
                setSourceRangeContaining(init, start, expr, null);
                setExtendedSourceRangeFromComments(init, false, false);
                //extendSourceRangeWithLeadingWhitespace(limit, init);
                {if (true) return init;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression resource_expression() throws ParseException {
        IAstStructDeclaration decl = null;
        IAstResourceExpression def = null;
        Token start, end, lbrace;
                start = token;
    decl = struct_type();
                if (decl != null)
                        def = new AstResourceExpression(decl);
    lbrace = jj_consume_token(LBRACE);
    resource_initializer_list(def);
    end = jj_consume_token(RBRACE);
                if (def != null) {
                        setSourceRange(def, start.next, end);
                setListSourceRange(def.getInitializerList(), lbrace, end);
                def.getInitializerList().setDirty(false);
                        setExtendedSourceRangeFromComments(def, false, false);
                }
                {if (true) return def;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression resource_expression_braced() throws ParseException {
        Token start, end;
        IAstExpression expr;
    // some patterns redundantly use { } outside
            start = jj_consume_token(LBRACE);
    expr = resource_expression();
    end = jj_consume_token(RBRACE);
                setSourceRange(expr, start, end);
                setExtendedSourceRangeFromComments(expr, false, false);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression expression() throws ParseException {
        IAstExpression expr;
    expr = addExpression();
                setExtendedSourceRangeFromComments(expr, false, false);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression addExpression() throws ParseException {
        Token t = null;
        IAstExpression lhs, rhs=null;
        IAstExpression ret;
    lhs = mulExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case OR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      case OR:
        t = jj_consume_token(OR);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rhs = addExpression();
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
                if (rhs != null) {
                        int oper;
                        if (t.kind == PLUS)
                                oper = IAstBinaryExpression.K_ADD;
                        else if (t.kind == MINUS)
                                oper = IAstBinaryExpression.K_SUB;
                        else
                                oper = IAstBinaryExpression.K_OR;
                        ret = new AstBinaryExpression(oper, lhs, rhs);
                        setSourceRangeSpanning(ret, new IAstNode[] { lhs, rhs });
                } else {
                        ret = lhs;
                }
                {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression mulExpression() throws ParseException {
        Token t = null;
        IAstExpression lhs, rhs=null;
        IAstExpression ret;
    lhs = unaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TIMES:
    case DIV:
    case MOD:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIMES:
        t = jj_consume_token(TIMES);
        break;
      case DIV:
        t = jj_consume_token(DIV);
        break;
      case MOD:
        t = jj_consume_token(MOD);
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rhs = mulExpression();
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
                if (rhs != null) {
                        int oper;
                        if (t.kind == TIMES)
                                oper = IAstBinaryExpression.K_MUL;
                        else if (t.kind == DIV)
                                oper = IAstBinaryExpression.K_DIV;
                        else
                                oper = IAstBinaryExpression.K_MOD;
                        ret = new AstBinaryExpression(oper, lhs, rhs);
                        setSourceRangeSpanning(ret, new IAstNode[] { lhs, rhs });
                } else
                        ret = lhs;
                {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression unaryExpression() throws ParseException {
        Token t;
        IAstExpression expr = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
    case LT:
    case LPAREN:
    case INTEGER:
    case FLOAT:
    case CHAR:
    case STRING:
      expr = postfixExpression();
                {if (true) return expr;}
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
      expr = primaryExpression();
                IAstExpression ret = new AstUnaryExpression(IAstUnaryExpression.K_NEGATE, expr);
                setSourceRangeContaining(ret, t, expr, null);
                {if (true) return ret;}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression postfixExpression() throws ParseException {
        IAstExpression expr, after=null;
        Token start = null, end = null;
    expr = primaryExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      start = jj_consume_token(LBRACKET);
      after = expression();
      end = jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
                if (after != null) {
                        IAstExpression ret = new AstBinaryExpression(IAstBinaryExpression.K_SUBSCRIPT, expr, after);
                        setSourceRange(ret, start, end);
                        {if (true) return ret;}
                } else
                        {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression primaryExpression() throws ParseException {
        IAstExpression expr = null;
        Token start, end;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      start = jj_consume_token(IDENTIFIER);
                expr = new AstIdExpression(new AstName(token.image, null));
                setSourceRange(expr, start, start);
                {if (true) return expr;}
      break;
    case LPAREN:
      start = jj_consume_token(LPAREN);
      expr = expression();
      end = jj_consume_token(RPAREN);
                expr = new AstUnaryExpression(IAstUnaryExpression.K_PARENTHESIS, expr);
                setSourceRange(expr, start, end);
                {if (true) return expr;}
      break;
    case LT:
    case INTEGER:
    case FLOAT:
    case CHAR:
    case STRING:
      expr = constantExpression();
                {if (true) return expr;}
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IAstExpression constantExpression() throws ParseException {
        IAstLiteralExpression string;
        Token start;
        IAstExpression ret;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      start = jj_consume_token(INTEGER);
                ret = new AstLiteralExpression(IAstLiteralExpression.K_INTEGER, token.image);
                setSourceRange(ret, start, start);
                {if (true) return ret;}
      break;
    case FLOAT:
      start = jj_consume_token(FLOAT);
                ret = new AstLiteralExpression(IAstLiteralExpression.K_FLOAT, token.image);
                setSourceRange(ret, start, start);
                {if (true) return ret;}
      break;
    case CHAR:
      start = jj_consume_token(CHAR);
                ret = new AstLiteralExpression(IAstLiteralExpression.K_CHAR, token.image.substring(1,2));
                setSourceRange(ret, start, start);
                {if (true) return ret;}
      break;
    case LT:
    case STRING:
      string = string_literal();
                {if (true) return string;}
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IAstLiteralExpression string_literal() throws ParseException {
        StringBuffer buf;
        Token start = null, end;
                start = token;
                buf = new StringBuffer();
    label_4:
    while (true) {
      end = stringLiteralPart(buf);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
      case STRING:
        ;
        break;
      default:
        jj_la1[35] = jj_gen;
        break label_4;
      }
    }
                IAstLiteralExpression expr = new AstLiteralExpression(IAstLiteralExpression.K_STRING, buf.toString());

                // don't trust CDT -- when catenating strings it loses track
                // of the first token range
                setSourceRangeAfterStart(expr, start, end);
                {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

  final public Token stringLiteralPart(StringBuffer buf) throws ParseException {
        Token start;
        String string;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      start = jj_consume_token(STRING);
                buf.append(TextUtils.unescape(TextUtils.unquote(start.image, '"')));
                {if (true) return start;}
      break;
    case LT:
             start=token.next;
      string = escapedCharacter();
                buf.append(string);
                {if (true) return start;}
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String escapedCharacter() throws ParseException {
        Token t;
    jj_consume_token(LT);
    t = jj_consume_token(INTEGER);
    jj_consume_token(GT);
                try {
                        {if (true) return new String(new char[] {
                                (char)AstLiteralExpression.parseIntValue(t.image) } );}
                } catch (NumberFormatException e) {
                        Messages.emit(
                                IMessage.ERROR,
                                makeSourceRef(t),
                                "SymbianRssParser.IllegalCharacter",
                                new String[] { t.image } );
                        {if (true) return "<" + t.image + ">";}
                }
    throw new Error("Missing return statement in function");
  }

  final public IAstLiteralExpression integralExpression() throws ParseException {
        Token start;
        IAstLiteralExpression ret;
    start = jj_consume_token(INTEGER);
                ret = new AstLiteralExpression(IAstLiteralExpression.K_INTEGER, token.image);
                setSourceRange(ret, start, start);
                setExtendedSourceRangeFromComments(ret, false, false);
                {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public IAstNameStatement NAME() throws ParseException {
        Token start, end;
    start = jj_consume_token(NAME);
    end = jj_consume_token(IDENTIFIER);
                try {
                        IAstNameStatement name = new AstNameStatement(end.image);
                        setSourceRangePlusNewLine(name, start, end);
                        setExtendedSourceRangeFromComments(name, true, false);
                        {if (true) return name;}
                } catch (IllegalArgumentException e) {
                        Messages.emit(
                                IMessage.ERROR,
                                makeSourceRef(end),
                                "SymbianRssParser.IllegalNameStatement",
                                new String[] { end.image } );
                        {if (true) return null;}
                }
    throw new Error("Missing return statement in function");
  }

  final public IAstCharacterSetStatement CHARACTER_SET() throws ParseException {
        Token start, end;
    start = jj_consume_token(CHARACTER_SET);
    end = jj_consume_token(IDENTIFIER);
                IAstCharacterSetStatement cset = new AstCharacterSetStatement(end.image);
                setSourceRangePlusNewLine(cset, start, end);
                setExtendedSourceRangeFromComments(cset, true, false);
                {if (true) return cset;}
    throw new Error("Missing return statement in function");
  }

  final public IAstUidStatement UID() throws ParseException {
        Token start;
        IAstLiteralExpression expr;
        IAstUidStatement uid;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UID2:
      start = jj_consume_token(UID2);
      expr = integralExpression();
                uid = new AstUidStatement(2, expr);
                setSourceRangeContaining(uid, start, expr, null);
                includeNewLineInSourceRange(uid);
                setExtendedSourceRangeFromComments(uid, true, false);
                {if (true) return uid;}
      break;
    case UID3:
      start = jj_consume_token(UID3);
      expr = integralExpression();
                uid = new AstUidStatement(3, expr);
                setSourceRangeContaining(uid, start, expr, null);
                includeNewLineInSourceRange(uid);
                setExtendedSourceRangeFromComments(uid, true, false);
                {if (true) return uid;}
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public IAstRlsString RLS_STRING() throws ParseException {
        Token start;
    IAstName name = null;
    IAstLiteralExpression string = null;
    start = jj_consume_token(RLS_STRING);
    name = id();
    string = string_literal();
                IAstRlsString rlsString = new AstRlsString(name, string);
                setSourceRangeSpanning(rlsString, new IAstNode[] { name, string });
                setSourceRangeContaining(rlsString, start, rlsString, null);
                includeNewLineInSourceRange(rlsString);
                setExtendedSourceRangeFromComments(rlsString, true, false);
                {if (true) return rlsString;}
    throw new Error("Missing return statement in function");
  }

  final public void IGNORE() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER:
      jj_consume_token(INTEGER);
      break;
    case STRING:
      jj_consume_token(STRING);
      break;
    case CHAR:
      jj_consume_token(CHAR);
      break;
    case ERROR:
      jj_consume_token(ERROR);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      break;
    case RPAREN:
      jj_consume_token(RPAREN);
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      break;
    case RBRACKET:
      jj_consume_token(RBRACKET);
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case TIMES:
      jj_consume_token(TIMES);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case OR:
      jj_consume_token(OR);
      break;
    case EQUALS:
      jj_consume_token(EQUALS);
      break;
    case DIV:
      jj_consume_token(DIV);
      break;
    case BYTE:
      jj_consume_token(BYTE);
      break;
    case WORD:
      jj_consume_token(WORD);
      break;
    case LONG:
      jj_consume_token(LONG);
      break;
    case TEXT:
      jj_consume_token(TEXT);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
      break;
    case LTEXT:
      jj_consume_token(LTEXT);
      break;
    case LTEXT8:
      jj_consume_token(LTEXT8);
      break;
    case BUF:
      jj_consume_token(BUF);
      break;
    case BUF8:
      jj_consume_token(BUF8);
      break;
    case LINK:
      jj_consume_token(LINK);
      break;
    case LT:
      jj_consume_token(LT);
      break;
    case GT:
      jj_consume_token(GT);
      break;
    case SRLINK:
      jj_consume_token(SRLINK);
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      break;
    case RBRACE:
      jj_consume_token(RBRACE);
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          errorToken(token);
  }

  final public void UNUSED() throws ParseException {
    jj_consume_token(ERROR);
    skip();
  }

  void skip() throws ParseException {
         getToken(1);
  }

  void skip_to_matching_brace() throws ParseException {
        Token tok;
  int nesting = 1;
  while (true) {
    tok = getToken(1);
    if (tok.kind == LBRACE) nesting++;
    if (tok.kind == RBRACE) {
      nesting--;
      if (nesting == 0) break;
    }
    tok = getNextToken();
  }
  }

  public TokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[39];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xee7ffbce,0x40,0x40,0x10,0x20,0x40,0x40000000,0x300,0x3ffc0780,0x300,0x3ffc0780,0x400,0x800,0x2000,0x8000,0x40000000,0x10,0x2840,0x40,0x40,0x8000,0x2000,0x10,0x3ffc0380,0x2844,0x20,0x44,0x80000000,0x80000000,0x0,0x0,0x2840,0x8000,0x2840,0x800,0x800,0x800,0x0,0xee7dfb4c,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x7fbf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1e1,0x0,0x0,0x0,0x0,0x0,0x0,0x1e1,0x0,0x0,0x3,0x3,0x1c,0x1c,0x1e1,0x0,0x1e0,0x1e0,0x100,0x100,0x1800,0x41bf,};
   }


  public SymbianRssParser(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
  }

  public void ReInit(TokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[47];
    for (int i = 0; i < 47; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 39; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 47; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
