/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.codec.PNGEncodeParam;
import org.apache.batik.ext.awt.image.codec.PNGImageEncoder;
import org.apache.batik.ext.awt.image.rendered.IndexImage;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.IntegerKey;

public class PNGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_GAMMA = new FloatKey();
    public static final float[] DEFAULT_CHROMA = new float[]{0.3127f, 0.329f, 0.64f, 0.33f, 0.3f, 0.6f, 0.15f, 0.06f};
    public static final TranscodingHints.Key KEY_INDEXED = new IntegerKey();

    public PNGTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        PNGEncodeParam pNGEncodeParam;
        int n;
        int n2;
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("png.badoutput", null));
        }
        boolean bl = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            n = ((SinglePixelPackedSampleModel)bufferedImage.getSampleModel()).getScanlineStride();
            int n4 = dataBufferInt.getOffset();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n5 = n4;
            int n6 = n - n2;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    n11 = nArray[n5];
                    n7 = n11 >> 24 & 0xFF;
                    n8 = n11 >> 16 & 0xFF;
                    n9 = n11 >> 8 & 0xFF;
                    n10 = n11 & 0xFF;
                    n8 = (255 * (255 - n7) + n7 * n8) / 255;
                    n9 = (255 * (255 - n7) + n7 * n9) / 255;
                    n10 = (255 * (255 - n7) + n7 * n10) / 255;
                    nArray[n5++] = n7 << 24 & 0xFF000000 | n8 << 16 & 0xFF0000 | n9 << 8 & 0xFF00 | n10 & 0xFF;
                }
                n5 += n6;
            }
        }
        n2 = -1;
        if (this.hints.containsKey(KEY_INDEXED) && ((n2 = ((Integer)this.hints.get(KEY_INDEXED)).intValue()) == 1 || n2 == 2 || n2 == 4 || n2 == 8)) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)bufferedImage, (int)(1 << n2));
        }
        if ((pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)bufferedImage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pNGEncodeParam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (this.hints.containsKey(KEY_GAMMA)) {
            float f = ((Float)this.hints.get(KEY_GAMMA)).floatValue();
            if (f > 0.0f) {
                pNGEncodeParam.setGamma(f);
            }
            pNGEncodeParam.setChromaticity(DEFAULT_CHROMA);
        } else {
            pNGEncodeParam.setSRGBIntent(0);
        }
        float f = this.userAgent.getPixelUnitToMillimeter();
        n = (int)((double)(1000.0f / f) + 0.5);
        pNGEncodeParam.setPhysicalDimension(n, n, 1);
        try {
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, pNGEncodeParam);
            pNGImageEncoder.encode((RenderedImage)bufferedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

