/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.optimizer.OptClassNameHelper;

public class OptFunctionNode
extends FunctionNode {
    private String itsClassName;
    private boolean itsIsTargetOfDirectCall;
    private boolean itsContainsCalls;
    private boolean[] itsContainsCallsCount = new boolean[4];
    private boolean itsParameterNumberContext;
    private ObjArray itsDirectCallTargets;

    public OptFunctionNode(String name, Node left, Node right, ClassNameHelper nameHelper) {
        super(name, left, right);
        OptClassNameHelper nh = (OptClassNameHelper)nameHelper;
        this.itsClassName = nh.getJavaScriptClassName(name, false);
    }

    public String getDirectCallParameterSignature() {
        StringBuffer parameterSig = new StringBuffer("(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        int pCount = this.itsVariableTable.getParameterCount();
        int i = 0;
        while (i < pCount) {
            parameterSig.append("Ljava/lang/Object;D");
            ++i;
        }
        parameterSig.append("[Ljava/lang/Object;)");
        return parameterSig.toString();
    }

    public String getClassName() {
        return this.itsClassName;
    }

    public boolean isTargetOfDirectCall() {
        return this.itsIsTargetOfDirectCall;
    }

    public void addDirectCallTarget(FunctionNode target) {
        if (this.itsDirectCallTargets == null) {
            this.itsDirectCallTargets = new ObjArray();
        }
        int i = 0;
        while (i < this.itsDirectCallTargets.size()) {
            if ((FunctionNode)this.itsDirectCallTargets.get(i) == target) {
                return;
            }
            ++i;
        }
        this.itsDirectCallTargets.add(target);
    }

    public ObjArray getDirectCallTargets() {
        return this.itsDirectCallTargets;
    }

    public void setIsTargetOfDirectCall() {
        this.itsIsTargetOfDirectCall = true;
    }

    public void setParameterNumberContext(boolean b) {
        this.itsParameterNumberContext = b;
    }

    public boolean getParameterNumberContext() {
        return this.itsParameterNumberContext;
    }

    public boolean containsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length && argCount >= 0) {
            return this.itsContainsCallsCount[argCount];
        }
        return this.itsContainsCalls;
    }

    public void setContainsCalls(int argCount) {
        if (argCount < this.itsContainsCallsCount.length) {
            this.itsContainsCallsCount[argCount] = true;
        }
        this.itsContainsCalls = true;
    }

    public void incrementLocalCount() {
        int localCount = this.getIntProp(22, 0);
        this.putIntProp(22, localCount + 1);
    }
}

