/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGFontDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFont
extends AbstractSVGConverter {
    public static final float EXTRA_LIGHT = TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue();
    public static final float LIGHT = TextAttribute.WEIGHT_LIGHT.floatValue();
    public static final float DEMILIGHT = TextAttribute.WEIGHT_DEMILIGHT.floatValue();
    public static final float REGULAR = TextAttribute.WEIGHT_REGULAR.floatValue();
    public static final float SEMIBOLD = TextAttribute.WEIGHT_SEMIBOLD.floatValue();
    public static final float MEDIUM = TextAttribute.WEIGHT_MEDIUM.floatValue();
    public static final float DEMIBOLD = TextAttribute.WEIGHT_DEMIBOLD.floatValue();
    public static final float BOLD = TextAttribute.WEIGHT_BOLD.floatValue();
    public static final float HEAVY = TextAttribute.WEIGHT_HEAVY.floatValue();
    public static final float EXTRABOLD = TextAttribute.WEIGHT_EXTRABOLD.floatValue();
    public static final float ULTRABOLD = TextAttribute.WEIGHT_ULTRABOLD.floatValue();
    public static final float POSTURE_REGULAR = TextAttribute.POSTURE_REGULAR.floatValue();
    public static final float POSTURE_OBLIQUE = TextAttribute.POSTURE_OBLIQUE.floatValue();
    static final float[] fontStyles = new float[]{POSTURE_REGULAR + (POSTURE_OBLIQUE - POSTURE_REGULAR) / 2.0f};
    static final String[] svgStyles = new String[]{"normal", "italic"};
    static final float[] fontWeights = new float[]{EXTRA_LIGHT + (LIGHT - EXTRA_LIGHT) / 2.0f, LIGHT + (DEMILIGHT - LIGHT) / 2.0f, DEMILIGHT + (REGULAR - DEMILIGHT) / 2.0f, REGULAR + (SEMIBOLD - REGULAR) / 2.0f, SEMIBOLD + (MEDIUM - SEMIBOLD) / 2.0f, MEDIUM + (DEMIBOLD - MEDIUM) / 2.0f, DEMIBOLD + (BOLD - DEMIBOLD) / 2.0f, BOLD + (HEAVY - BOLD) / 2.0f, HEAVY + (EXTRABOLD - HEAVY) / 2.0f, EXTRABOLD + (ULTRABOLD - EXTRABOLD)};
    static final String[] svgWeights = new String[]{"100", "200", "300", "normal", "500", "500", "600", "bold", "800", "800", "900"};
    static Map logicalFontMap = new HashMap();
    static final int COMMON_FONT_SIZE = 100;
    Map fontStringMap = new HashMap();

    public SVGFont(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public void recordFontUsage(String string, Font font) {
        Font font2 = SVGFont.createCommonSizeFont(font);
        String string2 = font2.getFamily() + font2.getStyle();
        String string3 = (String)this.fontStringMap.get(string2);
        if (string3 == null) {
            string3 = "";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string3.indexOf(c) != -1) continue;
            string3 = string3 + c;
        }
        this.fontStringMap.put(string2, string3);
    }

    private static Font createCommonSizeFont(Font font) {
        HashMap hashMap = new HashMap(font.getAttributes());
        hashMap.put(TextAttribute.SIZE, new Float(100.0f));
        return new Font(hashMap);
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG(graphicContext.getFont(), graphicContext.getFontRenderContext());
    }

    public SVGFontDescriptor toSVG(Font font, FontRenderContext fontRenderContext) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Element element;
        String string = "" + this.doubleString(font.getSize2D());
        String string2 = SVGFont.weightToSVG(font);
        String string3 = SVGFont.styleToSVG(font);
        String string4 = SVGFont.familyToSVG(font);
        Font font2 = SVGFont.createCommonSizeFont(font);
        String string5 = font2.getFamily() + font2.getStyle();
        String string6 = (String)this.fontStringMap.get(string5);
        if (string6 == null) {
            return new SVGFontDescriptor(string, string2, string3, string4, null);
        }
        Document document = this.generatorContext.domFactory;
        SVGFontDescriptor sVGFontDescriptor = (SVGFontDescriptor)this.descMap.get(string5);
        if (sVGFontDescriptor != null) {
            element = sVGFontDescriptor.getDef();
        } else {
            element = document.createElementNS("http://www.w3.org/2000/svg", "font");
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "font-face");
            String string7 = string4;
            if (string4.startsWith("'") && string4.endsWith("'")) {
                string7 = string4.substring(1, string4.length() - 1);
            }
            element2.setAttributeNS(null, "font-family", string7);
            element2.setAttributeNS(null, "font-weight", string2);
            element2.setAttributeNS(null, "font-style", string3);
            element2.setAttributeNS(null, "units-per-em", "100");
            element.appendChild(element2);
            Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "missing-glyph");
            object6 = new int[1];
            object6[0] = font2.getMissingGlyphCode();
            object5 = font2.createGlyphVector(fontRenderContext, (int[])object6);
            object4 = ((GlyphVector)object5).getGlyphOutline(0);
            object3 = ((GlyphVector)object5).getGlyphMetrics(0);
            object2 = AffineTransform.getScaleInstance(1.0, -1.0);
            object4 = ((AffineTransform)object2).createTransformedShape((Shape)object4);
            element3.setAttributeNS(null, "d", SVGPath.toSVGPathData((Shape)object4, this.generatorContext));
            element3.setAttributeNS(null, "horiz-adv-x", "" + ((GlyphMetrics)object3).getAdvance());
            element.appendChild(element3);
            element.setAttributeNS(null, "horiz-adv-x", "" + ((GlyphMetrics)object3).getAdvance());
            object = font2.getLineMetrics("By", fontRenderContext);
            element2.setAttributeNS(null, "ascent", "" + ((LineMetrics)object).getAscent());
            element2.setAttributeNS(null, "descent", "" + ((LineMetrics)object).getDescent());
            element.setAttributeNS(null, "id", this.generatorContext.idGenerator.generateID("font"));
        }
        for (int i = string6.length() - 1; i >= 0; --i) {
            char c = string6.charAt(i);
            boolean bl = false;
            object6 = element.getChildNodes();
            for (int j = 0; j < object6.getLength(); ++j) {
                if (!(object6.item(j) instanceof Element) || !(object4 = (Element)object6.item(j)).getAttributeNS(null, "unicode").equals("" + c)) continue;
                bl = true;
                break;
            }
            if (bl) break;
            object5 = document.createElementNS("http://www.w3.org/2000/svg", "glyph");
            object4 = font2.createGlyphVector(fontRenderContext, "" + c);
            object3 = ((GlyphVector)object4).getGlyphOutline(0);
            object2 = ((GlyphVector)object4).getGlyphMetrics(0);
            object = AffineTransform.getScaleInstance(1.0, -1.0);
            object3 = ((AffineTransform)object).createTransformedShape((Shape)object3);
            object5.setAttributeNS(null, "d", SVGPath.toSVGPathData((Shape)object3, this.generatorContext));
            object5.setAttributeNS(null, "horiz-adv-x", "" + ((GlyphMetrics)object2).getAdvance());
            object5.setAttributeNS(null, "unicode", "" + c);
            element.appendChild((Node)object5);
        }
        SVGFontDescriptor sVGFontDescriptor2 = new SVGFontDescriptor(string, string2, string3, string4, element);
        if (sVGFontDescriptor == null) {
            this.descMap.put(string5, sVGFontDescriptor2);
            this.defSet.add(element);
        }
        return sVGFontDescriptor2;
    }

    public static String familyToSVG(Font font) {
        String string = font.getFamily();
        String string2 = (String)logicalFontMap.get(font.getName().toLowerCase());
        if (string2 != null) {
            string = string2;
        } else {
            StringBuffer stringBuffer = new StringBuffer("'");
            stringBuffer.append(string);
            stringBuffer.append("'");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String styleToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.POSTURE);
        if (f == null) {
            f = font.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        for (n = 0; n < fontStyles.length && !(f2 <= fontStyles[n]); ++n) {
        }
        return svgStyles[n];
    }

    public static String weightToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.WEIGHT);
        if (f == null) {
            f = font.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        for (n = 0; n < fontWeights.length && !(f2 <= fontWeights[n]); ++n) {
        }
        return svgWeights[n];
    }

    static {
        logicalFontMap.put("dialog", "sans-serif");
        logicalFontMap.put("dialoginput", "monospace");
        logicalFontMap.put("monospaced", "monospace");
        logicalFontMap.put("serif", "serif");
        logicalFontMap.put("sansserif", "sans-serif");
        logicalFontMap.put("symbol", "'WingDings'");
    }
}

