/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Element;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;

    protected UnitProcessor() {
    }

    public static float svgToObjectBoundingBox(String string, String string2, short s, Context context) throws ParseException {
        LengthParser lengthParser = new LengthParser();
        UnitResolver unitResolver = new UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.svgToObjectBoundingBox(unitResolver.value, unitResolver.unit, s, context);
    }

    public static float svgToObjectBoundingBox(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: {
                return f;
            }
            case 2: {
                return f / 100.0f;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return UnitProcessor.svgToUserSpace(f, s, s2, context);
            }
        }
        throw new Error();
    }

    public static float svgToUserSpace(String string, String string2, short s, Context context) throws ParseException {
        LengthParser lengthParser = new LengthParser();
        UnitResolver unitResolver = new UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.svgToUserSpace(unitResolver.value, unitResolver.unit, s, context);
    }

    public static float svgToUserSpace(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: 
            case 5: {
                return f;
            }
            case 7: {
                return f / context.getPixelUnitToMillimeter();
            }
            case 6: {
                return f * 10.0f / context.getPixelUnitToMillimeter();
            }
            case 8: {
                return f * 25.4f / context.getPixelUnitToMillimeter();
            }
            case 9: {
                return f * 25.4f / (72.0f * context.getPixelUnitToMillimeter());
            }
            case 10: {
                return f * 25.4f / (6.0f * context.getPixelUnitToMillimeter());
            }
            case 3: {
                return UnitProcessor.emsToPixels(f, s2, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f, s2, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, s2, context);
            }
        }
        throw new Error();
    }

    public static float userSpaceToSVG(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: 
            case 5: {
                return f;
            }
            case 7: {
                return f * context.getPixelUnitToMillimeter();
            }
            case 6: {
                return f * context.getPixelUnitToMillimeter() / 10.0f;
            }
            case 8: {
                return f * context.getPixelUnitToMillimeter() / 25.4f;
            }
            case 9: {
                return f * (72.0f * context.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 10: {
                return f * (6.0f * context.getPixelUnitToMillimeter()) / 25.4f;
            }
            case 3: {
                return UnitProcessor.pixelsToEms(f, s2, context);
            }
            case 4: {
                return UnitProcessor.pixelsToExs(f, s2, context);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(f, s2, context);
            }
        }
        throw new Error();
    }

    protected static float percentagesToPixels(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f2 * f / 100.0f;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f3 * f / 100.0f;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)(d3 * (double)f / 100.0);
    }

    protected static float pixelsToPercentages(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f * 100.0f / f2;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f * 100.0f / f3;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)((double)f * 100.0 / d3);
    }

    protected static float pixelsToEms(float f, short s, Context context) {
        return f / context.getFontSize();
    }

    protected static float emsToPixels(float f, short s, Context context) {
        return f * context.getFontSize();
    }

    protected static float pixelsToExs(float f, short s, Context context) {
        float f2 = context.getXHeight();
        return f / f2 / context.getFontSize();
    }

    protected static float exsToPixels(float f, short s, Context context) {
        float f2 = context.getXHeight();
        return f * f2 * context.getFontSize();
    }

    public static interface Context {
        public Element getElement();

        public float getPixelUnitToMillimeter();

        public float getPixelToMM();

        public float getFontSize();

        public float getXHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    implements LengthHandler {
        public float value;
        public short unit = 1;

        public void startLength() throws ParseException {
        }

        public void lengthValue(float f) throws ParseException {
            this.value = f;
        }

        public void em() throws ParseException {
            this.unit = (short)3;
        }

        public void ex() throws ParseException {
            this.unit = (short)4;
        }

        public void in() throws ParseException {
            this.unit = (short)8;
        }

        public void cm() throws ParseException {
            this.unit = (short)6;
        }

        public void mm() throws ParseException {
            this.unit = (short)7;
        }

        public void pc() throws ParseException {
            this.unit = (short)10;
        }

        public void pt() throws ParseException {
            this.unit = (short)9;
        }

        public void px() throws ParseException {
            this.unit = (short)5;
        }

        public void percentage() throws ParseException {
            this.unit = (short)2;
        }

        public void endLength() throws ParseException {
        }
    }
}

