/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.NodeDetail;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathNodeTracker;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DifferenceEngine
implements DifferenceConstants {
    private static final String NULL_NODE = "null";
    private static final String NOT_NULL_NODE = "not null";
    private final ComparisonController controller;
    private final XpathNodeTracker controlTracker;
    private final XpathNodeTracker testTracker;
    private static final DifferenceFoundException flowControlException;

    public DifferenceEngine(ComparisonController controller) {
        this.controller = controller;
        this.controlTracker = new XpathNodeTracker();
        this.testTracker = new XpathNodeTracker();
    }

    public void compare(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) {
        this.controlTracker.reset();
        this.testTracker.reset();
        try {
            this.compare(this.getNullOrNotNull(control), this.getNullOrNotNull(test), control, test, listener, DifferenceConstants.NODE_TYPE);
            if (control != null) {
                this.compareNode(control, test, listener, elementQualifier);
            }
        }
        catch (DifferenceFoundException e) {
            // empty catch block
        }
    }

    private String getNullOrNotNull(Node aNode) {
        return aNode == null ? NULL_NODE : NOT_NULL_NODE;
    }

    protected void compareNode(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        boolean comparable = this.compareNodeBasics(control, test, listener);
        boolean isDocumentNode = false;
        if (comparable) {
            switch (control.getNodeType()) {
                case 1: {
                    this.compareElement((Element)control, (Element)test, listener);
                    break;
                }
                case 4: {
                    this.compareCDataSection((CDATASection)control, (CDATASection)test, listener);
                    break;
                }
                case 8: {
                    this.compareComment((Comment)control, (Comment)test, listener);
                    break;
                }
                case 10: {
                    this.compareDocumentType((DocumentType)control, (DocumentType)test, listener);
                    break;
                }
                case 7: {
                    this.compareProcessingInstruction((ProcessingInstruction)control, (ProcessingInstruction)test, listener);
                    break;
                }
                case 3: {
                    this.compareText((Text)control, (Text)test, listener);
                    break;
                }
                case 9: {
                    isDocumentNode = true;
                    this.compareDocument((Document)control, (Document)test, listener, elementQualifier);
                    break;
                }
                default: {
                    listener.skippedComparison(control, test);
                }
            }
        }
        this.compareHasChildNodes(control, test, listener);
        if (isDocumentNode) {
            Element controlElement = ((Document)control).getDocumentElement();
            Element testElement = ((Document)test).getDocumentElement();
            if (controlElement != null && testElement != null) {
                this.compareNode(controlElement, testElement, listener, elementQualifier);
            }
        } else {
            this.controlTracker.indent();
            this.testTracker.indent();
            this.compareNodeChildren(control, test, listener, elementQualifier);
            this.controlTracker.outdent();
            this.testTracker.outdent();
        }
    }

    protected void compareDocument(Document control, Document test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        DocumentType controlDoctype = control.getDoctype();
        DocumentType testDoctype = test.getDoctype();
        this.compare(this.getNullOrNotNull(controlDoctype), this.getNullOrNotNull(testDoctype), controlDoctype, testDoctype, listener, DifferenceConstants.HAS_DOCTYPE_DECLARATION);
        if (controlDoctype != null && testDoctype != null) {
            this.compareNode(controlDoctype, testDoctype, listener, elementQualifier);
        }
    }

    protected boolean compareNodeBasics(Node control, Node test, DifferenceListener listener) throws DifferenceFoundException {
        this.controlTracker.visited(control);
        this.testTracker.visited(test);
        Short controlType = new Short(control.getNodeType());
        Short testType = new Short(test.getNodeType());
        this.compare(controlType, testType, control, test, listener, DifferenceConstants.NODE_TYPE);
        this.compare(control.getNamespaceURI(), test.getNamespaceURI(), control, test, listener, DifferenceConstants.NAMESPACE_URI);
        this.compare(control.getPrefix(), test.getPrefix(), control, test, listener, DifferenceConstants.NAMESPACE_PREFIX);
        return controlType.equals(testType);
    }

    protected void compareHasChildNodes(Node control, Node test, DifferenceListener listener) throws DifferenceFoundException {
        Boolean controlHasChildren = control.hasChildNodes() ? Boolean.TRUE : Boolean.FALSE;
        Boolean testHasChildren = test.hasChildNodes() ? Boolean.TRUE : Boolean.FALSE;
        this.compare(controlHasChildren, testHasChildren, control, test, listener, DifferenceConstants.HAS_CHILD_NODES);
    }

    protected void compareNodeChildren(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        if (control.hasChildNodes() && test.hasChildNodes()) {
            NodeList controlChildren = control.getChildNodes();
            NodeList testChildren = test.getChildNodes();
            Integer controlLength = new Integer(controlChildren.getLength());
            Integer testLength = new Integer(testChildren.getLength());
            this.compare(controlLength, testLength, control, test, listener, DifferenceConstants.CHILD_NODELIST_LENGTH);
            this.compareNodeList(controlChildren, testChildren, controlLength, listener, elementQualifier);
        }
    }

    protected void compareNodeList(NodeList control, NodeList test, int numNodes, DifferenceListener listener, ElementQualifier elementQualifier) throws DifferenceFoundException {
        Node nextTest = null;
        int j = 0;
        int lastTestNode = test.getLength() - 1;
        this.testTracker.preloadNodeList(test);
        int i = 0;
        while (i < numNodes) {
            int startAt;
            Node nextControl = control.item(i);
            boolean matchOnElement = nextControl instanceof Element;
            short findNodeType = nextControl.getNodeType();
            j = startAt = i > lastTestNode ? lastTestNode : i;
            boolean matchFound = false;
            while (!matchFound) {
                if (matchOnElement && test.item(j) instanceof Element && elementQualifier.qualifyForComparison((Element)nextControl, (Element)test.item(j))) {
                    matchFound = true;
                    continue;
                }
                if (!matchOnElement && findNodeType == test.item(j).getNodeType()) {
                    matchFound = true;
                    continue;
                }
                if (++j > lastTestNode) {
                    j = 0;
                }
                if (j == startAt) break;
            }
            nextTest = test.item(j);
            this.compareNode(nextControl, nextTest, listener, elementQualifier);
            this.compare(new Integer(i), new Integer(j), nextControl, nextTest, listener, DifferenceConstants.CHILD_NODELIST_SEQUENCE);
            ++i;
        }
    }

    private boolean isNamespaced(Node aNode) {
        String namespace = aNode.getNamespaceURI();
        return namespace != null && namespace.length() > 0;
    }

    protected void compareElement(Element control, Element test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(this.getUnNamespacedNodeName(control), this.getUnNamespacedNodeName(test), control, test, listener, DifferenceConstants.ELEMENT_TAG_NAME);
        NamedNodeMap controlAttr = control.getAttributes();
        Integer controlNonXmlnsAttrLength = this.getNonXmlnsAttrLength(controlAttr);
        NamedNodeMap testAttr = test.getAttributes();
        Integer testNonXmlnsAttrLength = this.getNonXmlnsAttrLength(testAttr);
        this.compare(controlNonXmlnsAttrLength, testNonXmlnsAttrLength, control, test, listener, DifferenceConstants.ELEMENT_NUM_ATTRIBUTES);
        this.compareElementAttributes(control, test, controlAttr, testAttr, listener);
    }

    private Integer getNonXmlnsAttrLength(NamedNodeMap attributes) {
        int length = 0;
        int maxLength = attributes.getLength();
        int i = 0;
        while (i < maxLength) {
            if (!this.isXMLNSAttribute((Attr)attributes.item(i))) {
                ++length;
            }
            ++i;
        }
        return new Integer(length);
    }

    private void compareElementAttributes(Element control, Element test, NamedNodeMap controlAttr, NamedNodeMap testAttr, DifferenceListener listener) throws DifferenceFoundException {
        int i = 0;
        while (i < controlAttr.getLength()) {
            Attr nextAttr = (Attr)controlAttr.item(i);
            if (!this.isXMLNSAttribute(nextAttr)) {
                boolean isNamespacedAttr = this.isNamespaced(nextAttr);
                String attrName = this.getUnNamespacedNodeName(nextAttr, isNamespacedAttr);
                Attr compareTo = null;
                compareTo = isNamespacedAttr ? (Attr)testAttr.getNamedItemNS(nextAttr.getNamespaceURI(), attrName) : (Attr)testAttr.getNamedItem(attrName);
                if (compareTo != null) {
                    this.compareAttribute(nextAttr, compareTo, listener);
                    Attr attributeItem = (Attr)testAttr.item(i);
                    String testAttrName = "[attribute absent]";
                    if (attributeItem != null) {
                        testAttrName = this.getUnNamespacedNodeName(attributeItem);
                    }
                    this.compare(attrName, testAttrName, nextAttr, compareTo, listener, DifferenceConstants.ATTR_SEQUENCE);
                } else {
                    this.compare(attrName, null, control, test, listener, DifferenceConstants.ATTR_NAME_NOT_FOUND);
                }
            }
            ++i;
        }
    }

    private String getUnNamespacedNodeName(Node aNode) {
        return this.getUnNamespacedNodeName(aNode, this.isNamespaced(aNode));
    }

    private String getUnNamespacedNodeName(Node aNode, boolean isNamespacedNode) {
        if (isNamespacedNode) {
            return aNode.getLocalName();
        }
        return aNode.getNodeName();
    }

    private boolean isXMLNSAttribute(Attr attribute) {
        return "xmlns".equals(attribute.getPrefix()) || "xmlns".equals(attribute.getName());
    }

    protected void compareAttribute(Attr control, Attr test, DifferenceListener listener) throws DifferenceFoundException {
        this.controlTracker.visited(control);
        this.testTracker.visited(test);
        this.compare(control.getPrefix(), test.getPrefix(), control, test, listener, DifferenceConstants.NAMESPACE_PREFIX);
        this.compare(control.getValue(), test.getValue(), control, test, listener, DifferenceConstants.ATTR_VALUE);
        this.compare(control.getSpecified() ? Boolean.TRUE : Boolean.FALSE, test.getSpecified() ? Boolean.TRUE : Boolean.FALSE, control, test, listener, DifferenceConstants.ATTR_VALUE_EXPLICITLY_SPECIFIED);
    }

    protected void compareCDataSection(CDATASection control, CDATASection test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareCharacterData(control, test, listener, DifferenceConstants.CDATA_VALUE);
    }

    protected void compareComment(Comment control, Comment test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareCharacterData(control, test, listener, DifferenceConstants.COMMENT_VALUE);
    }

    protected void compareDocumentType(DocumentType control, DocumentType test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(control.getName(), test.getName(), control, test, listener, DifferenceConstants.DOCTYPE_NAME);
        this.compare(control.getPublicId(), test.getPublicId(), control, test, listener, DifferenceConstants.DOCTYPE_PUBLIC_ID);
        this.compare(control.getSystemId(), test.getSystemId(), control, test, listener, DifferenceConstants.DOCTYPE_SYSTEM_ID);
    }

    protected void compareProcessingInstruction(ProcessingInstruction control, ProcessingInstruction test, DifferenceListener listener) throws DifferenceFoundException {
        this.compare(control.getTarget(), test.getTarget(), control, test, listener, DifferenceConstants.PROCESSING_INSTRUCTION_TARGET);
        this.compare(control.getData(), test.getData(), control, test, listener, DifferenceConstants.PROCESSING_INSTRUCTION_DATA);
    }

    protected void compareText(Text control, Text test, DifferenceListener listener) throws DifferenceFoundException {
        this.compareCharacterData(control, test, listener, DifferenceConstants.TEXT_VALUE);
    }

    private void compareCharacterData(CharacterData control, CharacterData test, DifferenceListener listener, Difference difference) throws DifferenceFoundException {
        this.compare(control.getData(), test.getData(), control, test, listener, difference);
    }

    protected void compare(Object expected, Object actual, Node control, Node test, DifferenceListener listener, Difference difference) throws DifferenceFoundException {
        if (this.unequal(expected, actual)) {
            NodeDetail controlDetail = new NodeDetail(String.valueOf(expected), control, this.controlTracker.toXpathString());
            NodeDetail testDetail = new NodeDetail(String.valueOf(actual), test, this.testTracker.toXpathString());
            Difference differenceInstance = new Difference(difference, controlDetail, testDetail);
            listener.differenceFound(differenceInstance);
            if (this.controller.haltComparison(differenceInstance)) {
                throw flowControlException;
            }
        }
    }

    private boolean unequal(Object expected, Object actual) {
        return expected == null ? actual != null : this.unequalNotNull(expected, actual);
    }

    private boolean unequalNotNull(Object expected, Object actual) {
        if (XMLUnit.getIgnoreWhitespace() && expected instanceof String && actual instanceof String) {
            return !((String)expected).trim().equals(((String)actual).trim());
        }
        return !expected.equals(actual);
    }

    static {
        NULL_NODE = NULL_NODE;
        NOT_NULL_NODE = NOT_NULL_NODE;
        flowControlException = new DifferenceFoundException();
    }

    protected static final class DifferenceFoundException
    extends Exception {
        private DifferenceFoundException() {
            super("This exception is used to control flow");
        }
    }
}

