/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

class JavaMembers {
    static Hashtable classTable = new Hashtable();
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    private Constructor[] ctors;

    JavaMembers(Scriptable scope, Class cl) {
        this.cl = cl;
        this.reflect(scope, cl);
    }

    boolean has(String name, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        Member member = this.findExplicitFunction(name, isStatic);
        return member != null;
    }

    Object get(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Class<?> type;
        Object rval;
        Context cx;
        block9: {
            Hashtable ht = isStatic ? this.staticMembers : this.members;
            Object member = ht.get(name);
            if (!isStatic && member == null) {
                member = this.staticMembers.get(name);
            }
            if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic)) == null) {
                return Scriptable.NOT_FOUND;
            }
            if (member instanceof Scriptable) {
                return member;
            }
            cx = Context.getContext();
            try {
                if (member instanceof BeanProperty) {
                    BeanProperty bp = (BeanProperty)member;
                    try {
                        rval = bp.getter.invoke(javaObject, null);
                    }
                    catch (IllegalAccessException e) {
                        rval = NativeJavaMethod.retryIllegalAccessInvoke(bp.getter, javaObject, null, e);
                    }
                    type = bp.getter.getReturnType();
                    break block9;
                }
                Field field = (Field)member;
                rval = field.get(isStatic ? null : javaObject);
                type = field.getType();
            }
            catch (IllegalAccessException accEx) {
                throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
            }
            catch (InvocationTargetException e) {
                throw WrappedException.wrapException(JavaScriptException.wrapException(cx, scope, e));
            }
        }
        scope = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrap(cx, scope, rval, type);
    }

    Member findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        int sigStart = name.indexOf(40);
        Executable[] methodsOrCtors = null;
        NativeJavaMethod method = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors;
        } else if (sigStart > 0) {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj != null && obj instanceof NativeJavaMethod) {
                method = (NativeJavaMethod)obj;
                methodsOrCtors = method.getMethods();
            }
        }
        if (methodsOrCtors != null) {
            int i = 0;
            while (i < methodsOrCtors.length) {
                String nameWithSig = NativeJavaMethod.signature(methodsOrCtors[i]);
                if (name.equals(nameWithSig)) {
                    return methodsOrCtors[i];
                }
                ++i;
            }
        }
        return null;
    }

    Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        NativeFunction member = null;
        Member methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope);
            if (methodOrCtor instanceof Constructor) {
                NativeJavaConstructor fun = new NativeJavaConstructor((Constructor)methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = (NativeFunction)ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).getMethods().length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod((Method)methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    public void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.getField();
        }
        if (member instanceof BeanProperty) {
            try {
                Method method = ((BeanProperty)member).setter;
                if (method == null) {
                    throw this.reportMemberNotFound(name);
                }
                Class<?>[] types = method.getParameterTypes();
                Object[] args = new Object[]{NativeJavaObject.coerceType(types[0], value, true)};
                method.invoke(javaObject, args);
            }
            catch (IllegalAccessException accessEx) {
                throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
            }
            catch (InvocationTargetException e) {
                throw WrappedException.wrapException(JavaScriptException.wrapException(Context.getContext(), scope, e));
            }
        }
        Field field = null;
        try {
            field = (Field)member;
            if (field == null) {
                throw Context.reportRuntimeError1("msg.java.internal.private", name);
            }
            field.set(javaObject, NativeJavaObject.coerceType(field.getType(), value, true));
        }
        catch (ClassCastException e) {
            throw Context.reportRuntimeError1("msg.java.method.assign", name);
        }
        catch (IllegalAccessException accessEx) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException argEx) {
            throw Context.reportRuntimeError3("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName());
        }
    }

    Object[] getIds(boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        int len = ht.size();
        Object[] result = new Object[len];
        Enumeration keys = ht.keys();
        int i = 0;
        while (i < len) {
            result[i] = keys.nextElement();
            ++i;
        }
        return result;
    }

    Class getReflectedClass() {
        return this.cl;
    }

    void reflectField(Scriptable scope, Field field) {
        String name;
        int mods = field.getModifiers();
        if (!Modifier.isPublic(mods)) {
            return;
        }
        boolean isStatic = Modifier.isStatic(mods);
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name = field.getName());
        if (member != null) {
            if (member instanceof NativeJavaMethod) {
                NativeJavaMethod method = (NativeJavaMethod)member;
                FieldAndMethods fam = new FieldAndMethods(method.getMethods(), field, null);
                fam.setPrototype(ScriptableObject.getFunctionPrototype(scope));
                this.getFieldAndMethodsTable(isStatic).put(name, fam);
                ht.put(name, fam);
                return;
            }
            if (member instanceof Field) {
                Field oldField = (Field)member;
                if (oldField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                    ht.put(name, field);
                }
                return;
            }
            throw new RuntimeException("unknown member type");
        }
        ht.put(name, field);
    }

    void reflectMethod(Scriptable scope, Method method) {
        String name;
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            return;
        }
        boolean isStatic = Modifier.isStatic(mods);
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        NativeJavaMethod fun = (NativeJavaMethod)ht.get(name = method.getName());
        if (fun == null) {
            fun = new NativeJavaMethod();
            if (scope != null) {
                fun.setPrototype(ScriptableObject.getFunctionPrototype(scope));
            }
            ht.put(name, fun);
            fun.add(method);
        } else {
            fun.add(method);
        }
    }

    void reflect(Scriptable scope, Class cl) {
        Method[] methods = cl.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.reflectMethod(scope, methods[i]);
            ++i;
        }
        Field[] fields = cl.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            this.reflectField(scope, fields[i2]);
            ++i2;
        }
        this.makeBeanProperties(scope, false);
        this.makeBeanProperties(scope, true);
        this.ctors = cl.getConstructors();
    }

    Hashtable getFieldAndMethodsTable(boolean isStatic) {
        Hashtable fmht;
        Hashtable hashtable = fmht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (fmht == null) {
            fmht = new Hashtable(11);
            if (isStatic) {
                this.staticFieldAndMethods = fmht;
            } else {
                this.fieldAndMethods = fmht;
            }
        }
        return fmht;
    }

    void makeBeanProperties(Scriptable scope, boolean isStatic) {
        Hashtable ht = isStatic ? this.staticMembers : this.members;
        Hashtable<String, BeanProperty> toAdd = new Hashtable<String, BeanProperty>();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Class<?>[] params;
            Class<?> type;
            NativeJavaMethod getJavaMethod;
            Method[] getMethods;
            Object method;
            String nameComponent;
            String name = (String)e.nextElement();
            boolean memberIsGetMethod = name.startsWith("get");
            boolean memberIsIsMethod = name.startsWith("is");
            if (!memberIsGetMethod && !memberIsIsMethod || (nameComponent = name.substring(memberIsGetMethod ? 3 : 2)).length() == 0) continue;
            String beanPropertyName = nameComponent;
            if (Character.isUpperCase(nameComponent.charAt(0))) {
                if (nameComponent.length() == 1) {
                    beanPropertyName = nameComponent.substring(0, 1).toLowerCase();
                } else if (!Character.isUpperCase(nameComponent.charAt(1))) {
                    beanPropertyName = Character.toLowerCase(nameComponent.charAt(0)) + nameComponent.substring(1);
                }
            }
            if (ht.containsKey(beanPropertyName) || !((method = ht.get(name)) instanceof NativeJavaMethod) || (getMethods = (getJavaMethod = (NativeJavaMethod)method).getMethods()) == null || getMethods.length != 1 || (type = getMethods[0].getReturnType()) == null || (params = getMethods[0].getParameterTypes()) == null || params.length != 0 || isStatic && !Modifier.isStatic(getMethods[0].getModifiers())) continue;
            Method setMethod = null;
            String setter = "set" + nameComponent;
            if (ht.containsKey(setter) && (method = ht.get(setter)) instanceof NativeJavaMethod) {
                NativeJavaMethod setJavaMethod = (NativeJavaMethod)method;
                Method[] setMethods = setJavaMethod.getMethods();
                int pass = 1;
                while (pass <= 2 && setMethod == null) {
                    int i = 0;
                    while (i < setMethods.length) {
                        if (setMethods[i].getReturnType() == Void.TYPE && (!isStatic || Modifier.isStatic(setMethods[i].getModifiers())) && (params = setMethods[i].getParameterTypes()) != null && params.length == 1 && (pass == 1 && params[0] == type || pass == 2 && params[0].isAssignableFrom(type))) {
                            setMethod = setMethods[i];
                            break;
                        }
                        ++i;
                    }
                    ++pass;
                }
            }
            BeanProperty bp = new BeanProperty(getMethods[0], setMethod);
            toAdd.put(beanPropertyName, bp);
        }
        Enumeration e2 = toAdd.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            Object value = toAdd.get(key);
            ht.put(key, value);
        }
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic) {
        Hashtable ht;
        Hashtable hashtable = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        Hashtable<String, FieldAndMethods> result = new Hashtable<String, FieldAndMethods>(Math.max(len, 1));
        Enumeration e = ht.elements();
        while (len-- > 0) {
            FieldAndMethods fam = (FieldAndMethods)e.nextElement();
            fam = (FieldAndMethods)fam.clone();
            fam.setJavaObject(javaObject);
            result.put(fam.getName(), fam);
        }
        return result;
    }

    Constructor[] getConstructors() {
        return this.ctors;
    }

    static JavaMembers lookupClass(Scriptable scope, Class dynamicType, Class staticType) {
        Hashtable ct = classTable;
        Class cl = dynamicType;
        JavaMembers members = (JavaMembers)ct.get(cl);
        if (members != null) {
            return members;
        }
        if (staticType != null && staticType != dynamicType && !Modifier.isPublic(dynamicType.getModifiers()) && Modifier.isPublic(staticType.getModifiers()) && !(cl = staticType).isInterface()) {
            Class parentType = dynamicType;
            while (parentType != null && parentType != ScriptRuntime.ObjectClass) {
                if (Modifier.isPublic(parentType.getModifiers())) {
                    cl = parentType;
                    break;
                }
                parentType = parentType.getSuperclass();
            }
        }
        try {
            members = new JavaMembers(scope, cl);
        }
        catch (SecurityException e) {
            if (cl != staticType) {
                members = new JavaMembers(scope, staticType);
            }
            throw e;
        }
        if (Context.isCachingEnabled) {
            ct.put(cl, members);
        }
        return members;
    }

    RuntimeException reportMemberNotFound(String memberName) {
        return Context.reportRuntimeError2("msg.java.member.not.found", this.cl.getName(), memberName);
    }
}

