/*
 * Copyright (c) 2006 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of the License "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: 
 *
 */

function VerticalLabel() {
}

VerticalLabel.prototype.draw = function(instance, laf, graphics) {
	var font = laf.getFont("NormalFont");
	graphics.setFont(font);
	graphics.setBackground(laf.getColor("EEikColorControlBackground"));
	
	var properties = instance.properties;
	var lineWidth = properties.lineWidth;
	var halfLineWidth = lineWidth/2;
	var textBounds = new Rectangle(halfLineWidth, halfLineWidth, 
		properties.size.width - halfLineWidth, 
		properties.size.height - halfLineWidth);
	var x = lineWidth + 1;
	var y = properties.size.height - lineWidth - 1;
	graphics.drawRotatedString(properties.text, textBounds, x, y, -1.57, true);
	
	if (lineWidth > 0) {
		graphics.setLineWidth(lineWidth);
		x = y = halfLineWidth;
	
		graphics.drawRectangle(x, y, 
			properties.size.width-lineWidth, 
			properties.size.height-lineWidth);
	}
}

VerticalLabel.prototype.getPreferredSize = function(instance, laf, wHint, hHint) {
	var text = instance.properties.text;
	if (text == null)
		return new Point(0, 0);
		
	var font = laf.getFont("NormalFont");
	var extent = TextRendering.formattedStringExtent(font, text, new Point(1000, 1000), 0, 0);
	var lineWidth = instance.properties.lineWidth;
	var parentBounds = instance.parent.getLayoutBounds();
	
	return new Point(parentBounds.width, extent.x + lineWidth + 1);
}
