/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.Transform;
import org.w3c.dom.Node;

public class NodeInputStream
extends InputStream {
    private final Node rootNode;
    private final ByteArrayOutputStream nodeContentBytes;
    private final Properties outputProperties;
    private int atPos = 0;

    public NodeInputStream(Node rootNode) {
        this(rootNode, null);
    }

    public NodeInputStream(Node rootNode, Properties outputProperties) {
        this.rootNode = rootNode;
        this.nodeContentBytes = new ByteArrayOutputStream();
        this.outputProperties = outputProperties;
    }

    private void ensureContentAvailable() throws IOException {
        if (this.nodeContentBytes.size() > 0) {
            return;
        }
        try {
            Transform serializeTransform = new Transform(this.rootNode);
            if (this.outputProperties != null) {
                serializeTransform.setOutputProperties(this.outputProperties);
            }
            StreamResult byteResult = new StreamResult(this.nodeContentBytes);
            serializeTransform.transformTo(byteResult);
        }
        catch (Exception e) {
            throw new IOException("Unable to serialize document to outputstream: " + e.toString());
        }
    }

    public int read() throws IOException {
        this.ensureContentAvailable();
        if (this.reallyAvailable() == 0) {
            return -1;
        }
        byte contentByte = this.nodeContentBytes.toByteArray()[this.atPos];
        ++this.atPos;
        return contentByte;
    }

    public void close() throws IOException {
        this.atPos = 0;
    }

    public int available() throws IOException {
        this.ensureContentAvailable();
        return this.reallyAvailable();
    }

    private int reallyAvailable() {
        return this.nodeContentBytes.size() - this.atPos;
    }
}

