/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.GlyfCompositeDescript;
import org.apache.batik.svggen.font.table.GlyfDescript;
import org.apache.batik.svggen.font.table.GlyfSimpleDescript;
import org.apache.batik.svggen.font.table.LocaTable;
import org.apache.batik.svggen.font.table.Table;

public class GlyfTable
implements Table {
    private byte[] buf = null;
    private GlyfDescript[] descript;

    protected GlyfTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, LocaTable locaTable) {
        short s;
        int n2;
        int n3;
        if (this.buf == null) {
            return;
        }
        this.descript = new GlyfDescript[n];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        for (n3 = 0; n3 < n; ++n3) {
            n2 = locaTable.getOffset((short)(n3 + 1)) - locaTable.getOffset(n3);
            if (n2 > 0) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(locaTable.getOffset(n3));
                s = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
                if (s < 0) continue;
                this.descript[n3] = new GlyfSimpleDescript(this, s, byteArrayInputStream);
                continue;
            }
            this.descript[n3] = null;
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = locaTable.getOffset((short)(n3 + 1)) - locaTable.getOffset(n3);
            if (n2 <= 0) continue;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(locaTable.getOffset(n3));
            s = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
            if (s >= 0) continue;
            this.descript[n3] = new GlyfCompositeDescript(this, byteArrayInputStream);
        }
        this.buf = null;
    }

    public GlyfDescript getDescription(int n) {
        return this.descript[n];
    }

    public int getType() {
        return 1735162214;
    }
}

