/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.PrintStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.Dim;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;

public class Main
implements ContextListener {
    Dim dim = new Dim();
    SwingGui debugGui;

    public Main(String title) {
        this.debugGui = new SwingGui(this.dim, title);
        this.dim.callback = this.debugGui;
    }

    public void doBreak() {
        this.dim.breakFlag = true;
    }

    public void setBreakOnExceptions(boolean value) {
        this.dim.breakOnExceptions = value;
        this.debugGui.menubar.breakOnExceptions.setSelected(value);
    }

    public void setBreakOnEnter(boolean value) {
        this.dim.breakOnEnter = value;
        this.debugGui.menubar.breakOnEnter.setSelected(value);
    }

    public void setBreakOnReturn(boolean value) {
        this.dim.breakOnReturn = value;
        this.debugGui.menubar.breakOnReturn.setSelected(value);
    }

    public void clearAllBreakpoints() {
        this.dim.clearAllBreakpoints();
    }

    public void go() {
        this.dim.go();
    }

    public void setScope(Scriptable scope) {
        this.setScopeProvider(IProxy.newScopeProvider(scope));
    }

    public void setScopeProvider(ScopeProvider p) {
        this.dim.scopeProvider = p;
    }

    public void setExitAction(Runnable r) {
        this.debugGui.exitAction = r;
    }

    public InputStream getIn() {
        return this.debugGui.console.getIn();
    }

    public PrintStream getOut() {
        return this.debugGui.console.getOut();
    }

    public PrintStream getErr() {
        return this.debugGui.console.getErr();
    }

    public void pack() {
        this.debugGui.pack();
    }

    public void setSize(int w, int h) {
        ((Component)this.debugGui).setSize(w, h);
    }

    public void setSize(Dimension dimension) {
        ((Component)this.debugGui).setSize(dimension.width, dimension.height);
    }

    public void setVisible(boolean flag) {
        this.debugGui.setVisible(flag);
    }

    public boolean isVisible() {
        return this.debugGui.isVisible();
    }

    public void dispose() {
        this.debugGui.dispose();
    }

    public void attachTo(ContextFactory factory) {
        this.dim.attachTo(factory);
    }

    public void setOptimizationLevel(int level) {
    }

    public void contextEntered(Context cx) {
        throw new IllegalStateException();
    }

    public void contextExited(Context cx) {
        throw new IllegalStateException();
    }

    public void contextCreated(Context cx) {
        throw new IllegalStateException();
    }

    public void contextReleased(Context cx) {
        throw new IllegalStateException();
    }

    public static void main(String[] args) {
        Main main = new Main("Rhino JavaScript Debugger");
        main.doBreak();
        main.setExitAction(new IProxy(1));
        System.setIn(main.getIn());
        System.setOut(main.getOut());
        System.setErr(main.getErr());
        Global global = org.mozilla.javascript.tools.shell.Main.getGlobal();
        global.setIn(main.getIn());
        global.setOut(main.getOut());
        global.setErr(main.getErr());
        main.attachTo(org.mozilla.javascript.tools.shell.Main.shellContextFactory);
        main.setScope(global);
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
        org.mozilla.javascript.tools.shell.Main.exec(args);
    }

    public static void mainEmbedded(String title) {
        ContextFactory factory = ContextFactory.getGlobal();
        Global global = new Global();
        global.init(factory);
        Main.mainEmbedded(factory, global, title);
    }

    public static void mainEmbedded(ContextFactory factory, Scriptable scope, String title) {
        Main.mainEmbeddedImpl(factory, scope, title);
    }

    public static void mainEmbedded(ContextFactory factory, ScopeProvider scopeProvider, String title) {
        Main.mainEmbeddedImpl(factory, scopeProvider, title);
    }

    private static void mainEmbeddedImpl(ContextFactory factory, Object scopeProvider, String title) {
        if (title == null) {
            title = "Rhino JavaScript Debugger (embedded usage)";
        }
        Main main = new Main(title);
        main.doBreak();
        main.setExitAction(new IProxy(1));
        main.attachTo(factory);
        if (scopeProvider instanceof ScopeProvider) {
            main.setScopeProvider((ScopeProvider)scopeProvider);
        } else {
            Scriptable scope = (Scriptable)scopeProvider;
            if (scope instanceof Global) {
                Global global = (Global)scope;
                global.setIn(main.getIn());
                global.setOut(main.getOut());
                global.setErr(main.getErr());
            }
            main.setScope(scope);
        }
        main.pack();
        main.setSize(600, 460);
        main.setVisible(true);
    }

    private static class IProxy
    implements Runnable,
    ScopeProvider {
        static final int EXIT_ACTION = 1;
        static final int SCOPE_PROVIDER = 2;
        private final int type;
        Scriptable scope;

        IProxy(int type) {
            this.type = type;
        }

        public static ScopeProvider newScopeProvider(Scriptable scope) {
            IProxy scopeProvider = new IProxy(2);
            scopeProvider.scope = scope;
            return scopeProvider;
        }

        public void run() {
            if (this.type != 1) {
                Kit.codeBug();
            }
            System.exit(0);
        }

        public Scriptable getScope() {
            if (this.type != 2) {
                Kit.codeBug();
            }
            if (this.scope == null) {
                Kit.codeBug();
            }
            return this.scope;
        }
    }
}

