/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.color.ColorSpace;
import java.awt.image.RenderedImage;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public abstract class AbstractColorInterpolationRable
extends AbstractRable {
    protected boolean csLinear = true;

    protected AbstractColorInterpolationRable() {
    }

    protected AbstractColorInterpolationRable(Filter filter) {
        super(filter);
    }

    protected AbstractColorInterpolationRable(Filter filter, Map map) {
        super(filter, map);
    }

    protected AbstractColorInterpolationRable(List list) {
        super(list);
    }

    protected AbstractColorInterpolationRable(List list, Map map) {
        super(list, map);
    }

    public boolean isColorSpaceLinear() {
        return this.csLinear;
    }

    public void setColorSpaceLinear(boolean bl) {
        this.touch();
        this.csLinear = bl;
    }

    public ColorSpace getOperationColorSpace() {
        if (this.csLinear) {
            return ColorSpace.getInstance(1004);
        }
        return ColorSpace.getInstance(1000);
    }

    protected CachableRed convertSourceCS(CachableRed cachableRed) {
        if (this.csLinear) {
            return GraphicsUtil.convertToLsRGB(cachableRed);
        }
        return GraphicsUtil.convertTosRGB(cachableRed);
    }

    protected CachableRed convertSourceCS(RenderedImage renderedImage) {
        return this.convertSourceCS(GraphicsUtil.wrap(renderedImage));
    }
}

